/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.wizards.Utils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.util.Utilities;

public class TestUtil {
    private static final String JAVA_SOURCES_SUFFIX = "java";
    private static final String JAVA_MIME_TYPE = "text/x-java";

    private static String getTestClassSuffix() {
        return JUnitSettings.TEST_CLASSNAME_SUFFIX;
    }

    private static String getTestClassPrefix() {
        return JUnitSettings.TEST_CLASSNAME_PREFIX;
    }

    private static String getTestSuiteSuffix() {
        return JUnitSettings.SUITE_CLASSNAME_SUFFIX;
    }

    private static String getTestSuitePrefix() {
        return JUnitSettings.SUITE_CLASSNAME_PREFIX;
    }

    private static String getRootSuiteName() {
        return JUnitSettings.getDefault().getRootSuiteClassName();
    }

    public static String getTestClassFullName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 != null) {
            stringBuffer.append(string2.replace('.', '/'));
            if (stringBuffer.length() > 0) {
                stringBuffer.append('/');
            }
        }
        stringBuffer.append(TestUtil.getTestClassName(string));
        return stringBuffer.toString();
    }

    public static String getTestClassName(String string) {
        return TestUtil.getTestClassPrefix() + string + TestUtil.getTestClassSuffix();
    }

    public static String convertPackage2SuiteName(String string) {
        if (string.length() == 0) {
            return TestUtil.getRootSuiteName();
        }
        int n = string.lastIndexOf(47);
        String string2 = n > -1 ? string.substring(n + 1) : string;
        string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
        return string + "/" + TestUtil.getTestSuitePrefix() + string2 + TestUtil.getTestSuiteSuffix();
    }

    public static String convertClass2TestName(String string) {
        int n = string.lastIndexOf(47);
        String string2 = n > -1 ? string.substring(0, n) : "";
        String string3 = n > -1 ? string.substring(n + 1) : string;
        string3 = string3.substring(0, 1).toUpperCase() + string3.substring(1);
        if (string2.length() > 0) {
            string2 = string2 + "/";
        }
        return string2 + TestUtil.getTestClassPrefix() + string3 + TestUtil.getTestClassSuffix();
    }

    public static void notifyUser(String string) {
        TestUtil.notifyUser(string, 0);
    }

    public static void notifyUser(String string, int n) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, n);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    public static FileObject getFileObjectFromNode(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (null != dataObject) {
            return dataObject.getPrimaryFile();
        }
        DataFolder dataFolder = (DataFolder)node.getCookie(DataFolder.class);
        if (null != dataFolder) {
            return dataFolder.getPrimaryFile();
        }
        ClassElement classElement = (ClassElement)node.getCookie(ClassElement.class);
        if (null != classElement) {
            while (null != (node = node.getParentNode())) {
                dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? TestUtil.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (null == dataObject) continue;
                return dataObject.getPrimaryFile();
            }
        }
        return null;
    }

    static boolean isClassTest(JavaClass javaClass) {
        return TestUtil.isClassImplementingTestInterface(javaClass);
    }

    static boolean isClassImplementingTestInterface(JavaClass javaClass) {
        JavaModelPackage javaModelPackage = (JavaModelPackage)javaClass.refImmediatePackage();
        JavaClass javaClass2 = (JavaClass)javaModelPackage.getJavaClass().resolve("junit.framework.Test");
        return javaClass.isSubTypeOf((ClassDefinition)javaClass2);
    }

    static boolean isClassException(JavaClass javaClass) {
        JavaModelPackage javaModelPackage = (JavaModelPackage)javaClass.refImmediatePackage();
        ClassDefinition classDefinition = (ClassDefinition)javaModelPackage.getType().resolve("java.lang.Throwable");
        return javaClass.isSubTypeOf(classDefinition);
    }

    static Collection getAllClassesFromFile(FileObject fileObject) {
        if (fileObject == null) {
            return Collections.EMPTY_LIST;
        }
        Iterator iterator = JavaModel.getResource((FileObject)fileObject).getChildren().iterator();
        LinkedList<JavaClass> linkedList = new LinkedList<JavaClass>();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!(element instanceof JavaClass)) continue;
            linkedList.add((JavaClass)element);
        }
        return linkedList;
    }

    public static JavaClass getMainJavaClass(Resource resource) {
        Iterator iterator = resource.getChildren().iterator();
        String string = TestUtil.fileToClassName(resource.getName());
        if (string != null) {
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (!(element instanceof JavaClass) || !((JavaClass)element).getName().equals(string)) continue;
                return (JavaClass)element;
            }
        }
        return null;
    }

    static String fileToClassName(String string) {
        if (string.endsWith(".java")) {
            return string.substring(0, string.length() - 5).replace('/', '.');
        }
        return null;
    }

    public static List getJavaFileNames(FileObject fileObject, ClassPath classPath) {
        FileObject[] fileObjectArray = fileObject.getChildren();
        if (fileObjectArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> arrayList = new ArrayList<String>(fileObjectArray.length);
        for (int i = 0; i < fileObjectArray.length; ++i) {
            DataObject dataObject;
            FileObject fileObject2 = fileObjectArray[i];
            if (fileObject2.isFolder() || fileObject2.isVirtual() || !fileObject2.getMIMEType().equals(JAVA_MIME_TYPE)) continue;
            try {
                dataObject = DataObject.find((FileObject)fileObject2);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                continue;
            }
            Resource resource = JavaModel.getResource((FileObject)dataObject.getPrimaryFile());
            arrayList.add(TestUtil.getMainJavaClass(resource).getName());
        }
        return arrayList.isEmpty() ? Collections.EMPTY_LIST : arrayList;
    }

    public static List filterFeatures(JavaClass javaClass, Class clazz) {
        LinkedList<Feature> linkedList = new LinkedList<Feature>();
        Iterator iterator = javaClass.getFeatures().iterator();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            if (!clazz.isAssignableFrom(feature.getClass())) continue;
            linkedList.add(feature);
        }
        return linkedList;
    }

    public static Feature getFeatureByName(JavaClass javaClass, Class clazz, String string) {
        if (!Feature.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("cls is not Feature");
        }
        Iterator iterator = javaClass.getFeatures().iterator();
        while (iterator.hasNext()) {
            Feature feature;
            Object e = iterator.next();
            if (!clazz.isAssignableFrom(e.getClass()) || !(feature = (Feature)e).getName().equals(string)) continue;
            return feature;
        }
        return null;
    }

    public static JavaClass getClassBySimpleName(JavaClass javaClass, String string) {
        return javaClass.getInnerClass(string, false);
    }

    public static String createNewName(int n, Set set) {
        String string;
        while (set.contains(string = "p" + n++)) {
        }
        return string;
    }

    public static Parameter cloneParam(Parameter parameter, JavaModelPackage javaModelPackage, int n, Set set) {
        String string = parameter.getName();
        if (string == null || string.length() == 0 || set.contains(string)) {
            string = TestUtil.createNewName(n, set);
        }
        set.add(string);
        Parameter parameter2 = javaModelPackage.getParameter().createParameter(string, parameter.getAnnotations(), parameter.isFinal(), null, 0, parameter.isVarArg());
        parameter2.setType(parameter.getType());
        return parameter2;
    }

    public static List cloneParams(List list, JavaModelPackage javaModelPackage) {
        Iterator iterator = list.iterator();
        LinkedList<Parameter> linkedList = new LinkedList<Parameter>();
        int n = 0;
        HashSet hashSet = new HashSet(list.size() * 2);
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            linkedList.add(TestUtil.cloneParam(parameter, javaModelPackage, n++, hashSet));
        }
        return linkedList;
    }

    public static List getParameterTypes(List list) {
        ArrayList<Type> arrayList = new ArrayList<Type>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Parameter)iterator.next()).getType());
        }
        return arrayList;
    }

    public static List collectFeatures(JavaClass javaClass, Class clazz, int n, boolean bl) {
        return TestUtil.collectFeatures(javaClass, clazz, n, bl, new LinkedList(), new HashSet());
    }

    private static List collectFeatures(JavaClass javaClass, Class clazz, int n, boolean bl, List list, Set set) {
        Feature feature;
        if (!set.add(javaClass)) {
            return list;
        }
        int n2 = javaClass.isInterface() ? 1024 : 0;
        Iterator iterator = TestUtil.filterFeatures(javaClass, clazz).iterator();
        while (iterator.hasNext()) {
            feature = (Feature)iterator.next();
            if (((feature.getModifiers() | n2) & n) != n) continue;
            list.add(feature);
        }
        if (bl) {
            feature = javaClass.getSuperClass();
            if (feature != null) {
                TestUtil.collectFeatures((JavaClass)feature, clazz, n, bl, list, set);
            }
            Iterator iterator2 = javaClass.getInterfaces().iterator();
            while (iterator2.hasNext()) {
                TestUtil.collectFeatures((JavaClass)iterator2.next(), clazz, n, bl, list, set);
            }
        }
        return list;
    }

    public static boolean hasMainMethod(JavaClass javaClass) {
        JavaModelPackage javaModelPackage = (JavaModelPackage)javaClass.refImmediatePackage();
        return javaClass.getMethod("main", Collections.singletonList(javaModelPackage.getArray().resolveArray(TestUtil.getStringType(javaModelPackage))), false) != null;
    }

    public static Type getStringType(JavaModelPackage javaModelPackage) {
        return javaModelPackage.getType().resolve("java.lang.String");
    }

    public static TypeReference getTypeReference(JavaModelPackage javaModelPackage, String string) {
        return javaModelPackage.getMultipartId().createMultipartId(string, null, Collections.EMPTY_LIST);
    }

    public static Object[] getTestTargets(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return new Object[0];
        }
        SourceGroup sourceGroup = TestUtil.findSourceGroupOwner(fileObject);
        if (sourceGroup == null) {
            return new Object[0];
        }
        URL[] uRLArray = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (uRLArray.length == 0) {
            return new Object[0];
        }
        boolean bl = false;
        Object[] objectArray = new FileObject[uRLArray.length];
        for (int i = 0; i < uRLArray.length; ++i) {
            objectArray[i] = URLMapper.findFileObject((URL)uRLArray[i]);
            if (objectArray[i] == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("No FileObject found for the following URL: " + uRLArray[i]));
                bl = true;
                continue;
            }
            if (FileOwnerQuery.getOwner((FileObject)objectArray[i]) == project) continue;
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Source root found by FileOwnerQuery points to a different project for the following URL: " + uRLArray[i]));
            objectArray[i] = null;
            bl = true;
        }
        if (bl) {
            Object[] objectArray2 = TestUtil.skipNulls(objectArray, new FileObject[0]);
            if (objectArray2.length == 0) {
                return new Object[0];
            }
            objectArray = (FileObject[])objectArray2;
        }
        Object[] objectArray3 = new Object[objectArray.length];
        Map map = TestUtil.getFileObject2SourceGroupMap(project);
        for (int i = 0; i < objectArray.length; ++i) {
            Object v = map.get(objectArray[i]);
            objectArray3[i] = v != null ? v : objectArray[i];
        }
        return objectArray3;
    }

    public static SourceGroup findSourceGroupOwner(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        return TestUtil.findSourceGroupOwner(project, fileObject);
    }

    public static SourceGroup findSourceGroupOwner(Project project, FileObject fileObject) {
        SourceGroup[] sourceGroupArray = new Utils(project).getJavaSourceGroups();
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            SourceGroup sourceGroup = sourceGroupArray[i];
            FileObject fileObject2 = sourceGroup.getRootFolder();
            if (fileObject != fileObject2 && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject) || !sourceGroup.contains(fileObject)) continue;
            return sourceGroup;
        }
        return null;
    }

    public static Collection findSourceGroupOwners(Project project, String string) {
        SourceGroup[] sourceGroupArray = new Utils(project).getJavaSourceGroups();
        if (sourceGroupArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        String string2 = string.replace('.', '/') + ".java";
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>(4);
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            SourceGroup sourceGroup = sourceGroupArray[i];
            FileObject fileObject = sourceGroup.getRootFolder();
            FileObject fileObject2 = fileObject.getFileObject(string2);
            if (fileObject2 == null || !FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) || !sourceGroup.contains(fileObject2)) continue;
            arrayList.add(sourceGroup);
        }
        if (arrayList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    public static Object[] skipNulls(Object[] objectArray, Object[] objectArray2) {
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            arrayList.add(objectArray[i]);
        }
        return arrayList.toArray(objectArray2);
    }

    public static Map getFileObject2SourceGroupMap(Project project) {
        SourceGroup[] sourceGroupArray = new Utils(project).getJavaSourceGroups();
        if (sourceGroupArray.length == 0) {
            return Collections.EMPTY_MAP;
        }
        if (sourceGroupArray.length == 1) {
            return Collections.singletonMap(sourceGroupArray[0].getRootFolder(), sourceGroupArray[0]);
        }
        HashMap<FileObject, SourceGroup> hashMap = new HashMap<FileObject, SourceGroup>(Math.round((float)sourceGroupArray.length * 1.4f + 0.5f), 0.75f);
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            hashMap.put(sourceGroupArray[i].getRootFolder(), sourceGroupArray[i]);
        }
        return hashMap;
    }

    public static boolean isValidPackageName(String string) {
        if (string.length() > 0 && string.charAt(0) == '.') {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("".equals(string2)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)string2)) continue;
            return false;
        }
        return true;
    }
}

