/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.File;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.modules.junit.output.AntSessionInfo;
import org.netbeans.modules.junit.output.JUnitOutputReader;

public final class JUnitAntLogger
extends AntLogger {
    private static final int[] LEVELS_OF_INTEREST;
    private static final String[] JUNIT_STRARR;
    private static final String[] JAVA_STRARR;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean interestedInSession(AntSession antSession) {
        return true;
    }

    public String[] interestedInTargets(AntSession antSession) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession antSession) {
        int n = this.getSessionType(antSession);
        return n == 2 ? JUNIT_STRARR : (n == 3 ? JAVA_STRARR : AntLogger.NO_TASKS);
    }

    private static int detectSessionType(AntSession antSession) {
        String[] stringArray = antSession.getOriginatingTargets();
        if (stringArray.length == 0) {
            return 0;
        }
        if (stringArray.length == 1) {
            String string = stringArray[0];
            if (string.startsWith("test") && (string.length() == 4 || !Character.isLetter(string.charAt(4))) || string.equals("run-tests")) {
                return 2;
            }
            if (string.startsWith("debug-test") && (string.length() == 10 || !Character.isLetter(string.charAt(10)))) {
                return 3;
            }
        }
        return 1;
    }

    public boolean interestedInScript(File file, AntSession antSession) {
        return true;
    }

    public int[] interestedInLogLevels(AntSession antSession) {
        return LEVELS_OF_INTEREST;
    }

    public void messageLogged(AntEvent antEvent) {
        if (antEvent.getLogLevel() != 3) {
            this.getOutputReader(antEvent.getSession()).messageLogged(antEvent);
        } else {
            this.verboseMessageLogged(antEvent);
        }
    }

    private void verboseMessageLogged(AntEvent antEvent) {
        String string = antEvent.getTaskName();
        if (string == null) {
            return;
        }
        AntSession antSession = antEvent.getSession();
        String[] stringArray = this.interestedInTasks(antSession);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            this.getOutputReader(antSession).verboseMessageLogged(antEvent);
            break;
        }
    }

    public void taskStarted(AntEvent antEvent) {
        this.getOutputReader(antEvent.getSession()).testTaskStarted();
    }

    public void buildFinished(AntEvent antEvent) {
        AntSession antSession = antEvent.getSession();
        AntSessionInfo antSessionInfo = this.getSessionInfo(antSession);
        int n = antSessionInfo.sessionType;
        if (n != 0 && n != 1) {
            this.getOutputReader(antEvent.getSession()).buildFinished(antEvent);
        }
        antSession.putCustomData((AntLogger)this, null);
    }

    private int getSessionType(AntSession antSession) {
        AntSessionInfo antSessionInfo = this.getSessionInfo(antSession);
        if (!$assertionsDisabled && antSessionInfo == null) {
            throw new AssertionError();
        }
        int n = antSessionInfo.sessionType;
        if (n == 0 && (n = JUnitAntLogger.detectSessionType(antSession)) != 0) {
            antSessionInfo.sessionType = n;
            if (n != 1) {
                this.getOutputReader(antSession).testTargetStarted();
            }
        }
        return n;
    }

    private JUnitOutputReader getOutputReader(AntSession antSession) {
        AntSessionInfo antSessionInfo = this.getSessionInfo(antSession);
        JUnitOutputReader jUnitOutputReader = antSessionInfo.outputReader;
        if (jUnitOutputReader == null) {
            antSessionInfo.outputReader = jUnitOutputReader = new JUnitOutputReader(antSession, this.getSessionType(antSession), antSessionInfo.getTimeOfSessionStart());
        }
        return jUnitOutputReader;
    }

    private AntSessionInfo getSessionInfo(AntSession antSession) {
        AntSessionInfo antSessionInfo;
        Object object = antSession.getCustomData((AntLogger)this);
        if (!$assertionsDisabled && object != null && !(object instanceof AntSessionInfo)) {
            throw new AssertionError();
        }
        if (object != null) {
            antSessionInfo = (AntSessionInfo)object;
        } else {
            antSessionInfo = new AntSessionInfo();
            antSession.putCustomData((AntLogger)this, (Object)antSessionInfo);
        }
        return antSessionInfo;
    }

    static {
        $assertionsDisabled = !JUnitAntLogger.class.desiredAssertionStatus();
        LEVELS_OF_INTEREST = new int[]{2, 1, 3};
        JUNIT_STRARR = new String[]{"junit"};
        JAVA_STRARR = new String[]{"java"};
    }
}

