/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntSession;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.junit.output.Manager;
import org.netbeans.modules.junit.output.RegexpUtils;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.XmlOutputParser;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.xml.sax.SAXException;

final class JUnitOutputReader {
    private static final int MAX_REPORT_FILE_SIZE = 524288;
    private static final int UPDATE_DELAY = 300;
    private boolean testTargetStarted = false;
    private boolean testTaskStarted = false;
    private boolean reportStarted = false;
    private final AntSession session;
    private final int sessionType;
    private final File antScript;
    private final long timeOfSessionStart;
    private RegexpUtils regexp = RegexpUtils.getInstance();
    private Report topReport;
    private Report report;
    private Report.Testcase testcase;
    private Report.Trouble trouble;
    private String suiteName;
    private List callstackBuffer;
    private StringBuffer xmlOutputBuffer;
    private boolean readingOutputReport;
    private boolean lastHeaderBrief;
    private boolean waitingForIssueStatus;
    private final Manager manager = Manager.getInstance();
    private String classpath;
    private ClassPath platformSources;
    static final /* synthetic */ boolean $assertionsDisabled;

    JUnitOutputReader(AntSession antSession, int n, long l) {
        this.session = antSession;
        this.sessionType = n;
        this.antScript = antSession.getOriginatingScript();
        this.timeOfSessionStart = l;
    }

    void verboseMessageLogged(AntEvent antEvent) {
        String string;
        ClassPath classPath;
        String string2 = antEvent.getMessage();
        if (string2 == null) {
            return;
        }
        Matcher matcher = RegexpUtils.CLASSPATH_ARGS.matcher(string2);
        if (matcher.find()) {
            this.classpath = matcher.group(1);
        }
        if ((matcher = RegexpUtils.JAVA_EXECUTABLE.matcher(string2)).find() && (classPath = this.findPlatformSources(string = matcher.group(1))) != null) {
            this.platformSources = classPath;
        }
    }

    void messageLogged(AntEvent antEvent) {
        Object object;
        String string = antEvent.getMessage();
        if (string == null) {
            return;
        }
        if (this.waitingForIssueStatus) {
            if (!$assertionsDisabled && this.testcase == null) {
                throw new AssertionError();
            }
            object = this.regexp.getTestcaseIssuePattern().matcher(string);
            if (((Matcher)object).matches()) {
                boolean bl = ((Matcher)object).group(1) == null;
                this.trouble = this.testcase.trouble = new Report.Trouble(bl);
                this.waitingForIssueStatus = false;
                return;
            }
            this.report.reportTest(this.testcase);
            this.waitingForIssueStatus = false;
        }
        if (this.xmlOutputBuffer != null) {
            this.xmlOutputBuffer.append(string).append('\n');
            if (string.equals("</testsuite>")) {
                this.closePreviousReport();
            }
            return;
        }
        if (this.readingOutputReport) {
            if (string.startsWith("--------") && ((Matcher)(object = this.regexp.getOutputDelimPattern().matcher(string))).matches() && ((Matcher)object).group(1) == null) {
                this.readingOutputReport = false;
            }
            return;
        }
        if (this.trouble != null) {
            if (this.trouble.exceptionClsName == null) {
                object = this.regexp.getTestcaseExceptionPattern().matcher(string);
                if (((Matcher)object).matches()) {
                    this.trouble.exceptionClsName = ((Matcher)object).group(1);
                    String string2 = ((Matcher)object).group(2);
                    if (string2 != null) {
                        this.trouble.message = string2;
                    }
                }
                return;
            }
            String string3 = RegexpUtils.specialTrim(string);
            if (string3.length() == 0) {
                if (this.callstackBuffer != null) {
                    this.trouble.stackTrace = this.callstackBuffer.toArray(new String[this.callstackBuffer.size()]);
                    this.callstackBuffer = null;
                }
                this.report.reportTest(this.testcase);
                this.trouble = null;
                this.testcase = null;
                return;
            }
            if (string3.startsWith("[catch] ")) {
                string3 = string3.substring("[catch] ".length());
            }
            if (string3.startsWith("at ") && ((Matcher)(object = this.regexp.getCallstackLinePattern().matcher(string))).matches()) {
                if (this.callstackBuffer == null) {
                    this.callstackBuffer = new ArrayList(8);
                }
                this.callstackBuffer.add(string3.substring("at ".length()));
                this.setClasspathSourceRoots();
                return;
            }
            if (this.callstackBuffer == null && this.trouble.message != null) {
                this.trouble.message = this.trouble.message + '\n' + string;
            }
            return;
        }
        if (string.startsWith("Testcase: ")) {
            boolean bl;
            if (this.report == null) {
                return;
            }
            object = string.substring("Testcase: ".length());
            boolean bl2 = this.lastHeaderBrief ? this.tryParseBriefHeader((String)object) || !(this.lastHeaderBrief = !this.tryParsePlainHeader((String)object)) : (bl = this.tryParsePlainHeader((String)object) || (this.lastHeaderBrief = this.tryParseBriefHeader((String)object)));
            if (bl) {
                this.waitingForIssueStatus = !this.lastHeaderBrief;
            }
        } else if (string.startsWith("--------")) {
            if (this.report == null) {
                return;
            }
            object = this.regexp.getOutputDelimPattern().matcher(string);
            if (((Matcher)object).matches()) {
                this.readingOutputReport = true;
            }
        } else if (string.startsWith("<?xml")) {
            object = this.regexp.getXmlDeclPattern().matcher(string.trim());
            if (((Matcher)object).matches()) {
                this.suiteStarted(null);
                this.xmlOutputBuffer = new StringBuffer(4096);
                this.xmlOutputBuffer.append(string);
            }
        } else if (string.startsWith("Testsuite: ")) {
            this.suiteName = string.substring("Testsuite: ".length());
            if (this.regexp.getFullJavaIdPattern().matcher(this.suiteName).matches()) {
                this.suiteStarted(this.suiteName);
                this.report.resultsDir = JUnitOutputReader.determineResultsDir(antEvent);
            }
        } else if (string.startsWith("Tests run: ")) {
            if (this.report == null) {
                return;
            }
            object = this.regexp.getSuiteStatsPattern().matcher(string);
            if (((Matcher)object).matches()) {
                if (!$assertionsDisabled && this.report == null) {
                    throw new AssertionError();
                }
                try {
                    this.report.totalTests = Integer.parseInt(((Matcher)object).group(1));
                    this.report.failures = Integer.parseInt(((Matcher)object).group(2));
                    this.report.errors = Integer.parseInt(((Matcher)object).group(3));
                    this.report.elapsedTimeMillis = this.regexp.parseTimeMillis(((Matcher)object).group(4));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            }
        } else if (this.suiteName != null && string.startsWith("Test ") && string.endsWith(" FAILED") && string.equals("Test " + this.suiteName + " FAILED")) {
            this.suiteName = null;
        } else {
            this.displayOutput(string, antEvent.getLogLevel() == 1);
        }
    }

    private static File determineResultsDir(AntEvent antEvent) {
        TaskStructure[] taskStructureArray;
        File file = null;
        String string = null;
        TaskStructure taskStructure = antEvent.getTaskStructure();
        if (taskStructure != null && (taskStructureArray = taskStructure.getChildren()).length != 0) {
            for (int i = 0; i < taskStructureArray.length; ++i) {
                TaskStructure taskStructure2 = taskStructureArray[i];
                String string2 = taskStructure2.getName();
                if (!string2.equals("batchtest") && !string2.equals("test")) continue;
                String string3 = taskStructure2.getAttribute("todir");
                string = string3 != null ? antEvent.evaluate(string3) : ".";
                break;
            }
        }
        if (string != null) {
            file = new File(string);
            if (!file.isAbsolute()) {
                file = new File(antEvent.getProperty("basedir"), string);
            }
            if (!file.exists() || !file.isDirectory()) {
                file = null;
            }
        } else {
            file = null;
        }
        return file;
    }

    private Report createReport(String string) {
        Report report = new Report(string);
        report.antScript = this.antScript;
        report.classpath = this.classpath;
        report.platformSources = this.platformSources;
        this.classpath = null;
        this.platformSources = null;
        return report;
    }

    private ClassPath findPlatformSources(String string) {
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            File file;
            FileObject fileObject = javaPlatformArray[i].findTool("java");
            if (fileObject == null || !(file = FileUtil.toFile((FileObject)fileObject)).getAbsolutePath().startsWith(string)) continue;
            return javaPlatformArray[i].getSourceFolders();
        }
        return null;
    }

    private void setClasspathSourceRoots() {
        String string;
        if (this.report == null) {
            return;
        }
        if (this.report.classpathSourceRoots != null) {
            return;
        }
        if (this.report.classpath == null) {
            return;
        }
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.report.classpath, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            FileObject[] fileObjectArray;
            FileObject[] fileObjectArray2;
            string = stringTokenizer.nextToken();
            File file = FileUtil.normalizeFile((File)new File(string));
            try {
                fileObjectArray2 = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Object)malformedURLException);
            }
            if (FileUtil.isArchiveFile((URL)fileObjectArray2) && (fileObjectArray = FileUtil.getArchiveRoot((URL)fileObjectArray2)) != null) {
                fileObjectArray2 = fileObjectArray;
            }
            fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)fileObjectArray2).getRoots();
            linkedHashSet.addAll(Arrays.asList((Object[])fileObjectArray));
        }
        if (this.report.platformSources != null) {
            linkedHashSet.addAll(Arrays.asList(this.report.platformSources.getRoots()));
        } else {
            string = JavaPlatform.getDefault();
            if (string != null) {
                linkedHashSet.addAll(Arrays.asList(string.getSourceFolders().getRoots()));
            }
        }
        this.report.classpathSourceRoots = linkedHashSet;
        this.report.classpath = null;
        this.report.platformSources = null;
    }

    void testTargetStarted() {
        this.checkTestTargetStarted();
    }

    void testTaskStarted() {
        this.checkTestTaskStarted();
    }

    void buildFinished(AntEvent antEvent) {
        this.finishReport(antEvent.getException());
        Manager.getInstance().sessionFinished(this.session, this.sessionType, !this.testTaskStarted);
    }

    private Report suiteStarted(String string) {
        this.closePreviousReport();
        this.report = this.createReport(string);
        this.checkReportStarted();
        Manager.getInstance().displaySuiteRunning(this.session, this.sessionType, string);
        return this.report;
    }

    private void suiteFinished(Report report) {
        Manager.getInstance().displayReport(this.session, this.sessionType, report);
    }

    void finishReport(Throwable throwable) {
        if (this.waitingForIssueStatus) {
            if (!$assertionsDisabled && this.testcase == null) {
                throw new AssertionError();
            }
            this.report.reportTest(this.testcase);
        }
        this.closePreviousReport();
    }

    private void displayOutput(String string, boolean bl) {
        this.checkReportStarted();
        Manager.getInstance().displayOutput(this.session, this.sessionType, string, bl);
    }

    private void checkTestTargetStarted() {
        if (!this.testTargetStarted) {
            this.testTargetStarted = true;
            Manager.getInstance().targetStarted(this.session, this.sessionType);
        }
    }

    private void checkTestTaskStarted() {
        if (!this.testTaskStarted) {
            this.testTargetStarted = true;
            this.testTaskStarted = true;
            Manager.getInstance().testStarted(this.session, this.sessionType);
        }
    }

    private void checkReportStarted() {
        this.checkTestTaskStarted();
        if (!this.reportStarted) {
            this.reportStarted = true;
            Manager.getInstance().reportStarted(this.session);
        }
    }

    private boolean tryParsePlainHeader(String string) {
        Matcher matcher = this.regexp.getTestcaseHeaderPlainPattern().matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            int n = this.regexp.parseTimeMillisNoNFE(matcher.group(2));
            this.testcase = new Report.Testcase();
            this.testcase.className = null;
            this.testcase.name = string2;
            this.testcase.timeMillis = n;
            this.trouble = null;
            return true;
        }
        return false;
    }

    private boolean tryParseBriefHeader(String string) {
        Matcher matcher = this.regexp.getTestcaseHeaderBriefPattern().matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            boolean bl = matcher.group(3) == null;
            this.testcase = new Report.Testcase();
            this.testcase.className = string3;
            this.testcase.name = string2;
            this.testcase.timeMillis = -1;
            this.trouble = this.testcase.trouble = new Report.Trouble(bl);
            return true;
        }
        return false;
    }

    private void closePreviousReport() {
        block13: {
            long l;
            File file;
            if (this.xmlOutputBuffer != null) {
                try {
                    String string = this.xmlOutputBuffer.toString();
                    this.xmlOutputBuffer = null;
                    Report report = XmlOutputParser.parseXmlOutput(new StringReader(string));
                    this.report.update(report);
                }
                catch (SAXException sAXException) {
                }
                catch (IOException iOException) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            } else if (this.report != null && this.report.resultsDir != null && (file = new File(this.report.resultsDir, "TEST-" + this.report.suiteClassName + ".xml")).exists() && file.isFile() && file.canRead() && file.lastModified() >= this.timeOfSessionStart && (l = file.length()) > 0L && l <= 524288L) {
                try {
                    Report report = XmlOutputParser.parseXmlOutput(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                    this.report.update(report);
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                catch (SAXException sAXException) {
                }
                catch (IOException iOException) {
                    int n = 1;
                    ErrorManager errorManager = ErrorManager.getDefault();
                    if (!errorManager.isLoggable(n)) break block13;
                    errorManager.notify(n, errorManager.annotate((Throwable)iOException, "I/O exception while reading JUnit XML report file from JUnit: "));
                }
            }
        }
        if (this.report != null) {
            this.suiteFinished(this.report);
        }
        this.callstackBuffer = null;
        this.xmlOutputBuffer = null;
        this.readingOutputReport = false;
        this.testcase = null;
        this.trouble = null;
        this.report = null;
    }

    static {
        $assertionsDisabled = !JUnitOutputReader.class.desiredAssertionStatus();
    }
}

