/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.modules.junit.output.Manager;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.ResultDisplayHandler;
import org.netbeans.modules.junit.output.ResultWindow;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

final class Manager {
    private static Reference instanceRef;
    private final Map junitSessions = new WeakHashMap(5);
    private ComponentListener listener;
    private Map displayHandlers;
    private Map displaysMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    Manager() {
    }

    static Manager getInstance() {
        Manager manager;
        Object var1;
        Object v0 = var1 = instanceRef != null ? instanceRef.get() : null;
        if (var1 != null) {
            manager = var1;
        } else {
            manager = new Manager();
            instanceRef = new WeakReference<Manager>(manager);
        }
        return manager;
    }

    void targetStarted(AntSession antSession, int n) {
        this.displayMessage(antSession, n, NbBundle.getMessage(this.getClass(), (String)"LBL_PreparingTests"));
    }

    void testStarted(AntSession antSession, int n) {
        this.displayMessage(antSession, n, NbBundle.getMessage(this.getClass(), (String)"LBL_RunningTests"));
    }

    void reportStarted(AntSession antSession) {
        Object v = this.junitSessions.get(antSession);
        if (!$assertionsDisabled && v != null && v.getClass() != Integer.class) {
            throw new AssertionError();
        }
        if (v == null) {
            return;
        }
        if ((Integer)v != 2) {
            return;
        }
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                class DishonourAvenger
                implements ComponentListener {
                    private boolean activated;
                    private final /* synthetic */ Manager this$0;

                    DishonourAvenger(Manager manager) {
                        this.this$0 = manager;
                        this.activated = false;
                    }

                    public void componentMoved(ComponentEvent componentEvent) {
                    }

                    public void componentResized(ComponentEvent componentEvent) {
                    }

                    public void componentShown(ComponentEvent componentEvent) {
                    }

                    public void componentHidden(ComponentEvent componentEvent) {
                        if (!this.activated) {
                            this.activated = true;
                            ResultWindow resultWindow = ResultWindow.getInstance();
                            resultWindow.removeComponentListener(this);
                            resultWindow.requestVisible();
                        }
                    }
                }
                ResultWindow.getInstance().addComponentListener(Manager.this.listener = new DishonourAvenger(Manager.this));
            }
        });
    }

    void sessionFinished(AntSession antSession, int n, boolean bl) {
        Object v = this.junitSessions.get(antSession);
        if (!$assertionsDisabled && v != null && !(v instanceof Integer)) {
            throw new AssertionError();
        }
        if (v == null) {
            return;
        }
        String string = bl ? NbBundle.getMessage(this.getClass(), (String)"LBL_TestBuildInitFailed") : null;
        this.displayMessage(antSession, n, string);
        this.junitSessions.remove(antSession);
        if (this.listener != null) {
            Mutex.EVENT.writeAccess(new Runnable(){

                public void run() {
                    ResultWindow.getInstance().removeComponentListener(Manager.this.listener);
                }
            });
            this.listener = null;
        }
    }

    void displayOutput(AntSession antSession, int n, String string, boolean bl) {
        ResultDisplayHandler resultDisplayHandler = this.getDisplayHandler(antSession);
        resultDisplayHandler.displayOutput(string, bl);
        this.displayInWindow(antSession, n, resultDisplayHandler);
    }

    void displaySuiteRunning(AntSession antSession, int n, String string) {
        ResultDisplayHandler resultDisplayHandler = this.getDisplayHandler(antSession);
        resultDisplayHandler.displaySuiteRunning(string);
        this.displayInWindow(antSession, n, resultDisplayHandler);
    }

    void displayReport(AntSession antSession, int n, Report report) {
        ResultDisplayHandler resultDisplayHandler = this.getDisplayHandler(antSession);
        resultDisplayHandler.displayReport(report);
        this.displayInWindow(antSession, n, resultDisplayHandler);
    }

    private void displayMessage(AntSession antSession, int n, String string) {
        ResultDisplayHandler resultDisplayHandler = this.getDisplayHandler(antSession);
        resultDisplayHandler.displayMessage(string);
        this.displayInWindow(antSession, n, resultDisplayHandler);
    }

    private void displayInWindow(AntSession antSession, int n, ResultDisplayHandler resultDisplayHandler) {
        boolean bl = this.junitSessions.put(antSession, new Integer(n)) == null && n == 2;
        int n2 = this.getDisplayIndex(antSession);
        if (n2 == -1) {
            this.addDisplay(antSession);
            Mutex.EVENT.writeAccess((Runnable)new Displayer(resultDisplayHandler, bl));
        } else if (bl) {
            Mutex.EVENT.writeAccess((Runnable)new Displayer(null, bl));
        }
    }

    private ResultDisplayHandler getDisplayHandler(AntSession antSession) {
        ResultDisplayHandler resultDisplayHandler;
        Object var3_2;
        Object v0 = var3_2 = this.displayHandlers != null ? this.displayHandlers.get(antSession) : null;
        if (var3_2 != null) {
            resultDisplayHandler = var3_2;
        } else {
            if (this.displayHandlers == null) {
                this.displayHandlers = new WeakHashMap(7);
            }
            resultDisplayHandler = new ResultDisplayHandler();
            this.displayHandlers.put(antSession, resultDisplayHandler);
        }
        return resultDisplayHandler;
    }

    private int getDisplayIndex(AntSession antSession) {
        if (this.displaysMap == null) {
            return -1;
        }
        Object v = this.displaysMap.get(antSession);
        return v != null ? 0 : -1;
    }

    private void addDisplay(AntSession antSession) {
        if (this.displaysMap == null) {
            this.displaysMap = new WeakHashMap(4);
        }
        this.displaysMap.put(antSession, Boolean.TRUE);
    }

    static {
        $assertionsDisabled = !Manager.class.desiredAssertionStatus();
    }

    private class Displayer
    implements Runnable {
        private final ResultDisplayHandler displayHandler;
        private final boolean promote;

        Displayer(ResultDisplayHandler resultDisplayHandler, boolean bl) {
            this.displayHandler = resultDisplayHandler;
            this.promote = bl;
        }

        public void run() {
            ResultWindow resultWindow = ResultWindow.getInstance();
            if (this.displayHandler != null) {
                resultWindow.addDisplayComponent(this.displayHandler.getDisplayComponent());
            }
            if (this.promote) {
                resultWindow.promote();
            }
        }
    }
}

