/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.ResultPanelOutput;
import org.netbeans.modules.junit.output.ResultPanelTree;
import org.netbeans.modules.junit.output.ResultViewOutput;
import org.netbeans.modules.junit.output.ResultViewTree;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

final class ResultDisplayHandler {
    private static final String ID_TREE = "tree";
    private static final String ID_OUTPUT = "output";
    private MultiViewHandler handler;
    private MultiViewPerspective treeViewHandle;
    private MultiViewPerspective outputViewHandle;
    private ResultPanelTree treePanel;
    private ResultPanelOutput outputListener;
    private TopComponent displayComp;
    static final Object[] EMPTY_QUEUE;
    private final Object queueLock = new Object();
    private volatile Object[] outputQueue;
    private volatile int outputQueueSize = 0;
    private int outputQueueAvailSpace;
    private static final String ANONYMOUS_SUITE;
    private String runningSuite;
    private List reports;
    private String message;
    private Map methodsMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    ResultDisplayHandler() {
    }

    TopComponent getDisplayComponent() {
        if (this.displayComp == null) {
            this.displayComp = this.createDisplayComp();
        }
        return this.displayComp;
    }

    private TopComponent createDisplayComp() {
        ResultTreeViewDesc resultTreeViewDesc = new ResultTreeViewDesc(ID_TREE, "LBL_resultTreeView");
        ResultOutputViewDesc resultOutputViewDesc = new ResultOutputViewDesc(ID_OUTPUT, "LBL_resultOutputView");
        TopComponent topComponent = MultiViewFactory.createMultiView((MultiViewDescription[])new MultiViewDescription[]{resultTreeViewDesc, resultOutputViewDesc}, (MultiViewDescription)resultTreeViewDesc);
        this.setUpNavigation((JComponent)topComponent);
        this.handler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        MultiViewPerspective[] multiViewPerspectiveArray = this.handler.getPerspectives();
        this.treeViewHandle = multiViewPerspectiveArray[0];
        this.outputViewHandle = multiViewPerspectiveArray[1];
        return topComponent;
    }

    void displayShown() {
    }

    void displayHidden() {
    }

    private void setUpNavigation(JComponent jComponent) {
        InputMap inputMap = jComponent.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(37, 576), "toggleView");
        inputMap.put(KeyStroke.getKeyStroke(39, 576), "toggleView");
        jComponent.getActionMap().put("toggleView", new ToggleViewAction());
    }

    Object getOutputQueueLock() {
        return this.queueLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOutputListener(ResultPanelOutput resultPanelOutput) {
        Object object = this.queueLock;
        synchronized (object) {
            this.outputListener = resultPanelOutput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayOutput(String string, boolean bl) {
        Object object = this.queueLock;
        synchronized (object) {
            int n;
            if (this.outputQueue == null) {
                this.outputQueue = new Object[40];
                this.outputQueueAvailSpace = this.outputQueue.length - 1;
                this.outputQueueSize = 0;
            }
            int n2 = n = bl ? 2 : 1;
            if ((this.outputQueueAvailSpace -= n) < 0) {
                int n3 = this.outputQueue.length < 640 ? this.outputQueue.length * 2 : this.outputQueue.length * 3 / 2;
                Object[] objectArray = this.outputQueue;
                this.outputQueue = new Object[n3];
                System.arraycopy(objectArray, 0, this.outputQueue, 0, this.outputQueueSize);
                this.outputQueueAvailSpace += this.outputQueue.length - objectArray.length;
            }
            if (bl) {
                this.outputQueue[this.outputQueueSize++] = Boolean.TRUE;
            }
            this.outputQueue[this.outputQueueSize++] = string;
            if (this.outputListener != null) {
                this.outputListener.outputAvailable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] consumeOutput() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.outputQueueSize == 0) {
                return EMPTY_QUEUE;
            }
            Object[] objectArray = this.outputQueue;
            this.outputQueue = null;
            this.outputQueueSize = 0;
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displaySuiteRunning(String string) {
        if (!$assertionsDisabled && this.runningSuite != null) {
            throw new AssertionError();
        }
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                this.runningSuite = string != null ? string : ANONYMOUS_SUITE;
                return;
            }
        }
        this.displayInDispatchThread("displaySuiteRunning", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayReport(Report report) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                if (this.reports == null) {
                    this.reports = new ArrayList(10);
                }
                this.reports.add(report);
                this.runningSuite = null;
                return;
            }
        }
        this.displayInDispatchThread("displayReport", report);
        if (!$assertionsDisabled && this.runningSuite != null) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayMessage(String string) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                this.message = string;
                return;
            }
        }
        this.displayInDispatchThread("displayMsg", string);
    }

    private void displayInDispatchThread(String string, final Object object) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.treePanel == null) {
            throw new AssertionError();
        }
        final Method method = this.prepareMethod(string);
        if (method == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    method.invoke((Object)ResultDisplayHandler.this.treePanel, object);
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorManager.getDefault().notify(invocationTargetException.getTargetException());
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(65536, (Throwable)exception);
                }
            }
        });
    }

    private Method prepareMethod(String string) {
        Method method;
        if (this.methodsMap == null) {
            this.methodsMap = new HashMap(4);
            method = null;
        } else {
            method = (Method)this.methodsMap.get(string);
        }
        if (method == null && !this.methodsMap.containsKey(string)) {
            Class clazz;
            if (string.equals("displayReport")) {
                clazz = Report.class;
            } else {
                if (!($assertionsDisabled || string.equals("displayMsg") || string.equals("displaySuiteRunning"))) {
                    throw new AssertionError();
                }
                clazz = String.class;
            }
            try {
                method = ResultPanelTree.class.getDeclaredMethod(string, clazz);
            }
            catch (Exception exception) {
                method = null;
                ErrorManager.getDefault().notify(65536, (Throwable)exception);
            }
            this.methodsMap.put(string, method);
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTreePanel(ResultPanelTree resultPanelTree) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel != null) {
                return;
            }
            this.treePanel = resultPanelTree;
        }
        if (this.message != null) {
            resultPanelTree.displayMsg(this.message);
            this.message = null;
        }
        if (this.reports != null) {
            resultPanelTree.displayReports(this.reports);
            this.reports = null;
        }
        if (this.runningSuite != null) {
            resultPanelTree.displaySuiteRunning(this.runningSuite != ANONYMOUS_SUITE ? this.runningSuite : null);
        }
    }

    static {
        $assertionsDisabled = !ResultDisplayHandler.class.desiredAssertionStatus();
        EMPTY_QUEUE = new Object[0];
        ANONYMOUS_SUITE = new String();
    }

    private final class ResultOutputViewDesc
    extends AbstractResultViewDesc
    implements Serializable {
        static final long serialVersionUID = -6007918504501341013L;

        private ResultOutputViewDesc(String string, String string2) {
            super(string, string2);
        }

        public Image getIcon() {
            return null;
        }

        public MultiViewElement createElement() {
            return new ResultViewOutput(ResultDisplayHandler.this);
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }
    }

    private final class ResultTreeViewDesc
    extends AbstractResultViewDesc
    implements Serializable {
        static final long serialVersionUID = -4369549644387784567L;

        private ResultTreeViewDesc(String string, String string2) {
            super(string, string2);
        }

        public Image getIcon() {
            return null;
        }

        public MultiViewElement createElement() {
            return new ResultViewTree(ResultDisplayHandler.this);
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }
    }

    private static abstract class AbstractResultViewDesc
    implements MultiViewDescription {
        private final String idPart;
        private transient String id;
        private final String displayNameKey;
        private transient String displayName;

        private AbstractResultViewDesc(String string, String string2) {
            this.idPart = string;
            this.displayNameKey = string2;
        }

        public String preferredID() {
            return this.idPart;
        }

        public String getDisplayName() {
            if (this.displayName == null) {
                try {
                    this.displayName = NbBundle.getMessage((Class)(class$org$netbeans$modules$junit$output$ResultDisplayHandler == null ? (class$org$netbeans$modules$junit$output$ResultDisplayHandler = ResultDisplayHandler.class$("org.netbeans.modules.junit.output.ResultDisplayHandler")) : class$org$netbeans$modules$junit$output$ResultDisplayHandler), (String)this.displayNameKey);
                }
                catch (MissingResourceException missingResourceException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)missingResourceException);
                    this.displayName = "??? (" + this.displayNameKey + ')';
                }
            }
            return this.displayName;
        }

        public int getPersistenceType() {
            return 2;
        }
    }

    final class ToggleViewAction
    extends AbstractAction {
        static final /* synthetic */ boolean $assertionsDisabled;

        ToggleViewAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MultiViewPerspective multiViewPerspective = ResultDisplayHandler.this.handler.getSelectedPerspective();
            if (multiViewPerspective == ResultDisplayHandler.this.treeViewHandle) {
                ResultDisplayHandler.this.handler.requestActive(ResultDisplayHandler.this.outputViewHandle);
            } else if (multiViewPerspective == ResultDisplayHandler.this.outputViewHandle) {
                ResultDisplayHandler.this.handler.requestActive(ResultDisplayHandler.this.treeViewHandle);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$junit$output$ResultDisplayHandler == null ? (class$org$netbeans$modules$junit$output$ResultDisplayHandler = ResultDisplayHandler.class$("org.netbeans.modules.junit.output.ResultDisplayHandler")) : class$org$netbeans$modules$junit$output$ResultDisplayHandler).desiredAssertionStatus();
        }
    }
}

