/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.AccessibleContext;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.junit.output.ResultDisplayHandler;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

final class ResultPanelOutput
extends JScrollPane
implements ActionListener {
    private static final boolean LOG = false;
    static final Color selectedFg;
    static final Color unselectedFg;
    static final Color selectedErr;
    static final Color unselectedErr;
    private static final int UPDATE_DELAY = 300;
    private final Style outputStyle;
    private final Style errOutputStyle;
    private final JTextPane textPane = new JTextPane();
    private final StyledDocument doc = this.textPane.getStyledDocument();
    private final ResultDisplayHandler displayHandler;
    boolean newLinePending = false;
    private Timer timer = null;
    private volatile boolean timerRunning = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    ResultPanelOutput(ResultDisplayHandler resultDisplayHandler) {
        this.textPane.setEditable(false);
        this.setViewportView(this.textPane);
        AccessibleContext accessibleContext = this.textPane.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_OutputTextPane"));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_OutputTextPane"));
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        this.outputStyle = this.doc.addStyle("output", style);
        StyleConstants.setFontFamily(this.outputStyle, "Monospaced");
        StyleConstants.setForeground(this.outputStyle, unselectedFg);
        this.errOutputStyle = this.doc.addStyle("error", this.outputStyle);
        StyleConstants.setForeground(this.errOutputStyle, unselectedErr);
        this.displayHandler = resultDisplayHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object[] objectArray;
        super.addNotify();
        Object object = this.displayHandler.getOutputQueueLock();
        synchronized (object) {
            objectArray = this.displayHandler.consumeOutput();
            if (objectArray.length == 0) {
                this.displayHandler.setOutputListener(this);
            }
        }
        if (objectArray.length != 0) {
            this.displayOutput(objectArray);
            this.startTimer();
        }
    }

    void outputAvailable() {
        Object[] objectArray = this.displayHandler.consumeOutput();
        if (!$assertionsDisabled && objectArray.length == 0) {
            throw new AssertionError();
        }
        new OutputDisplayer(objectArray).run();
        this.displayHandler.setOutputListener(null);
        if (!this.timerRunning) {
            this.startTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        Object[] objectArray = this.displayHandler.consumeOutput();
        if (objectArray.length != 0) {
            this.displayOutput(objectArray);
        } else {
            Object object = this.displayHandler.getOutputQueueLock();
            synchronized (object) {
                this.stopTimer();
                this.displayHandler.setOutputListener(this);
            }
        }
    }

    private void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer(300, this);
        }
        this.timerRunning = true;
        this.timer.start();
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timerRunning = false;
        }
    }

    void displayOutput(Object[] objectArray) {
        Object object;
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        int n = 0;
        while ((object = objectArray[n++]) != null) {
            boolean bl = false;
            if (object == Boolean.TRUE) {
                object = objectArray[n++];
                bl = true;
            }
            this.displayOutputLine(object.toString(), bl);
        }
    }

    private void displayOutputLine(String string, boolean bl) {
        Style style = bl ? this.errOutputStyle : this.outputStyle;
        try {
            if (this.newLinePending) {
                this.doc.insertString(this.doc.getLength(), "\n", this.outputStyle);
                this.newLinePending = false;
            }
            this.doc.insertString(this.doc.getLength(), string, style);
            this.newLinePending = true;
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(65536, (Throwable)badLocationException);
        }
    }

    private void clear() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        try {
            this.doc.remove(0, this.doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(65536, (Throwable)badLocationException);
        }
    }

    public boolean requestFocusInWindow() {
        return this.textPane.requestFocusInWindow();
    }

    static {
        $assertionsDisabled = !ResultPanelOutput.class.desiredAssertionStatus();
        Color color = UIManager.getColor("nb.output.foreground.selected");
        if (color == null && (color = UIManager.getColor("textText")) == null) {
            color = Color.BLACK;
        }
        selectedFg = color;
        color = UIManager.getColor("nb.output.foreground");
        if (color == null) {
            color = selectedFg;
        }
        unselectedFg = color;
        color = UIManager.getColor("nb.output.err.foreground.selected");
        if (color == null) {
            color = new Color(164, 0, 0);
        }
        selectedErr = color;
        color = UIManager.getColor("nb.output.err.foreground");
        if (color == null) {
            color = selectedErr;
        }
        unselectedErr = color;
    }

    final class OutputDisplayer
    implements Runnable {
        private final Object[] output;

        OutputDisplayer(Object[] objectArray) {
            this.output = objectArray;
        }

        public void run() {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(this);
                return;
            }
            ResultPanelOutput.this.displayOutput(this.output);
        }
    }
}

