/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.junit.output.RegexpUtils;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.ResultDisplayHandler;
import org.netbeans.modules.junit.output.ResultTreeView;
import org.netbeans.modules.junit.output.RootNode;
import org.netbeans.modules.junit.output.TestsuiteNode;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class ResultPanelTree
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
ItemListener {
    private final ExplorerManager explorerManager;
    private final RootNode rootNode;
    private final ResultTreeView treeView;
    private AbstractButton btnFilter;
    private boolean filtered = false;
    private ChangeListener changeListener;
    private ChangeEvent changeEvent;
    private final RegexpUtils regexpUtils = RegexpUtils.getInstance();
    private final ResultDisplayHandler displayHandler;
    static final /* synthetic */ boolean $assertionsDisabled;

    ResultPanelTree(ResultDisplayHandler resultDisplayHandler) {
        super(new BorderLayout());
        this.treeView = new ResultTreeView();
        this.add((Component)((Object)this.treeView), "Center");
        this.explorerManager = new ExplorerManager();
        this.rootNode = new RootNode(this.filtered);
        this.explorerManager.setRootContext((Node)this.rootNode);
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.initFilter();
        this.initAccessibility();
        this.displayHandler = resultDisplayHandler;
    }

    private void initFilter() {
        this.btnFilter = new JToggleButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/junit/output/res/filter.png", (boolean)true)));
        this.btnFilter.getAccessibleContext().setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_FilterButton"));
        this.btnFilter.addItemListener(this);
        this.updateBtnFilterLabel();
    }

    private void initAccessibility() {
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_ResultPanelTree"));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_ResultPanelTree"));
        accessibleContext = this.treeView.getHorizontalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_HorizontalScrollbar"));
        accessibleContext = this.treeView.getVerticalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_HorizontalScrollbar"));
    }

    AbstractButton getFilterButton() {
        return this.btnFilter;
    }

    private void updateBtnFilterLabel() {
        String string = this.filtered ? "MultiviewPanel.btnFilter.showAll.tooltip" : "MultiviewPanel.btnFilter.showFailures.tooltip";
        this.btnFilter.setToolTipText(NbBundle.getMessage(this.getClass(), (String)string));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setFiltered(this.btnFilter.isSelected());
        this.updateBtnFilterLabel();
    }

    void displayMsg(String string) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.rootNode.displayMessage(string);
    }

    public void addNotify() {
        super.addNotify();
        this.displayHandler.setTreePanel(this);
    }

    void displaySuiteRunning(String string) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.rootNode.displaySuiteRunning(string);
    }

    void displayReport(Report report) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        TestsuiteNode testsuiteNode = this.rootNode.displayReport(report);
        if (testsuiteNode != null && report.containsFailed()) {
            this.treeView.expandReportNode(testsuiteNode);
        }
        this.btnFilter.setEnabled(this.rootNode.getSuccessDisplayedLevel() != 0);
    }

    void displayReports(List list) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        int n = list.size();
        if (n == 0) {
            return;
        }
        if (n == 1) {
            this.displayReport((Report)list.get(0));
        } else {
            this.rootNode.displayReports(list);
        }
        this.btnFilter.setEnabled(this.rootNode.getSuccessDisplayedLevel() != 0);
    }

    void viewOpened() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
    }

    void setFiltered(boolean bl) {
        if (bl == this.filtered) {
            return;
        }
        this.filtered = bl;
        this.rootNode.setFiltered(bl);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            this.nodeSelectionChanged();
        }
    }

    private void nodeSelectionChanged() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.fireChange();
    }

    void setChangeListener(ChangeListener changeListener) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.changeListener = changeListener;
        if (this.changeListener == null) {
            this.changeEvent = null;
        } else if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
    }

    private void fireNodeSelectionChange() {
        this.fireChange();
    }

    private void fireChange() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (this.changeListener != null) {
            this.changeListener.stateChanged(this.changeEvent);
        }
    }

    Node[] getSelectedNodes() {
        return this.explorerManager.getSelectedNodes();
    }

    private void selectAndActivateNode(Node node) {
        Node[] nodeArray = new Node[]{node};
        try {
            this.explorerManager.setSelectedNodes(nodeArray);
            this.fireNodeSelectionChange();
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify(4096, (Throwable)propertyVetoException);
            nodeArray = new Node[]{};
            try {
                this.explorerManager.setSelectedNodes(nodeArray);
                this.fireNodeSelectionChange();
            }
            catch (PropertyVetoException propertyVetoException2) {
                ErrorManager.getDefault().notify(4096, (Throwable)propertyVetoException2);
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public boolean requestFocusInWindow() {
        return this.treeView.requestFocusInWindow();
    }

    static {
        $assertionsDisabled = !ResultPanelTree.class.desiredAssertionStatus();
    }
}

