/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.ObjectStreamException;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ResultWindow
extends TopComponent {
    private static final String ID = "junit-test-results";
    private static WeakReference instance;
    private TopComponent view;
    private Map topCompMethodsMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    static synchronized ResultWindow getInstance() {
        ResultWindow resultWindow = (ResultWindow)WindowManager.getDefault().findTopComponent(ID);
        if (resultWindow == null) {
            resultWindow = ResultWindow.getDefault();
        }
        return resultWindow;
    }

    public static synchronized ResultWindow getDefault() {
        ResultWindow resultWindow;
        if (instance == null || (resultWindow = (ResultWindow)((Object)instance.get())) == null) {
            resultWindow = new ResultWindow();
            instance = new WeakReference<ResultWindow>(resultWindow);
        }
        return resultWindow;
    }

    public ResultWindow() {
        this.setLayout(new BorderLayout());
        this.setName(ID);
        this.setDisplayName(NbBundle.getMessage((Class)ResultWindow.class, (String)"TITLE_TEST_RESULTS"));
        this.setIcon(Utilities.loadImage((String)"org/netbeans/modules/junit/output/res/testResults.png", (boolean)true));
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ACSN_TestResults"));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ACSD_TestResults"));
    }

    protected void componentOpened() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (this.view != null) {
            this.forwardMessage(this.view, "componentOpened");
        }
        super.componentOpened();
    }

    protected void componentClosed() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (this.view != null) {
            this.forwardMessage(this.view, "componentClosed");
        }
        super.componentClosed();
    }

    protected void componentActivated() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (this.view != null) {
            this.forwardMessage(this.view, "componentActivated");
        }
        super.componentActivated();
    }

    protected void componentDeactivated() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (this.view != null) {
            this.forwardMessage(this.view, "componentDeactivated");
        }
        super.componentDeactivated();
    }

    protected void componentShowing() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (this.view != null) {
            this.forwardMessage(this.view, "componentShowing");
        }
        super.componentShowing();
    }

    protected void componentHidden() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (this.view != null) {
            this.forwardMessage(this.view, "componentHidden");
        }
        super.componentHidden();
    }

    private void forwardMessage(TopComponent topComponent, String string) {
        this.ensureMethodsPrepared();
        Method method = (Method)this.topCompMethodsMap.get(string);
        if (method != null) {
            try {
                method.invoke((Object)topComponent, null);
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorManager.getDefault().notify((Throwable)invocationTargetException);
            }
            catch (Exception exception) {
                this.topCompMethodsMap.remove(string);
                ErrorManager.getDefault().notify(65536, (Throwable)exception);
            }
        }
    }

    private void ensureMethodsPrepared() {
        if (this.topCompMethodsMap == null) {
            this.prepareMethods();
        }
    }

    private void prepareMethods() throws SecurityException {
        if (!$assertionsDisabled && this.topCompMethodsMap != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.view == null) {
            throw new AssertionError();
        }
        this.topCompMethodsMap = new HashMap(8);
        String[] stringArray = new String[]{"componentOpened", "componentClosed", "componentActivated", "componentDeactivated", "componentShowing", "componentHidden"};
        ArrayList<Method> arrayList = new ArrayList<Method>(stringArray.length);
        Class<?> clazz = this.view.getClass();
        Class[] classArray = new Class[]{};
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string = stringArray[i];
                Method method = clazz.getDeclaredMethod(string, classArray);
                this.topCompMethodsMap.put(string, method);
                arrayList.add(method);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager.getDefault().notify(65536, (Throwable)noSuchMethodException);
            }
        }
        if (!arrayList.isEmpty()) {
            AccessibleObject[] accessibleObjectArray = new Method[arrayList.size()];
            arrayList.toArray(accessibleObjectArray);
            Method.setAccessible(accessibleObjectArray, true);
        }
    }

    void addDisplayComponent(TopComponent topComponent) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.removeAll();
        this.addView(topComponent);
    }

    private void addView(TopComponent topComponent) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.view = topComponent;
        if (this.isOpened()) {
            this.forwardMessage(topComponent, "componentOpened");
            if (this.isShowing()) {
                this.forwardMessage(topComponent, "componentShowing");
                if (this.isActivated()) {
                    this.forwardMessage(topComponent, "componentActivated");
                }
            }
        }
        this.add((Component)topComponent);
    }

    private boolean isActivated() {
        return TopComponent.getRegistry().getActivated() == this;
    }

    void promote() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.open();
        this.requestVisible();
        this.requestActive();
    }

    protected String preferredID() {
        return ID;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    public int getPersistenceType() {
        return 0;
    }

    private Object readResolve() throws ObjectStreamException {
        return ResultWindow.getDefault();
    }

    static {
        $assertionsDisabled = !ResultWindow.class.desiredAssertionStatus();
        instance = null;
    }
}

