/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.junit.CreateTestAction;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.TestCreator;
import org.netbeans.modules.junit.wizards.EmptyTestCaseWizardIterator;
import org.netbeans.modules.junit.wizards.SimpleTestStepLocation;
import org.netbeans.modules.junit.wizards.StepProblemMessage;
import org.netbeans.modules.junit.wizards.Utils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class SimpleTestCaseWizardIterator
implements TemplateWizard.Iterator {
    private static SimpleTestCaseWizardIterator instance;
    private TemplateWizard wizard;
    private static final int INDEX_CHOOSE_CLASS = 2;
    private final String nameChooseClass = NbBundle.getMessage((Class)SimpleTestCaseWizardIterator.class, (String)"LBL_panel_ChooseClass");
    private int current;
    private List changeListeners;
    private Project lastSelectedProject = null;
    private WizardDescriptor.Panel classChooserPanel;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList(2);
        }
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(changeListener);
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }
    }

    private void fireChange() {
        if (this.changeListeners != null) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            Iterator iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged(changeEvent);
            }
        }
    }

    public boolean hasPrevious() {
        return this.current > 2;
    }

    public boolean hasNext() {
        return this.current < 2;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.current;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.current;
    }

    public WizardDescriptor.Panel current() {
        switch (this.current) {
            case 2: {
                return this.getClassChooserPanel();
            }
        }
        throw new IllegalStateException();
    }

    private WizardDescriptor.Panel getClassChooserPanel() {
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        if (this.classChooserPanel == null || project != this.lastSelectedProject) {
            Utils utils = new Utils(project);
            if (utils.getSourcesToTestsMap(true).isEmpty()) {
                this.classChooserPanel = new StepProblemMessage(project, NbBundle.getMessage((Class)EmptyTestCaseWizardIterator.class, (String)"MSG_NoTestSourceGroup"));
            } else {
                if (this.classChooserPanel == null) {
                    this.classChooserPanel = new SimpleTestStepLocation();
                }
                ((SimpleTestStepLocation)this.classChooserPanel).setUp(utils);
            }
        }
        this.lastSelectedProject = project;
        return this.classChooserPanel;
    }

    public String name() {
        switch (this.current) {
            case 2: {
                return this.nameChooseClass;
            }
        }
        throw new AssertionError(this.current);
    }

    private void loadSettings(TemplateWizard templateWizard) {
        JUnitSettings jUnitSettings = JUnitSettings.getDefault();
        templateWizard.putProperty("Public", (Object)jUnitSettings.isMembersPublic());
        templateWizard.putProperty("Protected", (Object)jUnitSettings.isMembersProtected());
        templateWizard.putProperty("Package", (Object)jUnitSettings.isMembersPackage());
        templateWizard.putProperty("SetUp", (Object)jUnitSettings.isGenerateSetUp());
        templateWizard.putProperty("TearDown", (Object)jUnitSettings.isGenerateTearDown());
        templateWizard.putProperty("Content", (Object)jUnitSettings.isBodyContent());
        templateWizard.putProperty("JavaDoc", (Object)jUnitSettings.isJavaDoc());
        templateWizard.putProperty("Comments", (Object)jUnitSettings.isBodyComments());
        templateWizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage((Class)SimpleTestStepLocation.class, (String)"LBL_simpleTestWizard_stepName"));
    }

    private void saveSettings(TemplateWizard templateWizard) {
        JUnitSettings jUnitSettings = JUnitSettings.getDefault();
        jUnitSettings.setMembersPublic(Boolean.TRUE.equals(templateWizard.getProperty("Public")));
        jUnitSettings.setMembersProtected(Boolean.TRUE.equals(templateWizard.getProperty("Protected")));
        jUnitSettings.setMembersPackage(Boolean.TRUE.equals(templateWizard.getProperty("Package")));
        jUnitSettings.setGenerateSetUp(Boolean.TRUE.equals(templateWizard.getProperty("SetUp")));
        jUnitSettings.setGenerateTearDown(Boolean.TRUE.equals(templateWizard.getProperty("TearDown")));
        jUnitSettings.setBodyContent(Boolean.TRUE.equals(templateWizard.getProperty("Content")));
        jUnitSettings.setJavaDoc(Boolean.TRUE.equals(templateWizard.getProperty("JavaDoc")));
        jUnitSettings.setBodyComments(Boolean.TRUE.equals(templateWizard.getProperty("Comments")));
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wizard = templateWizard;
        this.current = 2;
        this.loadSettings(templateWizard);
        String[] stringArray = new String[]{NbBundle.getMessage((Class)EmptyTestCaseWizardIterator.class, (String)"LBL_panel_chooseFileType"), NbBundle.getMessage((Class)EmptyTestCaseWizardIterator.class, (String)"LBL_panel_ChooseClass")};
        ((JComponent)this.getClassChooserPanel().getComponent()).putClientProperty("WizardPanel_contentData", stringArray);
        ((JComponent)this.getClassChooserPanel().getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
    }

    public void uninitialize(TemplateWizard templateWizard) {
        if (this.classChooserPanel != null && !(this.classChooserPanel instanceof StepProblemMessage)) {
            if (!$assertionsDisabled && !(this.classChooserPanel instanceof SimpleTestStepLocation)) {
                throw new AssertionError();
            }
            ((SimpleTestStepLocation)this.classChooserPanel).cleanUp();
        }
        this.classChooserPanel = null;
        this.changeListeners = null;
        this.wizard = null;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        DataObject dataObject;
        this.saveSettings(templateWizard);
        String string = NbBundle.getMessage((Class)CreateTestAction.class, (String)"PROP_testClassTemplate");
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string);
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            String string2 = NbBundle.getMessage((Class)CreateTestAction.class, (String)"MSG_template_not_found", (Object)string);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
            return null;
        }
        FileObject fileObject2 = (FileObject)this.wizard.getProperty("classToTest");
        FileObject fileObject3 = (FileObject)this.wizard.getProperty("testRootFolder");
        ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject3});
        try {
            return CreateTestAction.createSingleTest(new TestCreator(true), classPath, fileObject2, null, dataObject, null, null, false).getCreated();
        }
        catch (CreateTestAction.CreationError creationError) {
            throw new IOException();
        }
    }

    public static SimpleTestCaseWizardIterator singleton() {
        if (instance == null) {
            instance = new SimpleTestCaseWizardIterator();
        }
        return instance;
    }

    static {
        $assertionsDisabled = !SimpleTestCaseWizardIterator.class.desiredAssertionStatus();
    }
}

