/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.junit.CreateTestAction;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.TestCreator;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.wizards.EmptyTestCaseWizardIterator;
import org.netbeans.modules.junit.wizards.StepProblemMessage;
import org.netbeans.modules.junit.wizards.TestSuiteStepLocation;
import org.netbeans.modules.junit.wizards.Utils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class TestSuiteWizardIterator
implements TemplateWizard.Iterator {
    private static TestSuiteWizardIterator instance;
    private TemplateWizard wizard;
    private static final int INDEX_TARGET = 2;
    private final String nameTarget = NbBundle.getMessage((Class)TestSuiteWizardIterator.class, (String)"LBL_panel_Target");
    private int current;
    private List changeListeners;
    private WizardDescriptor.Panel targetPanel;
    private Project lastSelectedProject = null;
    private WizardDescriptor.Panel optionsPanel;
    private SourceGroup[] testSrcGroups;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList(2);
        }
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(changeListener);
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }
    }

    private void fireChange() {
        if (this.changeListeners != null) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            Iterator iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged(changeEvent);
            }
        }
    }

    public boolean hasPrevious() {
        return this.current > 2;
    }

    public boolean hasNext() {
        return this.current < 2;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.current;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.current;
    }

    public WizardDescriptor.Panel current() {
        switch (this.current) {
            case 2: {
                return this.getTargetPanel();
            }
        }
        throw new IllegalStateException();
    }

    private WizardDescriptor.Panel getTargetPanel() {
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        if (this.targetPanel == null || project != this.lastSelectedProject) {
            Collection collection = Utils.getTestTargets(project, true);
            if (collection.isEmpty()) {
                this.targetPanel = new StepProblemMessage(project, NbBundle.getMessage((Class)EmptyTestCaseWizardIterator.class, (String)"MSG_NoTestSourceGroup"));
            } else {
                this.testSrcGroups = new SourceGroup[collection.size()];
                collection.toArray(this.testSrcGroups);
                if (this.optionsPanel == null) {
                    this.optionsPanel = new TestSuiteStepLocation();
                }
                this.targetPanel = JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])this.testSrcGroups, (WizardDescriptor.Panel)this.optionsPanel);
            }
            this.lastSelectedProject = project;
        }
        return this.targetPanel;
    }

    public String name() {
        switch (this.current) {
            case 2: {
                return this.nameTarget;
            }
        }
        throw new AssertionError(this.current);
    }

    private void loadSettings(TemplateWizard templateWizard) {
        JUnitSettings jUnitSettings = JUnitSettings.getDefault();
        templateWizard.putProperty("SetUp", (Object)jUnitSettings.isGenerateSetUp());
        templateWizard.putProperty("TearDown", (Object)jUnitSettings.isGenerateTearDown());
        templateWizard.putProperty("Comments", (Object)jUnitSettings.isBodyComments());
    }

    private void saveSettings(TemplateWizard templateWizard) {
        JUnitSettings jUnitSettings = JUnitSettings.getDefault();
        jUnitSettings.setGenerateSetUp(Boolean.TRUE.equals(templateWizard.getProperty("SetUp")));
        jUnitSettings.setGenerateTearDown(Boolean.TRUE.equals(templateWizard.getProperty("TearDown")));
        jUnitSettings.setBodyComments(Boolean.TRUE.equals(templateWizard.getProperty("Comments")));
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wizard = templateWizard;
        this.current = 2;
        this.loadSettings(templateWizard);
        String[] stringArray = new String[]{NbBundle.getMessage((Class)EmptyTestCaseWizardIterator.class, (String)"LBL_panel_chooseFileType"), NbBundle.getMessage((Class)EmptyTestCaseWizardIterator.class, (String)"LBL_panel_Target")};
        ((JComponent)this.getTargetPanel().getComponent()).putClientProperty("WizardPanel_contentData", stringArray);
        ((JComponent)this.getTargetPanel().getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.wizard = null;
        this.targetPanel = null;
        this.lastSelectedProject = null;
        this.optionsPanel = null;
        this.testSrcGroups = null;
        this.changeListeners = null;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        DataObject dataObject;
        this.saveSettings(templateWizard);
        String string = NbBundle.getMessage((Class)CreateTestAction.class, (String)"PROP_testSuiteTemplate");
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string);
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            String string2 = NbBundle.getMessage((Class)CreateTestAction.class, (String)"MSG_template_not_found", (Object)string);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
            return null;
        }
        String string3 = Templates.getTargetName((WizardDescriptor)this.wizard);
        FileObject fileObject2 = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject2);
        FileObject fileObject3 = this.findTestRootFolder(fileObject2);
        if (!$assertionsDisabled && fileObject3 == null) {
            throw new AssertionError();
        }
        ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject3});
        List list = TestUtil.getJavaFileNames(fileObject2, classPath);
        try {
            DataObject dataObject2 = CreateTestAction.createSuiteTest(new TestCreator(true), classPath, dataFolder, string3, new LinkedList(list), dataObject, null, null);
            return Collections.singleton(dataObject2);
        }
        catch (CreateTestAction.CreationError creationError) {
            throw new IOException();
        }
    }

    private FileObject findTestRootFolder(FileObject fileObject) {
        for (int i = 0; i < this.testSrcGroups.length; ++i) {
            FileObject fileObject2 = this.testSrcGroups[i].getRootFolder();
            if (fileObject2 != fileObject && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return fileObject2;
        }
        return null;
    }

    public static TestSuiteWizardIterator singleton() {
        if (instance == null) {
            instance = new TestSuiteWizardIterator();
        }
        return instance;
    }

    static {
        $assertionsDisabled = !TestSuiteWizardIterator.class.desiredAssertionStatus();
    }
}

