/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.util;

import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.SwingUtilities;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeText;
import org.netbeans.tax.io.TreeStreamResult;
import org.netbeans.tax.io.TreeWriter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.xml.XMLUtil;

public final class TAXUtil {
    public static void setAttributeValue(TreeAttribute treeAttribute, String string) throws TreeException {
        try {
            treeAttribute.setValue(XMLUtil.toAttributeValue((String)string));
        }
        catch (CharConversionException charConversionException) {
            throw new TreeException(charConversionException);
        }
    }

    public static void setTextData(TreeText treeText, String string) throws TreeException {
        try {
            treeText.setData(XMLUtil.toElementContent((String)string));
        }
        catch (CharConversionException charConversionException) {
            throw new TreeException(charConversionException);
        }
    }

    public static void notifyWarning(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        });
    }

    public static String printableValue(String string) {
        if (string == null) {
            return "<null>";
        }
        int n = 33;
        int n2 = Math.min(string.length(), n);
        StringBuffer stringBuffer = new StringBuffer(2 * n2);
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if ('\r' == c) {
                stringBuffer.append("\\r");
                continue;
            }
            if ('\n' == c) {
                stringBuffer.append("\\n");
                continue;
            }
            if ('\t' == c) {
                stringBuffer.append("\\t");
                continue;
            }
            if ('\b' == c) {
                stringBuffer.append("\\b");
                continue;
            }
            if ('\f' == c) {
                stringBuffer.append("\\f");
                continue;
            }
            stringBuffer.append(c);
        }
        if (string.length() > n2) {
            stringBuffer.append("...");
        }
        return stringBuffer.toString();
    }

    public static void notifyTreeException(TreeException treeException) {
        TAXUtil.notifyWarning(treeException.getMessage());
    }

    public static String treeToString(TreeDocumentRoot treeDocumentRoot) throws IOException {
        StringWriter stringWriter = new StringWriter();
        TreeStreamResult treeStreamResult = new TreeStreamResult(stringWriter);
        TreeWriter treeWriter = treeStreamResult.getWriter(treeDocumentRoot);
        try {
            treeWriter.writeDocument();
            String string = stringWriter.toString();
            return string;
        }
        catch (TreeException treeException) {
            throw new IOException("Cannot read tree " + treeException.getMessage());
        }
        finally {
            try {
                stringWriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] treeToByteArray(TreeDocumentRoot treeDocumentRoot) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        TreeStreamResult treeStreamResult = new TreeStreamResult(byteArrayOutputStream);
        TreeWriter treeWriter = treeStreamResult.getWriter(treeDocumentRoot);
        try {
            byte[] byArray;
            treeWriter.writeDocument();
            byte[] byArray2 = byArray = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (TreeException treeException) {
            throw new IOException("Cannot read tree " + treeException.getMessage());
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

