/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.hints.HintsUI;
import org.netbeans.modules.editor.hints.spi.Hint;
import org.netbeans.modules.editor.hints.spi.HintsProvider;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class HintsOperator
implements CaretListener,
ChangeListener,
PropertyChangeListener,
ComponentListener,
FocusListener,
KeyListener {
    private static ErrorManager ERR = ErrorManager.getDefault().getInstance("org.netbeans.modules.hints");
    private static RequestProcessor HINTS_REQUEST_PROCESSOR = new RequestProcessor("Hints RP", 1);
    private Reference componentRef = null;
    private RequestProcessor.Task hintTask;
    private RequestProcessor.Task hintPopupTask;
    private List hintsProviders;
    private int hintsType;
    private int lastOffset = -1;
    private int lineOffset;
    private int lastLineOffset;
    private HintsUI ui = new HintsUI();
    private static HintsOperator instance = new HintsOperator();

    private HintsOperator() {
        this.hintTask = HINTS_REQUEST_PROCESSOR.create((Runnable)new HintPopupTaskImpl(false));
        this.hintPopupTask = HINTS_REQUEST_PROCESSOR.create((Runnable)new HintPopupTaskImpl(true));
        this.hintTask.setPriority(1);
        Registry.addChangeListener((ChangeListener)this);
    }

    public static HintsOperator getDefault() {
        return instance;
    }

    public synchronized void caretUpdate(CaretEvent caretEvent) {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent == null) {
            return;
        }
        if (!jTextComponent.isFocusOwner()) {
            return;
        }
        this.lastOffset = jTextComponent.getCaretPosition();
        BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
        if (baseDocument != null) {
            try {
                this.lineOffset = Utilities.getLineOffset((BaseDocument)baseDocument, (int)this.lastOffset);
                if (this.lineOffset != this.lastLineOffset && this.ui.isActive()) {
                    this.ui.setHints(null, null, false);
                }
                this.lastLineOffset = this.lineOffset;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.hintTask.schedule(200);
    }

    private void setCurrentHints(final List list, final int n, final boolean bl) {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent == null || !jTextComponent.hasFocus()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JTextComponent jTextComponent = HintsOperator.this.getComponent();
                if (jTextComponent == null) {
                    return;
                }
                jTextComponent.getDocument().render(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        HintsOperator hintsOperator = 1.access$100(this.this$1);
                        synchronized (hintsOperator) {
                            JTextComponent jTextComponent = HintsOperator.access$000(1.access$100(this.this$1));
                            if (jTextComponent == null) {
                                return;
                            }
                            HintsOperator.access$202(1.access$100(this.this$1), 1.access$300(this.this$1));
                            if (1.access$400(this.this$1) != null && 1.access$400(this.this$1).size() > 0) {
                                HintsOperator.access$600(1.access$100(this.this$1)).setHints(1.access$400(this.this$1), jTextComponent, 1.access$500(this.this$1));
                            } else {
                                HintsOperator.access$600(1.access$100(this.this$1)).setHints(null, null, false);
                            }
                        }
                    }
                });
            }

            static /* synthetic */ HintsOperator access$100(1 var0) {
                return var0.HintsOperator.this;
            }

            static /* synthetic */ int access$300(1 var0) {
                return var0.n;
            }

            static /* synthetic */ List access$400(1 var0) {
                return var0.list;
            }

            static /* synthetic */ boolean access$500(1 var0) {
                return var0.bl;
            }
        });
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.ui.setHints(null, null, false);
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.ui.setHints(null, null, false);
        this.hintTask.schedule(500);
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.componentMoved(componentEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && keyEvent.getModifiersEx() == 512 && !this.ui.isActive()) {
            if (!this.hintTask.isFinished()) {
                this.hintTask.cancel();
            }
            if (!this.hintPopupTask.isFinished()) {
                this.hintPopupTask.cancel();
            }
            this.hintPopupTask.schedule(0);
            keyEvent.consume();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JTextComponent jTextComponent = Registry.getMostActiveComponent();
        if (this.ui.getComponent() != jTextComponent) {
            this.ui.setHints(null, null, false);
            this.unregisterFromComponent();
            this.registerNewComponent(jTextComponent);
        }
    }

    private synchronized void unregisterFromComponent() {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent == null) {
            return;
        }
        if (jTextComponent != null) {
            jTextComponent.removeCaretListener(this);
            jTextComponent.removeComponentListener(this);
            jTextComponent.removeFocusListener(this);
            jTextComponent.removeKeyListener(this);
        }
        this.removeListenersFromProviders();
        this.componentRef = null;
    }

    private synchronized void registerNewComponent(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            return;
        }
        this.hintTask.cancel();
        this.componentRef = new WeakReference<JTextComponent>(jTextComponent);
        this.lastOffset = jTextComponent.getCaretPosition();
        this.gatherProviders();
        this.addListenersToProviders();
        jTextComponent.addCaretListener(this);
        jTextComponent.addComponentListener(this);
        jTextComponent.addFocusListener(this);
        jTextComponent.addKeyListener(this);
        this.hintTask.schedule(500);
    }

    private JTextComponent getComponent() {
        return this.componentRef != null ? (JTextComponent)this.componentRef.get() : null;
    }

    private void gatherProviders() {
        BaseKit baseKit = Utilities.getKit((JTextComponent)this.getComponent());
        if (baseKit == null) {
            this.hintsProviders = Collections.EMPTY_LIST;
            return;
        }
        MimeLookup mimeLookup = MimeLookup.getMimeLookup((String)baseKit.getContentType());
        Lookup.Result result = mimeLookup.lookup(new Lookup.Template(HintsProvider.class));
        this.hintsProviders = new ArrayList(result.allInstances());
    }

    private void addListenersToProviders() {
        if (this.hintsProviders == null) {
            return;
        }
        Iterator iterator = this.hintsProviders.iterator();
        while (iterator.hasNext()) {
            HintsProvider hintsProvider = (HintsProvider)iterator.next();
            hintsProvider.addPropertyChangeListener(this);
        }
    }

    private void removeListenersFromProviders() {
        if (this.hintsProviders == null) {
            return;
        }
        Iterator iterator = this.hintsProviders.iterator();
        while (iterator.hasNext()) {
            HintsProvider hintsProvider = (HintsProvider)iterator.next();
            hintsProvider.removePropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent != null && (propertyChangeEvent.getNewValue() == jTextComponent || propertyChangeEvent.getNewValue() == jTextComponent.getDocument())) {
            this.hintTask.schedule(100);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!this.ui.isActive()) {
            this.hintTask.schedule(500);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.hintTask.isFinished()) {
            this.hintTask.cancel();
        }
        if (!this.hintPopupTask.isFinished()) {
            this.hintPopupTask.cancel();
        }
        if (!this.ui.isKnownComponent(focusEvent.getOppositeComponent())) {
            this.ui.setHints(null, null, false);
            this.lineOffset = -1;
            this.lastOffset = -2;
            this.lastLineOffset = -2;
        }
    }

    static /* synthetic */ int access$202(HintsOperator hintsOperator, int n) {
        hintsOperator.hintsType = n;
        return hintsOperator.hintsType;
    }

    private class HintPopupTaskImpl
    implements Runnable {
        private boolean showPopup;
        private Throwable lastCatched;

        public HintPopupTaskImpl(boolean bl) {
            this.showPopup = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            Object object2;
            int n = -1;
            JTextComponent jTextComponent = null;
            ArrayList arrayList = HintsOperator.this;
            synchronized (arrayList) {
                n = HintsOperator.this.lastOffset;
                jTextComponent = HintsOperator.this.getComponent();
            }
            if (this.showPopup && HintsOperator.this.ui.isPopupActive()) {
                return;
            }
            if (jTextComponent == null || n == -1) {
                return;
            }
            try {
                arrayList = jTextComponent.modelToView(n);
                object2 = jTextComponent.getVisibleRect();
                if (arrayList == null || object2 == null) {
                    return;
                }
                if (((Rectangle)((Object)arrayList)).y <= ((Rectangle)object2).y) {
                    return;
                }
                if (((Rectangle)((Object)arrayList)).y + ((Rectangle)((Object)arrayList)).height > ((Rectangle)object2).y + ((Rectangle)object2).height) {
                    return;
                }
                if (((Rectangle)((Object)arrayList)).x < ((Rectangle)object2).x) {
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            arrayList = new ArrayList();
            if (ERR.isLoggable(1)) {
                ERR.log("hintsProviders = " + HintsOperator.this.hintsProviders);
            }
            object2 = HintsOperator.this.hintsProviders.iterator();
            while (object2.hasNext()) {
                block17: {
                    object = (HintsProvider)object2.next();
                    if (ERR.isLoggable(1)) {
                        ERR.log("provider = " + object);
                        ERR.log("result = " + arrayList);
                    }
                    try {
                        arrayList.addAll(((HintsProvider)object).getHints(jTextComponent.getDocument(), n));
                    }
                    catch (Throwable throwable) {
                        if (this.equalsException(this.lastCatched, throwable)) break block17;
                        this.lastCatched = throwable;
                        ErrorManager.getDefault().notify(4096, throwable);
                    }
                }
                if (!ERR.isLoggable(1)) continue;
                ERR.log("result = " + arrayList);
            }
            int n2 = 3;
            object = arrayList.iterator();
            while (object.hasNext()) {
                Hint hint = (Hint)object.next();
                if (hint.getType() >= n2) continue;
                n2 = hint.getType();
            }
            HintsOperator.this.setCurrentHints(arrayList, n2, this.showPopup);
        }

        private boolean equalsException(Throwable throwable, Throwable throwable2) {
            if (throwable == null) {
                return false;
            }
            return Arrays.equals(throwable.getStackTrace(), throwable2.getStackTrace());
        }
    }
}

