/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Utilities;
import org.netbeans.modules.editor.hints.borrowed.ListCompletionView;
import org.netbeans.modules.editor.hints.borrowed.ScrollCompletionPane;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.editor.hints.spi.Hint;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class HintsUI
implements MouseListener,
KeyListener {
    private JTextComponent comp;
    private List hints = Collections.EMPTY_LIST;
    private Popup listPopup;
    private JLabel hintIcon;
    private ScrollCompletionPane hintListComponent;
    private PopupFactory pf = null;
    private ChangeInfo changes;
    static final /* synthetic */ boolean $assertionsDisabled;

    HintsUI() {
    }

    public JTextComponent getComponent() {
        return this.comp;
    }

    public void setHints(List list, JTextComponent jTextComponent, boolean bl) {
        boolean bl2;
        if (((Object)this.hints).equals(list) && this.comp == jTextComponent) {
            return;
        }
        if (jTextComponent != this.comp || !((Object)this.hints).equals(list) && jTextComponent != null) {
            this.removePopups();
        }
        boolean bl3 = bl2 = list != null && jTextComponent != null && !list.isEmpty();
        if (!bl2 && this.comp != null) {
            this.removePopups();
        }
        this.hints = list == null ? Collections.EMPTY_LIST : list;
        this.setComponent(jTextComponent);
        if (bl2) {
            boolean bl4 = ((Hint)list.get(0)).getType() == 2;
            this.showHints();
            if (!bl4 && bl) {
                this.showPopup();
            }
        }
    }

    private void setComponent(JTextComponent jTextComponent) {
        boolean bl;
        boolean bl2 = bl = this.comp != jTextComponent;
        if (bl) {
            this.unregister();
            this.comp = jTextComponent;
            this.register();
        }
    }

    private void register() {
        if (this.comp == null) {
            return;
        }
        this.comp.addKeyListener(this);
    }

    private void unregister() {
        if (this.comp == null) {
            return;
        }
        this.comp.removeKeyListener(this);
    }

    private void removePopups() {
        if (this.comp == null) {
            return;
        }
        this.removeIconHint();
        this.removePopup();
    }

    private void removeIconHint() {
        Container container;
        if (this.hintIcon != null && (container = this.hintIcon.getParent()) != null) {
            Rectangle rectangle = this.hintIcon.getBounds();
            container.remove(this.hintIcon);
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void removePopup() {
        if (this.listPopup != null) {
            this.listPopup.hide();
            this.hintListComponent.getView().removeMouseListener(this);
            this.hintListComponent = null;
            this.listPopup = null;
            this.hintIcon.setToolTipText(NbBundle.getMessage((Class)HintsUI.class, (String)"HINT_Bulb"));
        }
    }

    boolean isKnownComponent(Component component) {
        return component != null && (component == this.comp || component == this.hintIcon || component == this.hintListComponent || component instanceof Container && ((Container)component).isAncestorOf(this.hintListComponent));
    }

    private void showHints() {
        if (this.comp == null || !this.comp.isDisplayable() || !this.comp.isShowing()) {
            return;
        }
        this.configureBounds(this.getHintIcon());
    }

    private void configureBounds(JComponent jComponent) {
        JRootPane jRootPane = this.comp.getRootPane();
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        Rectangle rectangle = null;
        try {
            int n = Utilities.getRowStart(this.comp, this.comp.getCaret().getDot());
            rectangle = this.comp.modelToView(n);
        }
        catch (BadLocationException badLocationException) {
            this.setHints(null, null, false);
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            return;
        }
        Point point = new Point(rectangle.x - this.comp.getX(), rectangle.y);
        Dimension dimension = jComponent.getPreferredSize();
        point.x -= 13;
        point.y += 4;
        SwingUtilities.convertPointToScreen(point, this.comp);
        SwingUtilities.convertPointFromScreen(point, jLayeredPane);
        jComponent.setBounds(point.x, point.y, dimension.width, dimension.height);
        jLayeredPane.add((Component)jComponent, JLayeredPane.POPUP_LAYER);
        jComponent.setVisible(true);
        jComponent.repaint();
    }

    private JLabel getHintIcon() {
        String string;
        if (this.hintIcon == null) {
            this.hintIcon = new JLabel();
            this.hintIcon.addMouseListener(this);
            this.hintIcon.setToolTipText(NbBundle.getMessage((Class)HintsUI.class, (String)"HINT_Bulb"));
        }
        if (this.hints.size() > 1) {
            string = "org/netbeans/modules/editor/hints/resources/error.png";
        } else {
            int n = 3;
            if (this.hints.size() > 0) {
                Hint hint = (Hint)this.hints.get(0);
                n = hint.getType();
            }
            string = n == 3 ? "org/netbeans/modules/editor/hints/resources/suggestion.png" : "org/netbeans/modules/editor/hints/resources/error.png";
        }
        this.hintIcon.setIcon(new ImageIcon(org.openide.util.Utilities.loadImage((String)string)));
        return this.hintIcon;
    }

    void showPopup() {
        if (this.comp == null || this.hints.isEmpty()) {
            return;
        }
        this.hintIcon.setToolTipText(null);
        ToolTipManager.sharedInstance().setEnabled(false);
        ToolTipManager.sharedInstance().setEnabled(true);
        if (!$assertionsDisabled && this.hintListComponent != null) {
            throw new AssertionError();
        }
        this.hintListComponent = new ScrollCompletionPane(this.comp, this.hints, null, null);
        this.hintListComponent.getView().addMouseListener(this);
        try {
            int n = Utilities.getRowStart(this.comp, this.comp.getCaret().getDot());
            Rectangle rectangle = this.comp.modelToView(n);
            Point point = new Point(rectangle.x + 5, rectangle.y + 20);
            SwingUtilities.convertPointToScreen(point, this.comp);
            if (!$assertionsDisabled && this.listPopup != null) {
                throw new AssertionError();
            }
            this.listPopup = this.getPopupFactory().getPopup(this.comp, this.hintListComponent, point.x, point.y);
            this.listPopup.show();
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            this.setHints(null, null, false);
        }
    }

    private PopupFactory getPopupFactory() {
        if (this.pf == null) {
            this.pf = PopupFactory.getSharedInstance();
        }
        return this.pf;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Hint hint;
        if ((mouseEvent.getSource() == this.hintListComponent || mouseEvent.getSource() instanceof ListCompletionView) && (hint = (Hint)this.hintListComponent.getView().getSelectedValue()) != null) {
            this.invokeHint(hint);
            this.setHints(null, null, false);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JLabel && !this.isPopupActive()) {
            this.showPopup();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public boolean isActive() {
        boolean bl = this.hintIcon != null && this.hintIcon.isShowing();
        boolean bl2 = this.hintListComponent != null && this.hintListComponent.isShowing();
        return bl || bl2;
    }

    public boolean isPopupActive() {
        return this.hintListComponent != null && this.hintListComponent.isShowing();
    }

    public void keyPressed(KeyEvent keyEvent) {
        InputMap inputMap;
        Object object;
        boolean bl;
        if (this.comp == null || this.hints.size() == 0) {
            return;
        }
        boolean bl2 = this.hintIcon != null && this.hintIcon.isShowing();
        boolean bl3 = bl = this.hintListComponent != null && this.hintListComponent.isShowing();
        if (keyEvent.getKeyCode() == 10) {
            if (keyEvent.getModifiersEx() == 512) {
                if (bl2 && !bl) {
                    this.showPopup();
                    keyEvent.consume();
                }
            } else if (keyEvent.getModifiersEx() == 0 && bl) {
                Hint hint = (Hint)this.hintListComponent.getView().getSelectedValue();
                this.invokeHint(hint);
                keyEvent.consume();
            }
        } else if (keyEvent.getKeyCode() == 27) {
            if (bl) {
                this.removePopup();
            }
        } else if (bl && (object = (inputMap = this.hintListComponent.getInputMap()).get(KeyStroke.getKeyStrokeForEvent(keyEvent))) != null) {
            Action action = this.hintListComponent.getActionMap().get(object);
            action.actionPerformed(null);
            keyEvent.consume();
            return;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invokeHint(final Hint hint) {
        this.removePopups();
        JTextComponent jTextComponent = this.comp;
        Cursor cursor = jTextComponent.getCursor();
        jTextComponent.setCursor(Cursor.getPredefinedCursor(3));
        RequestProcessor.Task task = null;
        try {
            task = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    HintsUI.this.changes = hint.implement();
                }
            });
            Object var6_5 = null;
            if (task == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (task == null) throw throwable;
            task.addTaskListener(new TaskListener(jTextComponent, cursor){
                private final /* synthetic */ JTextComponent val$component;
                private final /* synthetic */ Cursor val$cur;
                {
                    this.val$component = jTextComponent;
                    this.val$cur = cursor;
                }

                public void taskFinished(Task task) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            HintsUI.access$300(HintsUI.access$000(2.access$100(this.this$1)), 2.access$200(this.this$1));
                            2.access$200(this.this$1).setCursor(2.access$400(this.this$1));
                        }
                    });
                }

                static /* synthetic */ HintsUI access$100(2 var0) {
                    return var0.HintsUI.this;
                }

                static /* synthetic */ JTextComponent access$200(2 var0) {
                    return var0.val$component;
                }

                static /* synthetic */ Cursor access$400(2 var0) {
                    return var0.val$cur;
                }
            });
            throw throwable;
        }
        task.addTaskListener(new /* invalid duplicate definition of identical inner class */);
    }

    private static void open(ChangeInfo changeInfo, JTextComponent jTextComponent) {
        JTextComponent jTextComponent2 = jTextComponent;
        if (changeInfo != null && changeInfo.size() > 0) {
            Position position;
            Position position2;
            ChangeInfo.Change change = changeInfo.get(0);
            FileObject fileObject = change.getFileObject();
            if (fileObject != null) {
                try {
                    OpenCookie openCookie;
                    position2 = DataObject.find((FileObject)fileObject);
                    position = (EditCookie)position2.getCookie(EditCookie.class);
                    if (position != null) {
                        position.edit();
                    } else {
                        openCookie = (OpenCookie)position2.getCookie(OpenCookie.class);
                        openCookie.open();
                    }
                    openCookie = (EditorCookie)position2.getCookie(EditorCookie.class);
                    JEditorPane[] jEditorPaneArray = openCookie.getOpenedPanes();
                    if (jEditorPaneArray == null || jEditorPaneArray.length <= 0) {
                        return;
                    }
                    jTextComponent2 = jEditorPaneArray[0];
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
                    return;
                }
            }
            position2 = change.getStart();
            position = change.getEnd();
            if (position2 != null) {
                jTextComponent2.setSelectionStart(position2.getOffset());
            }
            if (position != null) {
                jTextComponent2.setSelectionEnd(position.getOffset());
            }
        }
    }

    static /* synthetic */ ChangeInfo access$000(HintsUI hintsUI) {
        return hintsUI.changes;
    }

    static /* synthetic */ void access$300(ChangeInfo changeInfo, JTextComponent jTextComponent) {
        HintsUI.open(changeInfo, jTextComponent);
    }

    static {
        $assertionsDisabled = !HintsUI.class.desiredAssertionStatus();
    }
}

