/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints.borrowed;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.editor.LocaleSupport;
import org.openide.awt.HtmlRenderer;

public class ListCompletionView
extends JList {
    public ListCompletionView() {
        this.setSelectionMode(0);
        this.setCellRenderer(new ListCellRenderer(){
            private HtmlRenderer.Renderer defaultRenderer = HtmlRenderer.createRenderer();

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.defaultRenderer.reset();
                Component component = this.defaultRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
                this.defaultRenderer.setHtml(true);
                this.defaultRenderer.setParentFocused(true);
                return component;
            }
        });
        this.getAccessibleContext().setAccessibleName(LocaleSupport.getString((String)"ACSN_CompletionView"));
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_CompletionView"));
    }

    public void setResult(List list) {
        if (list != null) {
            this.setModel(new Model(list));
            if (list.size() > 0) {
                this.setSelectedIndex(0);
            }
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = super.getPreferredScrollableViewportSize();
        Dimension dimension2 = this.getPreferredSize();
        return new Dimension(dimension.width, dimension2.height);
    }

    public void up() {
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(Math.max(this.getSelectedIndex() - 1, 0));
            this.ensureIndexIsVisible(this.getSelectedIndex());
            this.repaint();
        }
    }

    public void down() {
        int n = this.getModel().getSize() - 1;
        if (n >= 0) {
            this.setSelectedIndex(Math.min(this.getSelectedIndex() + 1, n));
            this.ensureIndexIsVisible(this.getSelectedIndex());
            this.validate();
        }
    }

    public void pageUp() {
        if (this.getModel().getSize() > 0) {
            int n = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            int n2 = Math.max(this.getSelectedIndex() - n, 0);
            this.setSelectedIndex(n2);
            this.ensureIndexIsVisible(n2);
        }
    }

    public void pageDown() {
        int n = this.getModel().getSize() - 1;
        if (n >= 0) {
            int n2 = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            int n3 = Math.min(this.getSelectedIndex() + n2, n);
            this.setSelectedIndex(n3);
            this.ensureIndexIsVisible(n3);
        }
    }

    public void begin() {
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
            this.ensureIndexIsVisible(0);
        }
    }

    public void end() {
        int n = this.getModel().getSize() - 1;
        if (n >= 0) {
            this.setSelectedIndex(n);
            this.ensureIndexIsVisible(n);
        }
    }

    static class Model
    extends AbstractListModel {
        List data;
        static final long serialVersionUID = 3292276783870598274L;

        public Model(List list) {
            this.data = list;
        }

        public int getSize() {
            return this.data.size();
        }

        public Object getElementAt(int n) {
            return n >= 0 && n < this.data.size() ? this.data.get(n) : null;
        }

        List getData() {
            return this.data;
        }
    }
}

