/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints.borrowed;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.modules.editor.hints.borrowed.ListCompletionView;
import org.netbeans.modules.editor.hints.spi.Hint;

public class ScrollCompletionPane
extends JScrollPane
implements SettingsChangeListener {
    private static final String COMPLETION_UP = "completion-up";
    private static final String COMPLETION_DOWN = "completion-down";
    private static final String COMPLETION_PGUP = "completion-pgup";
    private static final String COMPLETION_PGDN = "completion-pgdn";
    private static final String COMPLETION_BEGIN = "completion-begin";
    private static final String COMPLETION_END = "completion-end";
    private static final int ACTION_COMPLETION_UP = 1;
    private static final int ACTION_COMPLETION_DOWN = 2;
    private static final int ACTION_COMPLETION_PGUP = 3;
    private static final int ACTION_COMPLETION_PGDN = 4;
    private static final int ACTION_COMPLETION_BEGIN = 5;
    private static final int ACTION_COMPLETION_END = 6;
    private JTextComponent component;
    private ListCompletionView view;
    private JLabel topLabel;
    private Dimension minSize;
    private Dimension maxSize;
    private Dimension scrollBarSize;

    public ScrollCompletionPane(JTextComponent jTextComponent, List list, String string, ListSelectionListener listSelectionListener) {
        this.component = jTextComponent;
        Dimension dimension = super.getPreferredSize();
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(22);
        this.scrollBarSize = super.getPreferredSize();
        this.scrollBarSize.width -= dimension.width;
        this.scrollBarSize.height -= dimension.height;
        this.setVerticalScrollBarPolicy(20);
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
        this.settingsChange(null);
        this.view = new ListCompletionView();
        this.view.setResult(list);
        this.resetViewSize();
        this.setViewportView(this.view);
        this.setTitle(string);
        this.installKeybindings();
        this.setFocusable(false);
        this.view.setFocusable(false);
    }

    public ListCompletionView getView() {
        return this.view;
    }

    public void reset(List list, String string) {
        this.view.setResult(list);
        this.resetViewSize();
        this.setTitle(string);
    }

    public Hint getSelectedCompletionItem() {
        Object e = this.view.getSelectedValue();
        return e instanceof Hint ? (Hint)e : null;
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        Class clazz = Utilities.getKitClass((JTextComponent)this.component);
        if (clazz != null) {
            this.minSize = (Dimension)SettingsUtil.getValue((Class)clazz, (String)"completion-pane-min-size", (Object)ExtSettingsDefaults.defaultCompletionPaneMinSize);
            this.setMinimumSize(this.minSize);
            this.maxSize = (Dimension)SettingsUtil.getValue((Class)clazz, (String)"completion-pane-max-size", (Object)ExtSettingsDefaults.defaultCompletionPaneMaxSize);
            this.setMaximumSize(this.maxSize);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n = dimension.width + this.scrollBarSize.width;
        boolean bl = n > this.maxSize.width;
        n = Math.max(Math.max(n, this.minSize.width), this.getTitleComponentPreferredSize().width);
        n = Math.min(n, this.maxSize.width);
        int n2 = bl ? dimension.height + this.scrollBarSize.height : dimension.height;
        n2 = Math.min(n2, this.maxSize.height);
        n2 = Math.max(n2, this.minSize.height);
        return new Dimension(n, n2);
    }

    private void resetViewSize() {
        Dimension dimension = this.view.getPreferredSize();
        if (dimension.width > this.maxSize.width - this.scrollBarSize.width) {
            dimension.width = this.maxSize.width - this.scrollBarSize.width;
            this.view.setPreferredSize(dimension);
        }
    }

    private void setTitle(String string) {
        if (string == null) {
            if (this.topLabel != null) {
                this.setColumnHeader(null);
                this.topLabel = null;
            }
        } else if (this.topLabel != null) {
            this.topLabel.setText(string);
        } else {
            this.topLabel = new JLabel(string);
            this.topLabel.setForeground(Color.blue);
            this.topLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.setColumnHeaderView(this.topLabel);
        }
    }

    private Dimension getTitleComponentPreferredSize() {
        return this.topLabel != null ? this.topLabel.getPreferredSize() : new Dimension();
    }

    private KeyStroke[] findEditorKeys(String string, KeyStroke keyStroke) {
        KeyStroke[] keyStrokeArray = new KeyStroke[]{keyStroke};
        if (this.component != null) {
            KeyStroke[] keyStrokeArray2;
            Action action;
            EditorKit editorKit;
            TextUI textUI = this.component.getUI();
            Keymap keymap = this.component.getKeymap();
            if (textUI != null && keymap != null && (editorKit = textUI.getEditorKit(this.component)) instanceof BaseKit && (action = ((BaseKit)editorKit).getActionByName(string)) != null && (keyStrokeArray2 = keymap.getKeyStrokesForAction(action)) != null && keyStrokeArray2.length > 0) {
                keyStrokeArray = keyStrokeArray2;
            }
        }
        return keyStrokeArray;
    }

    private void registerKeybinding(int n, String string, KeyStroke keyStroke, String string2) {
        KeyStroke[] keyStrokeArray = this.findEditorKeys(string2, keyStroke);
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            this.getInputMap().put(keyStrokeArray[i], string);
        }
        this.getActionMap().put(string, new CompletionPaneAction(n));
    }

    private void installKeybindings() {
        this.registerKeybinding(1, COMPLETION_UP, KeyStroke.getKeyStroke(38, 0), "caret-up");
        this.registerKeybinding(2, COMPLETION_DOWN, KeyStroke.getKeyStroke(40, 0), "caret-down");
        this.registerKeybinding(4, COMPLETION_PGDN, KeyStroke.getKeyStroke(34, 0), "page-down");
        this.registerKeybinding(3, COMPLETION_PGUP, KeyStroke.getKeyStroke(33, 0), "page-up");
        this.registerKeybinding(5, COMPLETION_BEGIN, KeyStroke.getKeyStroke(36, 0), "caret-begin-line");
        this.registerKeybinding(6, COMPLETION_END, KeyStroke.getKeyStroke(35, 0), "caret-end-line");
    }

    private class CompletionPaneAction
    extends AbstractAction {
        private int action;

        private CompletionPaneAction(int n) {
            this.action = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.action) {
                case 1: {
                    ScrollCompletionPane.this.view.up();
                    break;
                }
                case 2: {
                    ScrollCompletionPane.this.view.down();
                    break;
                }
                case 3: {
                    ScrollCompletionPane.this.view.pageUp();
                    break;
                }
                case 4: {
                    ScrollCompletionPane.this.view.pageDown();
                    break;
                }
                case 5: {
                    ScrollCompletionPane.this.view.begin();
                    break;
                }
                case 6: {
                    ScrollCompletionPane.this.view.end();
                }
            }
        }
    }
}

