/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.aqua;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class ShapeGradientContext
implements PaintContext {
    protected Color shadowColor;
    protected Color bgColor;
    protected Rectangle r;
    int cornerRadius = 6;
    int shadowWidth = 21;
    private WritableRaster raster = null;
    int[] last = new int[]{-1, -1, -1, -1};
    private static int[] data = new int[4];
    private static Point2D.Double POINT = new Point2D.Double();

    public ShapeGradientContext(Rectangle rectangle, Color color, Color color2) {
        this.shadowColor = color;
        this.bgColor = color2;
        this.r = rectangle;
        rectangle.height -= this.cornerRadius * 2;
        rectangle.width -= this.cornerRadius * 4;
        rectangle.x += this.cornerRadius * 2 + 1;
        rectangle.y += this.cornerRadius;
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        if (this.raster != null && n == this.last[0] && n2 == this.last[1] && n3 == this.last[2] && n4 == this.last[3]) {
            return this.raster;
        }
        this.last[0] = n;
        this.last[1] = n2;
        this.last[2] = n3;
        this.last[3] = n4;
        this.raster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (i < this.r.y + this.r.height - (this.shadowWidth + this.cornerRadius)) {
                    int n5 = n3 - (this.r.x + this.r.width + this.shadowWidth + this.cornerRadius);
                    if (j > this.shadowWidth + this.cornerRadius && n3 < n5) {
                        j = n5;
                    }
                }
                double d = 1.0;
                Point2D.Double double_ = POINT;
                double_.setLocation(j > this.r.x + this.r.width ? (double)(this.r.x + this.r.width) : (j < this.r.x ? (double)this.r.x : (double)j), Math.min(i, n2 + this.r.y + this.r.height));
                double d2 = double_.distance(n + j, n2 + i) + 1.0;
                d2 *= d2 / (double)(this.shadowWidth - n + this.cornerRadius);
                if (i <= this.cornerRadius * 2) {
                    double d3 = (double)(this.cornerRadius * 2) / (double)i;
                    d2 *= d3;
                }
                if ((d = d2 / (double)(this.shadowWidth - n)) > 1.0) {
                    d = 1.0;
                }
                int n6 = 0;
                ShapeGradientContext.data[n6 + 0] = (int)((double)this.shadowColor.getRed() + d * (double)(this.bgColor.getRed() - this.shadowColor.getRed()));
                ShapeGradientContext.data[n6 + 1] = (int)((double)this.shadowColor.getGreen() + d * (double)(this.bgColor.getGreen() - this.shadowColor.getGreen()));
                ShapeGradientContext.data[n6 + 2] = (int)((double)this.shadowColor.getBlue() + d * (double)(this.bgColor.getBlue() - this.shadowColor.getBlue()));
                ShapeGradientContext.data[n6 + 3] = (int)((double)this.shadowColor.getAlpha() + d * (double)(this.bgColor.getAlpha() - this.shadowColor.getAlpha()));
                this.raster.setPixels(j, i, 1, 1, data);
            }
        }
        return this.raster;
    }
}

