/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.navigator;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.navigator.NavigatorTC;
import org.netbeans.modules.navigator.ProviderRegistry;
import org.netbeans.spi.navigator.NavigatorLookupHint;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class NavigatorController
implements LookupListener,
ActionListener,
Lookup.Provider,
PropertyChangeListener {
    static final int COALESCE_TIME = 100;
    private NavigatorTC navigatorTC;
    private RequestProcessor.Task nodeSetterTask;
    private final Object NODE_SETTER_LOCK = new Object();
    private static final Lookup.Template CUR_NODES = new Lookup.Template(Node.class);
    private static final Lookup.Template CUR_HINTS = new Lookup.Template(NavigatorLookupHint.class);
    private Lookup.Result curNodes;
    private Lookup.Result curHints;
    private Node curNode;
    private WeakReference oldNodeRef;
    private final Lookup clientsLookup;
    private final Lookup panelLookup;
    private Reference lastActivatedRef;

    public NavigatorController(NavigatorTC navigatorTC) {
        this.navigatorTC = navigatorTC;
        this.clientsLookup = Lookups.proxy((Lookup.Provider)this);
        this.panelLookup = Lookups.proxy((Lookup.Provider)new PanelLookupWrapper());
    }

    public void navigatorTCOpened() {
        this.curNodes = Utilities.actionsGlobalContext().lookup(CUR_NODES);
        this.curNodes.addLookupListener((LookupListener)this);
        this.curHints = Utilities.actionsGlobalContext().lookup(CUR_HINTS);
        this.curHints.addLookupListener((LookupListener)this);
        this.navigatorTC.getPanelSelector().addActionListener(this);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        this.updateContext();
    }

    public void navigatorTCClosed() {
        this.curNodes.removeLookupListener((LookupListener)this);
        this.curHints.removeLookupListener((LookupListener)this);
        this.navigatorTC.getPanelSelector().removeActionListener(this);
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        this.curNodes = null;
        this.curHints = null;
        this.curNode = null;
        this.lastActivatedRef = null;
    }

    public Lookup getPanelLookup() {
        return this.panelLookup;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        NavigatorPanel navigatorPanel;
        int n = this.navigatorTC.getPanelSelector().getSelectedIndex();
        if (n == -1) {
            return;
        }
        NavigatorPanel navigatorPanel2 = (NavigatorPanel)this.navigatorTC.getPanels().get(n);
        if (!navigatorPanel2.equals(navigatorPanel = this.navigatorTC.getSelectedPanel())) {
            if (navigatorPanel != null) {
                navigatorPanel.panelDeactivated();
            }
            navigatorPanel2.panelActivated(this.clientsLookup);
            this.navigatorTC.setSelectedPanel(navigatorPanel2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultChanged(LookupEvent lookupEvent) {
        if (!((Object)((Object)this.navigatorTC)).equals(WindowManager.getDefault().getRegistry().getActivated())) {
            ActNodeSetter actNodeSetter = new ActNodeSetter();
            Object object = this.NODE_SETTER_LOCK;
            synchronized (object) {
                if (this.nodeSetterTask != null) {
                    this.nodeSetterTask.cancel();
                }
                this.nodeSetterTask = RequestProcessor.getDefault().post((Runnable)actNodeSetter, 100);
                this.nodeSetterTask.addTaskListener((TaskListener)actNodeSetter);
            }
        }
    }

    private Node obtainFirstCurNode() {
        Collection collection = this.curNodes.allInstances();
        return collection.isEmpty() ? null : (Node)collection.iterator().next();
    }

    private void updateContext() {
        Node[] nodeArray;
        Node node = this.curNode = this.obtainFirstCurNode();
        Node node2 = this.oldNodeRef != null ? (Node)this.oldNodeRef.get() : null;
        this.oldNodeRef = node != null ? new WeakReference<Node>(node) : null;
        List list = this.obtainProviders(node);
        List list2 = this.navigatorTC.getPanels();
        if (node == null) {
            nodeArray = new Node[]{};
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = node;
        }
        this.navigatorTC.setActivatedNodes(nodeArray);
        this.updateTCTitle(list != null && !list.isEmpty() ? node : null);
        if (list2 == null && list == null) {
            return;
        }
        NavigatorPanel navigatorPanel = this.navigatorTC.getSelectedPanel();
        if (list2 != null && list2.contains(navigatorPanel) && list != null && list.contains(navigatorPanel)) {
            this.clientsLookup.lookup(Node.class);
            return;
        }
        if (navigatorPanel != null) {
            navigatorPanel.panelDeactivated();
        }
        if (list != null && list.size() > 0) {
            NavigatorPanel navigatorPanel2 = (NavigatorPanel)list.get(0);
            navigatorPanel2.panelActivated(this.clientsLookup);
        }
        this.navigatorTC.getPanelSelector().removeActionListener(this);
        this.navigatorTC.setPanels(list);
        this.navigatorTC.getPanelSelector().addActionListener(this);
    }

    private void updateTCTitle(Node node) {
        String string = node != null ? NbBundle.getMessage((Class)NavigatorTC.class, (String)"FMT_Navigator", (Object)node.getDisplayName()) : NbBundle.getMessage((Class)NavigatorTC.class, (String)"LBL_Navigator");
        this.navigatorTC.setName(string);
    }

    List obtainProviders(Node node) {
        List list;
        ArrayList arrayList = null;
        NavigatorLookupHint navigatorLookupHint = (NavigatorLookupHint)Utilities.actionsGlobalContext().lookup(NavigatorLookupHint.class);
        if (navigatorLookupHint != null && (list = ProviderRegistry.getInstance().getProviders(navigatorLookupHint.getContentType())) != null && !list.isEmpty()) {
            arrayList = new ArrayList(list.size());
            arrayList.addAll(list);
        }
        if (node != null) {
            FileObject fileObject;
            list = (DataObject)node.getLookup().lookup(DataObject.class);
            while (list instanceof DataShadow) {
                list = ((DataShadow)list).getOriginal();
            }
            if (list != null && !(fileObject = list.getPrimaryFile()).isVirtual()) {
                String string = fileObject.getMIMEType();
                List list2 = ProviderRegistry.getInstance().getProviders(string);
                if (list2 != null && !list2.isEmpty()) {
                    if (arrayList == null) {
                        arrayList = new ArrayList(list2.size());
                    }
                    arrayList.addAll(list2);
                }
            }
        }
        return arrayList;
    }

    public Lookup getLookup() {
        if (this.curNode == null) {
            return Lookup.EMPTY;
        }
        return this.curNode.getLookup();
    }

    public void installActions() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.navigatorTC.getInputMap(2).put(keyStroke, "return");
        this.navigatorTC.getActionMap().put("return", new ESCHandler());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        TopComponent topComponent;
        if ("activated".equals(propertyChangeEvent.getPropertyName()) && (topComponent = TopComponent.getRegistry().getActivated()) != null && topComponent != this.navigatorTC) {
            this.lastActivatedRef = new WeakReference<TopComponent>(topComponent);
        }
    }

    private class ActNodeSetter
    implements Runnable,
    TaskListener {
        private ActNodeSetter() {
        }

        public void run() {
            if (RequestProcessor.getDefault().isRequestProcessorThread()) {
                SwingUtilities.invokeLater(this);
            } else if (NavigatorController.this.curNodes != null) {
                NavigatorController.this.updateContext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskFinished(Task task) {
            Object object = NavigatorController.this.NODE_SETTER_LOCK;
            synchronized (object) {
                if (task == NavigatorController.this.nodeSetterTask) {
                    NavigatorController.this.nodeSetterTask = null;
                }
            }
        }
    }

    private class PanelLookupWrapper
    implements Lookup.Provider {
        private PanelLookupWrapper() {
        }

        public Lookup getLookup() {
            Lookup lookup;
            NavigatorPanel navigatorPanel = NavigatorController.this.navigatorTC.getSelectedPanel();
            if (navigatorPanel != null && (lookup = navigatorPanel.getLookup()) != null) {
                return lookup;
            }
            return Lookup.EMPTY;
        }
    }

    private class ESCHandler
    extends AbstractAction {
        private ESCHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = FocusManager.getCurrentManager().getFocusOwner();
            if (NavigatorController.this.lastActivatedRef == null || component == null || !SwingUtilities.isDescendingFrom(component, (Component)((Object)NavigatorController.this.navigatorTC)) || component instanceof JComboBox) {
                return;
            }
            TopComponent topComponent = (TopComponent)NavigatorController.this.lastActivatedRef.get();
            if (topComponent != null) {
                topComponent.requestActive();
            }
        }
    }
}

