/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.navigator;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.modules.navigator.NavigatorController;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class NavigatorTC
extends TopComponent {
    private static NavigatorTC instance;
    private NavigatorPanel selectedPanel;
    private List panels;
    private NavigatorController controller;
    private final JLabel notAvailLbl = new JLabel(NbBundle.getMessage((Class)NavigatorTC.class, (String)"MSG_NotAvailable"));
    private Lookup navTCLookup;
    private JPanel contentArea;
    private JComboBox panelSelector;
    static final /* synthetic */ boolean $assertionsDisabled;

    private NavigatorTC() {
        this.initComponents();
        this.setName(NbBundle.getMessage((Class)NavigatorTC.class, (String)"LBL_Navigator"));
        this.setIcon(Utilities.loadImage((String)"org/netbeans/modules/navigator/resources/navigator.png"));
        this.setFocusable(true);
        this.putClientProperty("SlidingName", this.getName());
        this.notAvailLbl.setHorizontalAlignment(0);
        this.notAvailLbl.setEnabled(false);
        Color color = UIManager.getColor("window");
        this.notAvailLbl.setBackground(color != null ? color : Color.white);
        this.notAvailLbl.setOpaque(true);
        this.getController().installActions();
        this.setToEmpty();
    }

    public static final NavigatorTC getInstance() {
        NavigatorTC navigatorTC = (NavigatorTC)WindowManager.getDefault().findTopComponent("navigatorTC");
        if (navigatorTC == null) {
            navigatorTC = NavigatorTC.privateGetInstance();
            ErrorManager.getDefault().log(1, "Could not locate the navigator component via its winsys id");
        }
        return navigatorTC;
    }

    public static final NavigatorTC privateGetInstance() {
        if (instance == null) {
            instance = new NavigatorTC();
        }
        return instance;
    }

    public void setSelectedPanel(NavigatorPanel navigatorPanel) {
        int n = this.panels.indexOf(navigatorPanel);
        if (!$assertionsDisabled && n == -1) {
            throw new AssertionError((Object)"Panel to select is not available");
        }
        this.selectedPanel = navigatorPanel;
        ((CardLayout)this.contentArea.getLayout()).show(this.contentArea, String.valueOf(n));
    }

    public NavigatorPanel getSelectedPanel() {
        return this.selectedPanel;
    }

    public List getPanels() {
        return this.panels;
    }

    public void setPanels(List list) {
        int n;
        this.panels = list;
        int n2 = n = list == null ? -1 : list.size();
        if (n <= 0) {
            this.selectedPanel = null;
            this.setToEmpty();
        } else {
            this.contentArea.removeAll();
            this.panelSelector.removeAllItems();
            this.panelSelector.setVisible(n != 1);
            NavigatorPanel navigatorPanel = null;
            JComponent jComponent = null;
            int n3 = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                navigatorPanel = (NavigatorPanel)iterator.next();
                this.panelSelector.addItem(navigatorPanel.getDisplayName());
                jComponent = navigatorPanel.getComponent();
                if (jComponent == null) {
                    NullPointerException nullPointerException = new NullPointerException("Method " + navigatorPanel.getClass().getName() + ".getComponent() must not return null under any condition!");
                    ErrorManager.getDefault().notify(4096, (Throwable)nullPointerException);
                } else {
                    this.contentArea.add((Component)jComponent, String.valueOf(n3));
                }
                if (n3 == 0) {
                    this.selectedPanel = navigatorPanel;
                }
                ++n3;
            }
            this.resetFromEmpty();
        }
    }

    public JComboBox getPanelSelector() {
        return this.panelSelector;
    }

    public JComponent getContentArea() {
        return this.contentArea;
    }

    public String preferredID() {
        return "navigatorTC";
    }

    public int getPersistenceType() {
        return 0;
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        boolean bl = false;
        if (this.selectedPanel != null) {
            bl = this.selectedPanel.getComponent().requestFocusInWindow();
        }
        return bl;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("navigator.java");
    }

    public void componentOpened() {
        this.getController().navigatorTCOpened();
    }

    public void componentClosed() {
        this.getController().navigatorTCClosed();
    }

    public Lookup getLookup() {
        if (this.navTCLookup == null) {
            Lookup lookup = super.getLookup();
            Lookup lookup2 = this.getController().getPanelLookup();
            this.navTCLookup = new ProxyLookup(new Lookup[]{lookup, lookup2});
        }
        return this.navTCLookup;
    }

    private NavigatorController getController() {
        if (this.controller == null) {
            this.controller = new NavigatorController(this);
        }
        return this.controller;
    }

    private void setToEmpty() {
        if (this.notAvailLbl.isShowing()) {
            return;
        }
        this.remove(this.panelSelector);
        this.remove(this.contentArea);
        this.add(this.notAvailLbl, "Center");
        this.revalidate();
        this.repaint();
    }

    private void resetFromEmpty() {
        if (this.contentArea.isShowing()) {
            // empty if block
        }
        this.remove(this.notAvailLbl);
        this.add(this.panelSelector, "North");
        this.add(this.contentArea, "Center");
        this.revalidate();
        this.repaint();
    }

    private void initComponents() {
        this.panelSelector = new JComboBox();
        this.contentArea = new JPanel();
        this.setLayout(new BorderLayout());
        this.add(this.panelSelector, "North");
        this.contentArea.setLayout(new CardLayout());
        this.add(this.contentArea, "Center");
    }

    static {
        $assertionsDisabled = !NavigatorTC.class.desiredAssertionStatus();
    }
}

