/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.navigator;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;

class ProviderRegistry {
    private static final String PANELS_FOLDER = "/Navigator/Panels/";
    private static final Lookup.Template NAV_PANEL_TEMPLATE = new Lookup.Template(NavigatorPanel.class);
    private static ProviderRegistry instance;
    private Map contentTypes2Providers;

    private ProviderRegistry() {
    }

    public static ProviderRegistry getInstance() {
        if (instance == null) {
            instance = new ProviderRegistry();
        }
        return instance;
    }

    public List getProviders(String string) {
        List list;
        if (this.contentTypes2Providers == null) {
            this.contentTypes2Providers = new HashMap(15);
        }
        if ((list = (List)this.contentTypes2Providers.get(string)) == null) {
            list = this.loadProviders(string);
            this.contentTypes2Providers.put(string, list);
        }
        return list;
    }

    private List loadProviders(String string) {
        DataObject.Container container;
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(PANELS_FOLDER + string);
        if (fileObject == null) {
            ErrorManager.getDefault().log(1, "No providers for content type " + string);
            return Collections.EMPTY_LIST;
        }
        try {
            container = DataFolder.findContainer((FileObject)fileObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, "Navigator content type " + string + " is probably malformed, as it doesn't point to folder.");
            ErrorManager.getDefault().notify(16, (Throwable)illegalArgumentException);
            return Collections.EMPTY_LIST;
        }
        FolderLookup folderLookup = new FolderLookup(container, "");
        Lookup.Result result = folderLookup.getLookup().lookup(NAV_PANEL_TEMPLATE);
        return (List)result.allInstances();
    }
}

