/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.core.multiview.MultiViewElementCallbackDelegate;
import org.netbeans.core.multiview.MultiViewHandlerDelegate;
import org.netbeans.core.multiview.MultiViewModel;
import org.netbeans.core.multiview.MultiViewPeer;
import org.netbeans.core.multiview.SpiAccessor;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.openide.awt.UndoRedo;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public final class MultiViewCloneableTopComponent
extends CloneableTopComponent
implements MultiViewModel.ActionRequestObserverFactory,
CloneableEditorSupport.Pane {
    MultiViewPeer peer = new MultiViewPeer((TopComponent)this, this);

    public MultiViewCloneableTopComponent() {
        this.peer.initComponents();
        this.setFocusCycleRoot(false);
        this.setName("");
        this.associateLookup(this.peer.getLookup());
    }

    public void setMultiViewDescriptions(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription) {
        this.peer.setMultiViewDescriptions(multiViewDescriptionArray, multiViewDescription);
    }

    public void setCloseOperationHandler(CloseOperationHandler closeOperationHandler) {
        this.peer.setCloseOperationHandler(closeOperationHandler);
    }

    private void setDeserializedMultiViewDescriptions(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription, Map map) {
        this.peer.setDeserializedMultiViewDescriptions(multiViewDescriptionArray, multiViewDescription, map);
    }

    MultiViewModel getModel() {
        return this.peer.getModel();
    }

    protected void componentClosed() {
        super.componentClosed();
        this.peer.peerComponentClosed();
    }

    protected void componentShowing() {
        super.componentShowing();
        this.peer.peerComponentShowing();
    }

    protected void componentHidden() {
        super.componentHidden();
        this.peer.peerComponentHidden();
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        this.peer.peerComponentDeactivated();
    }

    protected void componentActivated() {
        super.componentActivated();
        this.peer.peerComponentActivated();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.peer.peerComponentOpened();
    }

    public boolean requestFocusInWindow() {
        return this.peer.requestFocusInWindow();
    }

    public void requestFocus() {
        this.peer.requestFocus();
    }

    private void hideElement(MultiViewDescription multiViewDescription) {
        this.peer.hideElement(multiViewDescription);
    }

    private void showCurrentElement() {
        this.peer.showCurrentElement();
    }

    public Action[] getActions() {
        Action[] actionArray = super.getActions();
        Action[] actionArray2 = this.peer.peerGetActions(actionArray);
        return actionArray2;
    }

    public MultiViewHandlerDelegate getMultiViewHandlerDelegate() {
        return this.peer.getMultiViewHandlerDelegate();
    }

    public int getPersistenceType() {
        return this.peer.getPersistenceType();
    }

    protected String preferredID() {
        return this.peer.preferredID();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        this.peer.peerWriteExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.peer.peerReadExternal(objectInput);
    }

    Action[] getDefaultTCActions() {
        return super.getActions();
    }

    public MultiViewElementCallback createElementCallback(MultiViewDescription multiViewDescription) {
        return SpiAccessor.DEFAULT.createCallback(new ActReqObserver(multiViewDescription));
    }

    public CloneableTopComponent getComponent() {
        return this;
    }

    public JEditorPane getEditorPane() {
        if (this.peer == null || this.peer.model == null) {
            return null;
        }
        MultiViewElement multiViewElement = this.findPaneElement();
        if (multiViewElement != null) {
            CloneableEditorSupport.Pane pane = (CloneableEditorSupport.Pane)multiViewElement.getVisualRepresentation();
            return pane.getEditorPane();
        }
        return null;
    }

    private MultiViewElement findPaneElement() {
        MultiViewElement multiViewElement = this.peer.model.getActiveElement(false);
        if (multiViewElement != null && multiViewElement.getVisualRepresentation() instanceof CloneableEditorSupport.Pane) {
            return multiViewElement;
        }
        Collection collection = this.peer.model.getCreatedElements();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            multiViewElement = (MultiViewElement)iterator.next();
            if (!(multiViewElement.getVisualRepresentation() instanceof CloneableEditorSupport.Pane)) continue;
            return multiViewElement;
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return this.peer.getHelpCtx();
    }

    public String toString() {
        return "MVCTC[name=" + this.getDisplayName() + ", peer=" + this.peer + "]";
    }

    public UndoRedo getUndoRedo() {
        UndoRedo undoRedo = this.peer.peerGetUndoRedo();
        if (undoRedo == null) {
            undoRedo = super.getUndoRedo();
        }
        return undoRedo;
    }

    public boolean canClose() {
        return this.peer.canClose();
    }

    public void updateName() {
        if (this.peer != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.peer.updateName();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MultiViewCloneableTopComponent.this.peer.updateName();
                    }
                });
            }
        }
    }

    public void ensureVisible() {
        MultiViewElement multiViewElement = this.findPaneElement();
        if (multiViewElement != null) {
            this.open();
            MultiViewElementCallback multiViewElementCallback = this.peer.getModel().getCallbackForElement(multiViewElement);
            multiViewElementCallback.requestVisible();
        }
    }

    class ActReqObserver
    implements Serializable,
    MultiViewElementCallbackDelegate {
        private static final long serialVersionUID = -3126744916624172415L;
        private MultiViewDescription description;

        ActReqObserver(MultiViewDescription multiViewDescription) {
            this.description = multiViewDescription;
        }

        public void requestActive() {
            boolean bl = MultiViewCloneableTopComponent.this.peer.isActivated();
            if (!bl) {
                MultiViewCloneableTopComponent.this.requestActive();
            }
            if (MultiViewCloneableTopComponent.this.peer.model.getActiveDescription() != this.description) {
                if (bl) {
                    MultiViewCloneableTopComponent.this.peer.model.getActiveElement().componentDeactivated();
                }
                MultiViewCloneableTopComponent.this.peer.tabs.changeActiveManually(this.description);
                if (bl) {
                    MultiViewCloneableTopComponent.this.peer.model.getActiveElement().componentActivated();
                }
            }
        }

        public void requestVisible() {
            MultiViewCloneableTopComponent.this.peer.tabs.changeVisibleManually(this.description);
        }

        public Action[] createDefaultActions() {
            return MultiViewCloneableTopComponent.this.getDefaultTCActions();
        }

        public void updateTitle(String string) {
            MultiViewCloneableTopComponent.this.setDisplayName(string);
        }

        public Object writeReplace() throws ObjectStreamException {
            return null;
        }

        public Object readResolve() throws ObjectStreamException {
            return null;
        }

        public boolean isSelectedElement() {
            return this.description.equals(MultiViewCloneableTopComponent.this.peer.model.getActiveDescription());
        }

        public TopComponent getTopComponent() {
            return MultiViewCloneableTopComponent.this;
        }
    }
}

