/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.multiview.Accessor;
import org.netbeans.core.multiview.TabsComponent;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;

class MultiViewModel {
    private MultiViewDescription currentEditor;
    private Map nestedElements;
    private Map nestedCallbacks;
    private Map nestedPerspectives;
    private MultiViewDescription[] descriptions;
    private ButtonGroup group;
    private Collection shownElements;
    private ArrayList listeners;
    private ActionRequestObserverFactory observerFactory;

    MultiViewModel(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription, ActionRequestObserverFactory actionRequestObserverFactory) {
        this(multiViewDescriptionArray, multiViewDescription, actionRequestObserverFactory, Collections.EMPTY_MAP);
    }

    MultiViewModel(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription, ActionRequestObserverFactory actionRequestObserverFactory, Map map) {
        this.observerFactory = actionRequestObserverFactory;
        this.nestedElements = new HashMap();
        this.nestedPerspectives = new HashMap();
        this.nestedCallbacks = new HashMap();
        this.shownElements = new HashSet(multiViewDescriptionArray.length + 3);
        this.descriptions = multiViewDescriptionArray;
        this.group = this.group;
        for (int i = 0; i < this.descriptions.length; ++i) {
            MultiViewElement multiViewElement = (MultiViewElement)map.get(this.descriptions[i]);
            this.nestedElements.put(this.descriptions[i], multiViewElement);
            this.nestedPerspectives.put(this.descriptions[i], Accessor.DEFAULT.createPerspective(this.descriptions[i]));
            if (multiViewElement == null) continue;
            MultiViewElementCallback multiViewElementCallback = actionRequestObserverFactory.createElementCallback(this.descriptions[i]);
            this.nestedCallbacks.put(multiViewElement, multiViewElementCallback);
            multiViewElement.setMultiViewCallback(multiViewElementCallback);
        }
        this.currentEditor = multiViewDescription == null || !this.nestedElements.containsKey(multiViewDescription) ? this.descriptions[0] : multiViewDescription;
        this.group = new BtnGroup();
    }

    void setActiveDescription(MultiViewDescription multiViewDescription) {
        if (this.currentEditor == multiViewDescription) {
            return;
        }
        MultiViewDescription multiViewDescription2 = this.currentEditor;
        this.currentEditor = multiViewDescription;
        this.fireSelectionChanged(multiViewDescription2, multiViewDescription);
    }

    MultiViewDescription getActiveDescription() {
        return this.currentEditor;
    }

    MultiViewElement getActiveElement() {
        return this.getActiveElement(true);
    }

    MultiViewElement getActiveElement(boolean bl) {
        return this.getElementForDescription(this.currentEditor, bl);
    }

    synchronized Collection getCreatedElements() {
        ArrayList arrayList = new ArrayList(this.nestedElements.size());
        Iterator iterator = this.nestedElements.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() == null) continue;
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    boolean wasShownBefore(MultiViewElement multiViewElement) {
        return this.shownElements.contains(multiViewElement);
    }

    void markAsShown(MultiViewElement multiViewElement) {
        this.shownElements.add(multiViewElement);
    }

    void markAsHidden(MultiViewElement multiViewElement) {
        this.shownElements.remove(multiViewElement);
    }

    MultiViewDescription[] getDescriptions() {
        return this.descriptions;
    }

    MultiViewPerspective[] getPerspectives() {
        MultiViewPerspective[] multiViewPerspectiveArray = new MultiViewPerspective[this.descriptions.length];
        for (int i = 0; i < this.descriptions.length; ++i) {
            multiViewPerspectiveArray[i] = (MultiViewPerspective)this.nestedPerspectives.get(this.descriptions[i]);
        }
        return multiViewPerspectiveArray;
    }

    MultiViewPerspective getSelectedPerspective() {
        return (MultiViewPerspective)this.nestedPerspectives.get(this.getActiveDescription());
    }

    ButtonGroup getButtonGroup() {
        return this.group;
    }

    MultiViewElement getElementForDescription(MultiViewDescription multiViewDescription) {
        return this.getElementForDescription(multiViewDescription, true);
    }

    synchronized MultiViewElement getElementForDescription(MultiViewDescription multiViewDescription, boolean bl) {
        MultiViewElement multiViewElement = (MultiViewElement)this.nestedElements.get(multiViewDescription);
        if (multiViewElement == null && bl) {
            multiViewElement = multiViewDescription.createElement();
            MultiViewElementCallback multiViewElementCallback = this.observerFactory.createElementCallback(multiViewDescription);
            this.nestedCallbacks.put(multiViewElement, multiViewElementCallback);
            multiViewElement.setMultiViewCallback(multiViewElementCallback);
            this.nestedElements.put(multiViewDescription, multiViewElement);
        }
        return multiViewElement;
    }

    synchronized MultiViewElementCallback getCallbackForElement(MultiViewElement multiViewElement) {
        return (MultiViewElementCallback)this.nestedCallbacks.get(multiViewElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addElementSelectionListener(ElementSelectionListener elementSelectionListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(elementSelectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeElementSelectionListener(ElementSelectionListener elementSelectionListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(elementSelectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSelectionChanged(MultiViewDescription multiViewDescription, MultiViewDescription multiViewDescription2) {
        if (this.listeners != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    ElementSelectionListener elementSelectionListener = (ElementSelectionListener)iterator.next();
                    elementSelectionListener.selectionChanged(multiViewDescription, multiViewDescription2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireActivateCurrent() {
        if (this.listeners != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    ElementSelectionListener elementSelectionListener = (ElementSelectionListener)iterator.next();
                    elementSelectionListener.selectionActivatedByButton();
                }
            }
        }
    }

    public String toString() {
        return "current=" + this.currentEditor;
    }

    private class BtnGroup
    extends ButtonGroup {
        private BtnGroup() {
        }

        public void setSelected(ButtonModel buttonModel, boolean bl) {
            super.setSelected(buttonModel, bl);
            if (this.getSelection() instanceof TabsComponent.TabsButtonModel) {
                TabsComponent.TabsButtonModel tabsButtonModel = (TabsComponent.TabsButtonModel)buttonModel;
                MultiViewDescription multiViewDescription = tabsButtonModel.getButtonsDescription();
                MultiViewModel.this.setActiveDescription(multiViewDescription);
            }
        }
    }

    static interface ActionRequestObserverFactory {
        public MultiViewElementCallback createElementCallback(MultiViewDescription var1);
    }

    static interface ElementSelectionListener {
        public void selectionChanged(MultiViewDescription var1, MultiViewDescription var2);

        public void selectionActivatedByButton();
    }
}

