/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassLoaderSupport;
import org.netbeans.modules.java.classpath.ClassPathAccessor;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public final class ClassPath {
    public static final String EXECUTE = "classpath/execute";
    public static final String DEBUG = "classpath/debug";
    public static final String COMPILE = "classpath/compile";
    public static final String SOURCE = "classpath/source";
    public static final String BOOT = "classpath/boot";
    public static final String PROP_ROOTS = "roots";
    public static final String PROP_ENTRIES = "entries";
    private static final ErrorManager ERR;
    private static final Lookup.Result implementations;
    private ClassPathImplementation impl;
    private FileObject[] rootsCache;
    private PropertyChangeListener pListener;
    private RootsListener rootsListener;
    private List entriesCache;
    private PropertyChangeSupport propSupport;
    private static final Reference EMPTY_REF;
    private Reference refClassLoader = EMPTY_REF;
    static final /* synthetic */ boolean $assertionsDisabled;

    public synchronized FileObject[] getRoots() {
        if (this.rootsCache == null) {
            List list = this.entries();
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject;
                Entry entry = (Entry)iterator.next();
                RootsListener rootsListener = this.getRootsListener();
                if (rootsListener != null) {
                    rootsListener.addRoot(entry.getURL());
                }
                if ((fileObject = entry.getRoot()) == null) continue;
                arrayList.add(fileObject);
            }
            this.rootsCache = arrayList.toArray(new FileObject[arrayList.size()]);
        }
        return this.rootsCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List entries() {
        Object object = this;
        synchronized (object) {
            if (this.entriesCache != null) {
                return this.entriesCache;
            }
        }
        object = this.impl.getResources();
        ClassPath classPath = this;
        synchronized (classPath) {
            if (this.entriesCache == null) {
                if (object == null) {
                    this.entriesCache = Collections.EMPTY_LIST;
                } else {
                    ArrayList<Entry> arrayList = new ArrayList<Entry>();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        PathResourceImplementation pathResourceImplementation = (PathResourceImplementation)iterator.next();
                        URL[] uRLArray = pathResourceImplementation.getRoots();
                        for (int i = 0; i < uRLArray.length; ++i) {
                            Entry entry = new Entry(uRLArray[i]);
                            arrayList.add(entry);
                        }
                    }
                    this.entriesCache = Collections.unmodifiableList(arrayList);
                }
            }
        }
        return this.entriesCache;
    }

    private ClassPath(ClassPathImplementation classPathImplementation) {
        if (classPathImplementation == null) {
            throw new IllegalArgumentException();
        }
        this.impl = classPathImplementation;
        this.pListener = new SPIListener();
        this.impl.addPropertyChangeListener(this.pListener);
        this.propSupport = new PropertyChangeSupport(this);
    }

    public final FileObject findResource(String string) {
        FileObject[] fileObjectArray = this.getRoots();
        return ClassPath.findResourceImpl(fileObjectArray, new int[]{0}, ClassPath.parseResourceName(string));
    }

    public final List findAllResources(String string) {
        FileObject[] fileObjectArray = this.getRoots();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(fileObjectArray.length);
        int[] nArray = new int[]{0};
        String[] stringArray = ClassPath.parseResourceName(string);
        while (nArray[0] < fileObjectArray.length) {
            FileObject fileObject = ClassPath.findResourceImpl(fileObjectArray, nArray, stringArray);
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    public final String getResourceName(FileObject fileObject) {
        return this.getResourceName(fileObject, '/', true);
    }

    public final String getResourceName(FileObject fileObject, char c, boolean bl) {
        int n;
        FileObject fileObject2 = this.findOwnerRoot(fileObject);
        if (fileObject2 == null) {
            return null;
        }
        String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!bl && (n = string.lastIndexOf(46)) >= 0 && n > string.lastIndexOf(47)) {
            string = string.substring(0, n);
        }
        if (c != '/') {
            string = string.replace('/', c);
        }
        return string;
    }

    public final FileObject findOwnerRoot(FileObject fileObject) {
        FileObject[] fileObjectArray = this.getRoots();
        HashSet<FileObject> hashSet = new HashSet<FileObject>(Arrays.asList(fileObjectArray));
        for (FileObject fileObject2 = fileObject; fileObject2 != null; fileObject2 = fileObject2.getParent()) {
            if (!hashSet.contains(fileObject2)) continue;
            return fileObject2;
        }
        return null;
    }

    public final boolean contains(FileObject fileObject) {
        return this.findOwnerRoot(fileObject) != null;
    }

    public final boolean isResourceVisible(FileObject fileObject) {
        String string = this.getResourceName(fileObject);
        if (string == null) {
            return false;
        }
        return this.findResource(string) == fileObject;
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.rootsListener == null) {
            this.rootsListener = new RootsListener(this);
            if (this.rootsCache != null) {
                List list = this.entries();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Entry entry = (Entry)iterator.next();
                    this.rootsListener.addRoot(entry.getURL());
                }
            }
        }
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public static ClassPath getClassPath(FileObject fileObject, String string) {
        if (fileObject == null) {
            Thread.dumpStack();
            return null;
        }
        boolean bl = ERR.isLoggable(1);
        if (bl) {
            ERR.log("CP.getClassPath: " + fileObject + " of type " + string);
        }
        Iterator iterator = implementations.allInstances().iterator();
        while (iterator.hasNext()) {
            ClassPathProvider classPathProvider = (ClassPathProvider)iterator.next();
            ClassPath classPath = classPathProvider.findClassPath(fileObject, string);
            if (classPath == null) continue;
            if (bl) {
                ERR.log("  got result " + classPath + " from " + classPathProvider);
            }
            return classPath;
        }
        return null;
    }

    final void firePropertyChange(String string, Object object, Object object2) {
        this.propSupport.firePropertyChange(string, object, object2);
    }

    public String toString() {
        return "ClassPath" + this.entries();
    }

    private static String[] parseResourceName(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>(string.length() / 4);
        char[] cArray = string.toCharArray();
        int n2 = -1;
        int n3 = 0;
        block4: for (n = 0; n < cArray.length; ++n) {
            char c = cArray[n];
            switch (c) {
                case '.': {
                    n2 = n;
                    continue block4;
                }
                case '/': {
                    if (n2 != -1) {
                        arrayList.add(string.substring(n3, n2));
                        arrayList.add(string.substring(n2 + 1, n));
                    } else {
                        arrayList.add(string.substring(n3, n));
                        arrayList.add(null);
                    }
                    n3 = n + 1;
                    n2 = -1;
                }
            }
        }
        if (n > n3) {
            if (n2 != -1) {
                arrayList.add(string.substring(n3, n2));
                arrayList.add(string.substring(n2 + 1, n));
            } else {
                arrayList.add(string.substring(n3, n));
                arrayList.add(null);
            }
        }
        if (arrayList.size() % 2 != 0) {
            System.err.println("parsed size is not even!!");
            System.err.println("input = " + string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static FileObject findPath(FileObject fileObject, String[] stringArray) {
        for (int i = 0; i < stringArray.length && fileObject != null; i += 2) {
            FileObject fileObject2 = fileObject.getFileObject(stringArray[i], stringArray[i + 1]);
            fileObject = fileObject2;
        }
        return fileObject;
    }

    private static FileObject findResourceImpl(FileObject[] fileObjectArray, int[] nArray, String[] stringArray) {
        int n;
        FileObject fileObject = null;
        for (n = nArray[0]; n < fileObjectArray.length && fileObject == null; ++n) {
            fileObject = ClassPath.findPath(fileObjectArray[n], stringArray);
        }
        nArray[0] = n;
        return fileObject;
    }

    synchronized void resetClassLoader(ClassLoader classLoader) {
        if (this.refClassLoader.get() == classLoader) {
            this.refClassLoader = EMPTY_REF;
        }
    }

    public final synchronized ClassLoader getClassLoader(boolean bl) {
        Object object = this.refClassLoader.get();
        if (!bl || object == null) {
            object = ClassLoaderSupport.create(this);
            this.refClassLoader = new SoftReference(object);
        }
        return (ClassLoader)object;
    }

    private synchronized RootsListener getRootsListener() {
        return this.rootsListener;
    }

    static /* synthetic */ FileObject[] access$602(ClassPath classPath, FileObject[] fileObjectArray) {
        classPath.rootsCache = fileObjectArray;
        return fileObjectArray;
    }

    static {
        $assertionsDisabled = !ClassPath.class.desiredAssertionStatus();
        ClassPathAccessor.DEFAULT = new ClassPathAccessor(){

            public ClassPath createClassPath(ClassPathImplementation classPathImplementation) {
                return new ClassPath(classPathImplementation);
            }

            public ClassPathImplementation getClassPathImpl(ClassPath classPath) {
                return classPath == null ? null : classPath.impl;
            }
        };
        ERR = ErrorManager.getDefault().getInstance(ClassPath.class.getName());
        implementations = Lookup.getDefault().lookup(new Lookup.Template(ClassPathProvider.class));
        EMPTY_REF = new SoftReference<Object>(null);
    }

    private static class RootsListener
    extends WeakReference
    implements FileChangeListener,
    Runnable {
        private boolean initialized;
        private Set roots = new HashSet();
        private static FileSystem[] fileSystems;
        static final /* synthetic */ boolean $assertionsDisabled;

        private RootsListener(ClassPath classPath) {
            super(classPath, Utilities.activeReferenceQueue());
        }

        public void addRoot(URL uRL) {
            Object object;
            if (!this.isInitialized()) {
                object = RootsListener.getFileSystems();
                if (object != null && ((FileSystem[])object).length > 0) {
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        Object object2 = object[i];
                        if (object2 == null) continue;
                        object2.addFileChangeListener((FileChangeListener)this);
                    }
                    this.setInitialized(true);
                } else {
                    ErrorManager.getDefault().log(65536, "Can not find file system, not able to listen on changes.");
                }
            }
            if ("jar".equals(uRL.getProtocol())) {
                uRL = FileUtil.getArchiveFile((URL)uRL);
            }
            if (((String)(object = uRL.getPath())).endsWith("/")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            this.roots.add(object);
        }

        public void removeRoot(URL uRL) {
            String string;
            if ("jar".equals(uRL.getProtocol())) {
                uRL = FileUtil.getArchiveFile((URL)uRL);
            }
            if ((string = uRL.getPath()).endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            this.roots.remove(string);
        }

        public void removeAllRoots() {
            this.roots.clear();
            FileSystem[] fileSystemArray = RootsListener.getFileSystems();
            for (int i = 0; i < fileSystemArray.length; ++i) {
                FileSystem fileSystem = fileSystemArray[i];
                if (fileSystem == null) continue;
                fileSystem.removeFileChangeListener((FileChangeListener)this);
            }
            this.initialized = false;
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.processEvent(fileEvent);
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.processEvent(fileEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileChanged(FileEvent fileEvent) {
            ClassPath classPath;
            if (!this.isInitialized()) {
                return;
            }
            String string = RootsListener.getPath(fileEvent.getFile());
            if (this.roots.contains(string) && (classPath = (ClassPath)this.get()) != null) {
                ClassPath classPath2 = classPath;
                synchronized (classPath2) {
                    ClassPath.access$602(classPath, null);
                    this.removeAllRoots();
                }
                classPath.firePropertyChange(ClassPath.PROP_ROOTS, null, null);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.processEvent(fileEvent);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.processEvent((FileEvent)fileRenameEvent);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void run() {
            if (this.isInitialized()) {
                FileSystem[] fileSystemArray = RootsListener.getFileSystems();
                for (int i = 0; i < fileSystemArray.length; ++i) {
                    FileSystem fileSystem = fileSystemArray[i];
                    if (fileSystem == null) continue;
                    fileSystem.removeFileChangeListener((FileChangeListener)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processEvent(FileEvent fileEvent) {
            if (!this.isInitialized()) {
                return;
            }
            String string = RootsListener.getPath(fileEvent.getFile());
            if (string == null) {
                return;
            }
            ClassPath classPath = (ClassPath)this.get();
            if (classPath == null) {
                return;
            }
            boolean bl = false;
            ClassPath classPath2 = classPath;
            synchronized (classPath2) {
                Iterator iterator = this.roots.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (!string2.startsWith(string)) continue;
                    ClassPath.access$602(classPath, null);
                    this.removeAllRoots();
                    bl = true;
                    break;
                }
            }
            if (bl) {
                classPath.firePropertyChange(ClassPath.PROP_ROOTS, null, null);
            }
        }

        private static String getPath(FileObject fileObject) {
            if (fileObject == null) {
                return null;
            }
            try {
                URL uRL = fileObject.getURL();
                String string = uRL.getPath();
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                return string;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                return null;
            }
        }

        private synchronized boolean isInitialized() {
            return this.initialized;
        }

        private synchronized void setInitialized(boolean bl) {
            this.initialized = bl;
        }

        private static FileSystem[] getFileSystems() {
            if (fileSystems != null) {
                return fileSystems;
            }
            File[] fileArray = File.listRoots();
            LinkedHashSet<FileSystem> linkedHashSet = new LinkedHashSet<FileSystem>();
            if (!($assertionsDisabled || fileArray != null && fileArray.length > 0)) {
                throw new AssertionError((Object)"Could not list file roots");
            }
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                FileObject fileObject = FileUtil.toFileObject((File)file);
                if (fileObject == null) continue;
                try {
                    FileSystem fileSystem = fileObject.getFileSystem();
                    linkedHashSet.add(fileSystem);
                    if (fileSystem == null) continue;
                    break;
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    throw new AssertionError((Object)fileStateInvalidException);
                }
            }
            FileSystem[] fileSystemArray = new FileSystem[linkedHashSet.size()];
            linkedHashSet.toArray(fileSystemArray);
            if (!$assertionsDisabled && fileSystemArray.length <= 0) {
                throw new AssertionError((Object)"Could not get any filesystem");
            }
            fileSystems = fileSystemArray;
            return fileSystemArray;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$api$java$classpath$ClassPath == null ? (class$org$netbeans$api$java$classpath$ClassPath = ClassPath.class$("org.netbeans.api.java.classpath.ClassPath")) : class$org$netbeans$api$java$classpath$ClassPath).desiredAssertionStatus();
        }
    }

    private class SPIListener
    implements PropertyChangeListener {
        private SPIListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == ClassPath.this.impl && "resources".equals(propertyChangeEvent.getPropertyName())) {
                ClassPath classPath = ClassPath.this;
                synchronized (classPath) {
                    RootsListener rootsListener = ClassPath.this.getRootsListener();
                    if (rootsListener != null) {
                        rootsListener.removeAllRoots();
                    }
                    ClassPath.this.entriesCache = null;
                    ClassPath.access$602(ClassPath.this, null);
                }
                ClassPath.this.firePropertyChange(ClassPath.PROP_ENTRIES, null, null);
                ClassPath.this.firePropertyChange(ClassPath.PROP_ROOTS, null, null);
            }
        }
    }

    public final class Entry {
        private URL url;
        private FileObject root;
        private IOException lastError;

        public ClassPath getDefiningClassPath() {
            return ClassPath.this;
        }

        public synchronized FileObject getRoot() {
            if (this.root == null || !this.root.isValid()) {
                this.root = URLMapper.findFileObject((URL)this.url);
                if (this.root == null) {
                    this.lastError = new IOException(MessageFormat.format("The package root {0} does not exist or can not be read.", this.url));
                    return null;
                }
                if (this.root.isData()) {
                    throw new IllegalArgumentException("Invalid ClassPath root: " + this.url + ". The root must be a folder.");
                }
            }
            return this.root;
        }

        public boolean isValid() {
            FileObject fileObject = this.getRoot();
            return fileObject != null && fileObject.isValid();
        }

        public IOException getError() {
            IOException iOException = this.lastError;
            this.lastError = null;
            return iOException;
        }

        public URL getURL() {
            return this.url;
        }

        Entry(URL uRL) {
            if (uRL == null) {
                throw new IllegalArgumentException();
            }
            this.url = uRL;
        }

        public String toString() {
            return "Entry[" + this.url + "]";
        }
    }
}

