/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.openide.filesystems.FileObject;

public final class GlobalPathRegistry {
    private static GlobalPathRegistry DEFAULT;
    private int resetCount;
    private final Map paths = new HashMap();
    private final List listeners = new ArrayList();
    private Set sourceRoots = null;
    private Set results = new HashSet();
    private final ChangeListener resultListener = new SFBQListener();
    private PropertyChangeListener classpathListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            GlobalPathRegistry globalPathRegistry = GlobalPathRegistry.this;
            synchronized (globalPathRegistry) {
                GlobalPathRegistry.this.resetSourceRootsCache();
            }
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;

    public static GlobalPathRegistry getDefault() {
        return DEFAULT;
    }

    private GlobalPathRegistry() {
    }

    void clear() {
        this.paths.clear();
        this.listeners.clear();
    }

    public synchronized Set getPaths(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        List list = (List)this.paths.get(string);
        if (list != null && !list.isEmpty()) {
            return Collections.unmodifiableSet(new HashSet(list));
        }
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String string, ClassPath[] classPathArray) {
        if (string == null || classPathArray == null) {
            throw new NullPointerException();
        }
        GlobalPathRegistryEvent globalPathRegistryEvent = null;
        GlobalPathRegistryListener[] globalPathRegistryListenerArray = null;
        GlobalPathRegistry globalPathRegistry = this;
        synchronized (globalPathRegistry) {
            ArrayList<ClassPath> arrayList = (ArrayList<ClassPath>)this.paths.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<ClassPath>();
                this.paths.put(string, arrayList);
            }
            HashSet<ClassPath> hashSet = this.listeners.isEmpty() ? null : new HashSet<ClassPath>();
            for (int i = 0; i < classPathArray.length; ++i) {
                if (classPathArray[i] == null) {
                    throw new NullPointerException("Null path encountered in " + Arrays.asList(classPathArray) + " of type " + string);
                }
                if (hashSet != null && !hashSet.contains(classPathArray[i]) && !arrayList.contains(classPathArray[i])) {
                    hashSet.add(classPathArray[i]);
                }
                if (!arrayList.contains(classPathArray[i])) {
                    classPathArray[i].addPropertyChangeListener(this.classpathListener);
                }
                arrayList.add(classPathArray[i]);
            }
            if (hashSet != null && !hashSet.isEmpty()) {
                globalPathRegistryListenerArray = this.listeners.toArray(new GlobalPathRegistryListener[this.listeners.size()]);
                globalPathRegistryEvent = new GlobalPathRegistryEvent(this, string, Collections.unmodifiableSet(hashSet));
            }
            this.resetSourceRootsCache();
        }
        if (globalPathRegistryListenerArray != null) {
            if (!$assertionsDisabled && globalPathRegistryEvent == null) {
                throw new AssertionError();
            }
            for (int i = 0; i < globalPathRegistryListenerArray.length; ++i) {
                globalPathRegistryListenerArray[i].pathsAdded(globalPathRegistryEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String string, ClassPath[] classPathArray) throws IllegalArgumentException {
        if (string == null || classPathArray == null) {
            throw new NullPointerException();
        }
        GlobalPathRegistryEvent globalPathRegistryEvent = null;
        GlobalPathRegistryListener[] globalPathRegistryListenerArray = null;
        GlobalPathRegistry globalPathRegistry = this;
        synchronized (globalPathRegistry) {
            ArrayList arrayList = (ArrayList)this.paths.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            ArrayList arrayList2 = new ArrayList(arrayList);
            HashSet<ClassPath> hashSet = this.listeners.isEmpty() ? null : new HashSet<ClassPath>();
            for (int i = 0; i < classPathArray.length; ++i) {
                if (classPathArray[i] == null) {
                    throw new NullPointerException();
                }
                if (!arrayList2.remove(classPathArray[i])) {
                    throw new IllegalArgumentException("Attempt to remove nonexistent path " + classPathArray[i]);
                }
                if (hashSet != null && !hashSet.contains(classPathArray[i]) && !arrayList2.contains(classPathArray[i])) {
                    hashSet.add(classPathArray[i]);
                }
                if (arrayList2.contains(classPathArray[i])) continue;
                classPathArray[i].removePropertyChangeListener(this.classpathListener);
            }
            this.paths.put(string, arrayList2);
            if (hashSet != null && !hashSet.isEmpty()) {
                globalPathRegistryListenerArray = this.listeners.toArray(new GlobalPathRegistryListener[this.listeners.size()]);
                globalPathRegistryEvent = new GlobalPathRegistryEvent(this, string, Collections.unmodifiableSet(hashSet));
            }
            this.resetSourceRootsCache();
        }
        if (globalPathRegistryListenerArray != null) {
            if (!$assertionsDisabled && globalPathRegistryEvent == null) {
                throw new AssertionError();
            }
            for (int i = 0; i < globalPathRegistryListenerArray.length; ++i) {
                globalPathRegistryListenerArray[i].pathsRemoved(globalPathRegistryEvent);
            }
        }
    }

    public synchronized void addGlobalPathRegistryListener(GlobalPathRegistryListener globalPathRegistryListener) {
        if (globalPathRegistryListener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(globalPathRegistryListener);
    }

    public synchronized void removeGlobalPathRegistryListener(GlobalPathRegistryListener globalPathRegistryListener) {
        if (globalPathRegistryListener == null) {
            throw new NullPointerException();
        }
        this.listeners.remove(globalPathRegistryListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getSourceRoots() {
        Object object;
        Object object2;
        LinkedHashSet linkedHashSet;
        Set set;
        int n;
        Set set2 = this;
        synchronized (set2) {
            if (this.sourceRoots != null) {
                return this.sourceRoots;
            }
            n = this.resetCount;
            set = this.getPaths("classpath/source");
            linkedHashSet = new LinkedHashSet(this.getPaths("classpath/compile"));
            linkedHashSet.addAll(this.getPaths("classpath/boot"));
        }
        set2 = new LinkedHashSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (ClassPath)iterator.next();
            set2.addAll(Arrays.asList(((ClassPath)object2).getRoots()));
        }
        object2 = new LinkedList();
        SFBQListener sFBQListener = new SFBQListener();
        iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            object = (ClassPath)iterator.next();
            Iterator iterator2 = ((ClassPath)object).entries().iterator();
            while (iterator2.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)iterator2.next();
                SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots(entry.getURL());
                result.addChangeListener(sFBQListener);
                object2.add(result);
                FileObject[] fileObjectArray = result.getRoots();
                set2.addAll(Arrays.asList(fileObjectArray));
            }
        }
        set2 = Collections.unmodifiableSet(set2);
        object = this;
        synchronized (object) {
            if (this.resetCount == n) {
                this.sourceRoots = set2;
                this.removeTmpSFBQListeners((List)object2, sFBQListener, true);
                this.results.addAll(object2);
            } else {
                this.removeTmpSFBQListeners((List)object2, sFBQListener, false);
            }
            return set2;
        }
    }

    private void removeTmpSFBQListeners(List list, ChangeListener changeListener, boolean bl) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SourceForBinaryQuery.Result result = (SourceForBinaryQuery.Result)iterator.next();
            if (bl) {
                result.addChangeListener(this.resultListener);
            }
            result.removeChangeListener(changeListener);
        }
    }

    public FileObject findResource(String string) {
        Iterator iterator = this.getSourceRoots().iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            FileObject fileObject2 = fileObject.getFileObject(string);
            if (fileObject2 == null) continue;
            return fileObject2;
        }
        return null;
    }

    private synchronized void resetSourceRootsCache() {
        this.sourceRoots = null;
        Iterator iterator = this.results.iterator();
        while (iterator.hasNext()) {
            SourceForBinaryQuery.Result result = (SourceForBinaryQuery.Result)iterator.next();
            result.removeChangeListener(this.resultListener);
        }
        ++this.resetCount;
    }

    static {
        $assertionsDisabled = !GlobalPathRegistry.class.desiredAssertionStatus();
        DEFAULT = new GlobalPathRegistry();
    }

    private class SFBQListener
    implements ChangeListener {
        private SFBQListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent changeEvent) {
            GlobalPathRegistry globalPathRegistry = GlobalPathRegistry.this;
            synchronized (globalPathRegistry) {
                GlobalPathRegistry.this.resetSourceRootsCache();
            }
        }
    }
}

