/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.util.Iterator;
import org.netbeans.spi.java.queries.AccessibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class AccessibilityQuery {
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(AccessibilityQueryImplementation.class));

    private AccessibilityQuery() {
    }

    public static Boolean isPubliclyAccessible(FileObject fileObject) {
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + fileObject);
        }
        Iterator iterator = implementations.allInstances().iterator();
        while (iterator.hasNext()) {
            AccessibilityQueryImplementation accessibilityQueryImplementation = (AccessibilityQueryImplementation)iterator.next();
            Boolean bl = accessibilityQueryImplementation.isPubliclyAccessible(fileObject);
            if (bl == null) continue;
            return bl;
        }
        return null;
    }
}

