/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class JavadocForBinaryQuery {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(JavadocForBinaryQuery.class.getName());
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(JavadocForBinaryQueryImplementation.class));
    private static final Result EMPTY_RESULT = new EmptyResult();

    private JavadocForBinaryQuery() {
    }

    public static Result findJavadoc(URL uRL) {
        if (FileUtil.isArchiveFile((URL)uRL)) {
            throw new IllegalArgumentException("File URL pointing to JAR is not valid classpath entry. Use jar: URL. Was: " + uRL);
        }
        boolean bl = ERR.isLoggable(1);
        if (bl) {
            ERR.log("JFBQ.findJavadoc: " + uRL);
        }
        Iterator iterator = implementations.allInstances().iterator();
        while (iterator.hasNext()) {
            JavadocForBinaryQueryImplementation javadocForBinaryQueryImplementation = (JavadocForBinaryQueryImplementation)iterator.next();
            Result result = javadocForBinaryQueryImplementation.findJavadoc(uRL);
            if (result != null) {
                if (bl) {
                    ERR.log("  got result " + Arrays.asList(result.getRoots()) + " from " + javadocForBinaryQueryImplementation);
                }
                return result;
            }
            if (!bl) continue;
            ERR.log("  got no result from " + javadocForBinaryQueryImplementation);
        }
        if (bl) {
            ERR.log("  got no results from any impl");
        }
        return EMPTY_RESULT;
    }

    private static final class EmptyResult
    implements Result {
        private static final URL[] NO_ROOTS = new URL[0];

        EmptyResult() {
        }

        public URL[] getRoots() {
            return NO_ROOTS;
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    public static interface Result {
        public URL[] getRoots();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

