/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class SourceForBinaryQuery {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(SourceForBinaryQuery.class.getName());
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(SourceForBinaryQueryImplementation.class));
    private static final Result EMPTY_RESULT = new EmptyResult();

    private SourceForBinaryQuery() {
    }

    public static Result findSourceRoots(URL uRL) {
        if (FileUtil.isArchiveFile((URL)uRL)) {
            throw new IllegalArgumentException("File URL pointing to JAR is not valid classpath entry. Use jar: URL. Was: " + uRL);
        }
        if (!uRL.toExternalForm().endsWith("/")) {
            throw new IllegalArgumentException("Folder URL must end with '/'. Was: " + uRL);
        }
        boolean bl = ERR.isLoggable(1);
        if (bl) {
            ERR.log("SFBQ.findSourceRoots: " + uRL);
        }
        Iterator iterator = implementations.allInstances().iterator();
        while (iterator.hasNext()) {
            SourceForBinaryQueryImplementation sourceForBinaryQueryImplementation = (SourceForBinaryQueryImplementation)iterator.next();
            Result result = sourceForBinaryQueryImplementation.findSourceRoots(uRL);
            if (result == null) continue;
            if (bl) {
                ERR.log("  got result " + Arrays.asList(result.getRoots()) + " from " + sourceForBinaryQueryImplementation);
            }
            return result;
        }
        return EMPTY_RESULT;
    }

    private static final class EmptyResult
    implements Result {
        private static final FileObject[] NO_ROOTS = new FileObject[0];

        EmptyResult() {
        }

        public FileObject[] getRoots() {
            return NO_ROOTS;
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    public static interface Result {
        public FileObject[] getRoots();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

