/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.openide.util.WeakListeners;

public class ProxyClassPathImplementation
implements ClassPathImplementation {
    private ClassPathImplementation[] classPaths;
    private List resourcesCache;
    private ArrayList listeners;
    private PropertyChangeListener classPathsListener;

    public ProxyClassPathImplementation(ClassPathImplementation[] classPathImplementationArray) {
        if (classPathImplementationArray == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<ClassPathImplementation> arrayList = new ArrayList<ClassPathImplementation>();
        this.classPathsListener = new DelegatesListener();
        for (int i = 0; i < classPathImplementationArray.length; ++i) {
            if (classPathImplementationArray[i] == null) continue;
            classPathImplementationArray[i].addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.classPathsListener, (Object)classPathImplementationArray[i]));
            arrayList.add(classPathImplementationArray[i]);
        }
        this.classPaths = arrayList.toArray(new ClassPathImplementation[arrayList.size()]);
    }

    public synchronized List getResources() {
        if (this.resourcesCache == null) {
            ArrayList arrayList = new ArrayList(this.classPaths.length * 10);
            for (int i = 0; i < this.classPaths.length; ++i) {
                arrayList.addAll(this.classPaths[i].getResources());
            }
            this.resourcesCache = Collections.unmodifiableList(arrayList);
        }
        return this.resourcesCache;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(propertyChangeListener);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < this.classPaths.length; ++i) {
            stringBuffer.append(this.classPaths[i].toString());
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private class DelegatesListener
    implements PropertyChangeListener {
        private DelegatesListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Iterator iterator = null;
            Object object = ProxyClassPathImplementation.this;
            synchronized (object) {
                ProxyClassPathImplementation.this.resourcesCache = null;
                if (ProxyClassPathImplementation.this.listeners == null) {
                    return;
                }
                iterator = ((ArrayList)ProxyClassPathImplementation.this.listeners.clone()).iterator();
            }
            object = new PropertyChangeEvent(ProxyClassPathImplementation.this, propertyChangeEvent.getPropertyName(), null, null);
            while (iterator.hasNext()) {
                ((PropertyChangeListener)iterator.next()).propertyChange((PropertyChangeEvent)object);
            }
        }
    }
}

