/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.ant.AntArtifactQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class AntArtifactQuery {
    private AntArtifactQuery() {
    }

    public static AntArtifact findArtifactFromFile(File file) {
        if (!file.equals(FileUtil.normalizeFile((File)file))) {
            throw new IllegalArgumentException("Parameter file was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile((File)file));
        }
        Iterator iterator = Lookup.getDefault().lookup(new Lookup.Template(AntArtifactQueryImplementation.class)).allInstances().iterator();
        while (iterator.hasNext()) {
            AntArtifactQueryImplementation antArtifactQueryImplementation = (AntArtifactQueryImplementation)iterator.next();
            AntArtifact antArtifact = antArtifactQueryImplementation.findArtifact(file);
            if (antArtifact == null) continue;
            return antArtifact;
        }
        return null;
    }

    public static AntArtifact findArtifactByID(Project project, String string) {
        AntArtifactProvider antArtifactProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class);
        if (antArtifactProvider == null) {
            return null;
        }
        AntArtifact[] antArtifactArray = antArtifactProvider.getBuildArtifacts();
        for (int i = 0; i < antArtifactArray.length; ++i) {
            if (!antArtifactArray[i].getID().equals(string)) continue;
            return antArtifactArray[i];
        }
        return null;
    }

    public static AntArtifact[] findArtifactsByType(Project project, String string) {
        AntArtifactProvider antArtifactProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class);
        if (antArtifactProvider == null) {
            return new AntArtifact[0];
        }
        AntArtifact[] antArtifactArray = antArtifactProvider.getBuildArtifacts();
        ArrayList<AntArtifact> arrayList = new ArrayList<AntArtifact>(antArtifactArray.length);
        for (int i = 0; i < antArtifactArray.length; ++i) {
            if (!antArtifactArray[i].getType().equals(string)) continue;
            arrayList.add(antArtifactArray[i]);
        }
        return arrayList.toArray(new AntArtifact[arrayList.size()]);
    }
}

