/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ant.Util;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class AntBasedProjectFactorySingleton
implements ProjectFactory {
    public static final String PROJECT_XML_PATH = "nbproject/project.xml";
    public static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    private static final Map project2Helper;
    private static final Map helper2Project;
    private static final Map type2Projects;
    private static final Lookup.Result antBasedProjectTypes;
    private static Map antBasedProjectTypesByType;
    public static AntProjectHelperCallback HELPER_CALLBACK;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static void antBasedProjectTypesRemoved(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AntBasedProjectType antBasedProjectType = (AntBasedProjectType)iterator.next();
            List list = (List)type2Projects.get(antBasedProjectType);
            if (list != null) {
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    Reference reference = (Reference)iterator2.next();
                    Object t = reference.get();
                    if (t == null) continue;
                    AntProjectHelper antProjectHelper = (AntProjectHelper)t;
                    antProjectHelper.notifyDeleted();
                }
            }
            type2Projects.remove(antBasedProjectType);
        }
    }

    private static synchronized AntBasedProjectType findAntBasedProjectType(String string) {
        if (antBasedProjectTypesByType == null) {
            Iterator iterator = new ArrayList(antBasedProjectTypes.allInstances()).iterator();
            antBasedProjectTypesByType = new HashMap();
            while (iterator.hasNext()) {
                AntBasedProjectType antBasedProjectType = (AntBasedProjectType)iterator.next();
                antBasedProjectTypesByType.put(antBasedProjectType.getType(), antBasedProjectType);
            }
        }
        return (AntBasedProjectType)antBasedProjectTypesByType.get(string);
    }

    public boolean isProject(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return false;
        }
        File file2 = new File(new File(file, "nbproject"), "project.xml");
        return file2.isFile();
    }

    public Project loadProject(FileObject fileObject, ProjectState projectState) throws IOException {
        Document document;
        if (FileUtil.toFile((FileObject)fileObject) == null) {
            return null;
        }
        FileObject fileObject2 = fileObject.getFileObject(PROJECT_XML_PATH);
        if (fileObject2 == null || !fileObject2.isData() || fileObject2.isVirtual()) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject2);
        if (file == null) {
            return null;
        }
        try {
            document = XMLUtil.parse((InputSource)new InputSource(file.toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)Util.defaultErrorHandler(), null);
        }
        catch (SAXException sAXException) {
            IOException iOException = (IOException)new IOException(file + ": " + sAXException.toString()).initCause(sAXException);
            ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage((Class)AntBasedProjectFactorySingleton.class, (String)"AntBasedProjectFactorySingleton.parseError", (Object)file.getAbsolutePath(), (Object)sAXException.getMessage()));
            throw iOException;
        }
        Element element = document.getDocumentElement();
        if (!"project".equals(element.getLocalName()) || !PROJECT_NS.equals(element.getNamespaceURI())) {
            return null;
        }
        Element element2 = Util.findElement(element, "type", PROJECT_NS);
        if (element2 == null) {
            return null;
        }
        String string = Util.findText(element2);
        if (string == null) {
            return null;
        }
        AntBasedProjectType antBasedProjectType = AntBasedProjectFactorySingleton.findAntBasedProjectType(string);
        if (antBasedProjectType == null) {
            return null;
        }
        AntProjectHelper antProjectHelper = HELPER_CALLBACK.createHelper(fileObject, document, projectState, antBasedProjectType);
        Project project = antBasedProjectType.createProject(antProjectHelper);
        project2Helper.put(project, new WeakReference<AntProjectHelper>(antProjectHelper));
        helper2Project.put(antProjectHelper, new WeakReference<Project>(project));
        ArrayList<WeakReference<AntProjectHelper>> arrayList = (ArrayList<WeakReference<AntProjectHelper>>)type2Projects.get(antBasedProjectType);
        if (arrayList == null) {
            arrayList = new ArrayList<WeakReference<AntProjectHelper>>();
            type2Projects.put(antBasedProjectType, arrayList);
        }
        arrayList.add(new WeakReference<AntProjectHelper>(antProjectHelper));
        return project;
    }

    public void saveProject(Project project) throws IOException, ClassCastException {
        Reference reference = (Reference)project2Helper.get(project);
        if (reference == null) {
            throw new ClassCastException(project.getClass().getName());
        }
        AntProjectHelper antProjectHelper = (AntProjectHelper)reference.get();
        if (!$assertionsDisabled && antProjectHelper == null) {
            throw new AssertionError((Object)("AntProjectHelper collected for " + project));
        }
        HELPER_CALLBACK.save(antProjectHelper);
    }

    public static Project getProjectFor(AntProjectHelper antProjectHelper) {
        Reference reference = (Reference)helper2Project.get(antProjectHelper);
        if (!$assertionsDisabled && reference == null) {
            throw new AssertionError((Object)("Found a Project reference for " + antProjectHelper));
        }
        Project project = (Project)reference.get();
        if (!$assertionsDisabled && project == null) {
            throw new AssertionError((Object)("Found a non-null Project for " + antProjectHelper));
        }
        return project;
    }

    public static AntProjectHelper getHelperFor(Project project) {
        Reference reference = (Reference)project2Helper.get(project);
        return reference != null ? (AntProjectHelper)reference.get() : null;
    }

    static {
        block3: {
            $assertionsDisabled = !AntBasedProjectFactorySingleton.class.desiredAssertionStatus();
            project2Helper = new WeakHashMap();
            helper2Project = new WeakHashMap();
            type2Projects = new HashMap();
            antBasedProjectTypesByType = null;
            antBasedProjectTypes = Lookup.getDefault().lookup(new Lookup.Template(AntBasedProjectType.class));
            antBasedProjectTypes.addLookupListener(new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent lookupEvent) {
                    Class clazz = class$org$netbeans$modules$project$ant$AntBasedProjectFactorySingleton == null ? (class$org$netbeans$modules$project$ant$AntBasedProjectFactorySingleton = AntBasedProjectFactorySingleton.class$("org.netbeans.modules.project.ant.AntBasedProjectFactorySingleton")) : class$org$netbeans$modules$project$ant$AntBasedProjectFactorySingleton;
                    synchronized (clazz) {
                        Set set = type2Projects.keySet();
                        HashSet hashSet = new HashSet(set);
                        hashSet.removeAll(antBasedProjectTypes.allInstances());
                        AntBasedProjectFactorySingleton.antBasedProjectTypesRemoved(hashSet);
                        antBasedProjectTypesByType = null;
                    }
                }
            });
            Class clazz = AntProjectHelper.class;
            try {
                Class.forName(clazz.getName(), true, clazz.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)classNotFoundException);
            }
        }
        if (!$assertionsDisabled && HELPER_CALLBACK == null) {
            throw new AssertionError();
        }
    }

    public static interface AntProjectHelperCallback {
        public AntProjectHelper createHelper(FileObject var1, Document var2, ProjectState var3, AntBasedProjectType var4);

        public void save(AntProjectHelper var1) throws IOException;
    }
}

