/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.CharArrayWriter;
import java.io.StringReader;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class AntProjectModule
extends ModuleInstall {
    public void restored() {
        super.restored();
        if (Boolean.getBoolean("netbeans.do.not.check.xalan")) {
            return;
        }
        long l = System.currentTimeMillis();
        boolean bl = this.checkForXalan();
        long l2 = System.currentTimeMillis();
        if (ErrorManager.getDefault().isLoggable(1)) {
            ErrorManager.getDefault().log(1, "check for buggy xalan took: " + (l2 - l));
        }
        if (bl) {
            this.showWarning();
        }
    }

    private boolean checkForXalan() {
        if (System.getProperty("java.specification.version").startsWith("1.4")) {
            return false;
        }
        try {
            Class<?> clazz = XMLUtil.class.getClassLoader().loadClass("org.apache.xalan.Version");
            return !this.verifyWriterCorrect();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return false;
    }

    private boolean verifyPlainAccess() throws Exception {
        String string = "<root xmlns='root'/>";
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(string)));
        document.getDocumentElement().appendChild(document.createElementNS("child", "child"));
        Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(new StringReader("<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:xalan='http://xml.apache.org/xslt' exclude-result-prefixes='xalan'><xsl:output method='xml' indent='yes' xalan:indent-amount='4'/><xsl:template match='@*|node()'><xsl:copy><xsl:apply-templates select='@*|node()'/></xsl:copy></xsl:template></xsl:stylesheet>")));
        DOMSource dOMSource = new DOMSource(document);
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        StreamResult streamResult = new StreamResult(charArrayWriter);
        transformer.transform(dOMSource, streamResult);
        charArrayWriter.close();
        String string2 = charArrayWriter.toString();
        return string2.indexOf("\"child\"") != -1 || string2.indexOf("'child'") != -1;
    }

    private boolean verifyWriterCorrect() throws Exception {
        return this.verifyPlainAccess();
    }

    private void showWarning() {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)AntProjectModule.class, (String)"LBL_Incompatible_Xalan"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Frame frame = WindowManager.getDefault().getMainWindow();
                if (frame == null || frame.isShowing()) {
                    LifecycleManager.getDefault().exit();
                } else {
                    frame.addWindowListener(new WindowAdapter(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void windowOpened(WindowEvent windowEvent) {
                            LifecycleManager.getDefault().exit();
                        }
                    });
                }
            }
        });
    }
}

