/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.project.ant.FileChangeSupportEvent;
import org.netbeans.modules.project.ant.FileChangeSupportListener;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class FileChangeSupport {
    public static FileChangeSupport DEFAULT;
    private final Map holders = new WeakHashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    private FileChangeSupport() {
    }

    public void addListener(FileChangeSupportListener fileChangeSupportListener, File file) {
        if (!$assertionsDisabled && !file.equals(FileUtil.normalizeFile((File)file))) {
            throw new AssertionError((Object)("Need to normalize " + file + " before passing to FCS!"));
        }
        HashMap<File, Holder> hashMap = (HashMap<File, Holder>)this.holders.get(fileChangeSupportListener);
        if (hashMap == null) {
            hashMap = new HashMap<File, Holder>();
            this.holders.put(fileChangeSupportListener, hashMap);
        }
        if (hashMap.containsKey(file)) {
            throw new IllegalArgumentException("Already listening to " + file);
        }
        hashMap.put(file, new Holder(fileChangeSupportListener, file));
    }

    public void removeListener(FileChangeSupportListener fileChangeSupportListener, File file) {
        if (!$assertionsDisabled && !file.equals(FileUtil.normalizeFile((File)file))) {
            throw new AssertionError((Object)("Need to normalize " + file + " before passing to FCS!"));
        }
        Map map = (Map)this.holders.get(fileChangeSupportListener);
        if (map == null) {
            throw new IllegalArgumentException("Was not listening to " + file);
        }
        if (!map.containsKey(file)) {
            throw new IllegalArgumentException("Was not listening to " + file);
        }
        map.remove(file);
    }

    static {
        $assertionsDisabled = !FileChangeSupport.class.desiredAssertionStatus();
        DEFAULT = new FileChangeSupport();
    }

    private static final class Holder
    extends WeakReference
    implements FileChangeListener,
    Runnable {
        private final File path;
        private FileObject current;
        private File currentF;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Holder(FileChangeSupportListener fileChangeSupportListener, File file) {
            super(fileChangeSupportListener, Utilities.activeReferenceQueue());
            if (!$assertionsDisabled && file == null) {
                throw new AssertionError();
            }
            this.path = file;
            this.locateCurrent();
        }

        private void locateCurrent() {
            FileObject fileObject;
            block4: {
                fileObject = this.current;
                this.currentF = this.path;
                do {
                    this.current = FileUtil.toFileObject((File)this.currentF);
                    if (this.current != null) break block4;
                    this.currentF = this.currentF.getParentFile();
                } while (this.currentF != null);
                return;
            }
            if (!$assertionsDisabled && this.current == null) {
                throw new AssertionError();
            }
            if (this.current != fileObject) {
                if (fileObject != null) {
                    fileObject.removeFileChangeListener((FileChangeListener)this);
                }
                this.current.addFileChangeListener((FileChangeListener)this);
                this.current.getChildren();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void someChange(FileObject fileObject) {
            File file;
            FileObject fileObject2;
            File file2;
            FileChangeSupportListener fileChangeSupportListener;
            Object object = this;
            synchronized (object) {
                if (this.current == null) {
                    return;
                }
                fileChangeSupportListener = (FileChangeSupportListener)this.get();
                if (fileChangeSupportListener == null) {
                    return;
                }
                FileObject fileObject3 = this.current;
                file2 = this.currentF;
                this.locateCurrent();
                fileObject2 = this.current;
                file = this.currentF;
            }
            if (fileObject != null && fileObject == fileObject2) {
                object = new FileChangeSupportEvent(DEFAULT, 2, this.path);
                fileChangeSupportListener.fileModified((FileChangeSupportEvent)object);
            } else {
                boolean bl = this.path.equals(file2);
                boolean bl2 = this.path.equals(file);
                if (bl && !bl2) {
                    FileChangeSupportEvent fileChangeSupportEvent = new FileChangeSupportEvent(DEFAULT, 1, this.path);
                    fileChangeSupportListener.fileDeleted(fileChangeSupportEvent);
                } else if (bl2 && !bl) {
                    FileChangeSupportEvent fileChangeSupportEvent = new FileChangeSupportEvent(DEFAULT, 0, this.path);
                    fileChangeSupportListener.fileCreated(fileChangeSupportEvent);
                }
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            this.someChange(fileEvent.getFile());
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.someChange(null);
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.someChange(null);
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.someChange(null);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.someChange(null);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public synchronized void run() {
            if (this.current != null) {
                this.current.removeFileChangeListener((FileChangeListener)this);
                this.current = null;
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$project$ant$FileChangeSupport == null ? (class$org$netbeans$modules$project$ant$FileChangeSupport = FileChangeSupport.class$("org.netbeans.modules.project.ant.FileChangeSupport")) : class$org$netbeans$modules$project$ant$FileChangeSupport).desiredAssertionStatus();
        }
    }
}

