/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class EditableProperties
extends AbstractMap
implements Cloneable {
    private final LinkedList items;
    private final Map itemIndex;
    private final boolean alphabetize;
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final String commentChars = "#!";
    private static final String INDENT = "    ";
    private static final int WAITING_FOR_KEY_VALUE = 1;
    private static final int READING_KEY_VALUE = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EditableProperties() {
        this(false);
    }

    public EditableProperties(boolean bl) {
        this.alphabetize = bl;
        this.items = new LinkedList();
        this.itemIndex = new HashMap();
    }

    public EditableProperties(Map map) {
        this(false);
        this.putAll(map);
    }

    private EditableProperties(EditableProperties editableProperties) {
        this.alphabetize = editableProperties.alphabetize;
        this.items = new LinkedList();
        this.itemIndex = new HashMap(editableProperties.items.size() * 4 / 3 + 1);
        Iterator iterator = editableProperties.items.iterator();
        while (iterator.hasNext()) {
            Item item = (Item)((Item)iterator.next()).clone();
            this.items.add(item);
            this.itemIndex.put(item.getKey(), item);
        }
    }

    public Set entrySet() {
        return new SetImpl(this);
    }

    public void load(InputStream inputStream) throws IOException {
        String string;
        int n = 1;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1"));
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = 0;
        while (null != (string = bufferedReader.readLine())) {
            linkedList.add(string);
            boolean bl = EditableProperties.isEmpty(string);
            boolean bl2 = EditableProperties.isComment(string);
            if (n == 1) {
                if (bl) {
                    this.createNonKeyItem(linkedList);
                    n2 = 0;
                } else if (bl2) {
                    ++n2;
                } else {
                    n = 2;
                }
            }
            if (n != 2 || this.isContinue(string)) continue;
            this.createKeyItem(linkedList, n2);
            n = 1;
            n2 = 0;
        }
        if (linkedList.size() > 0) {
            if (n == 2) {
                this.createKeyItem(linkedList, n2);
            } else {
                this.createNonKeyItem(linkedList);
            }
        }
    }

    public void store(OutputStream outputStream) throws IOException {
        boolean bl = true;
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "ISO-8859-1"));
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            if (item.isSeparate() && !bl) {
                bufferedWriter.newLine();
            }
            Iterator iterator2 = item.getRawData().iterator();
            String string = null;
            while (iterator2.hasNext()) {
                string = (String)iterator2.next();
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            if (string == null) continue;
            bl = EditableProperties.isEmpty(string);
        }
        bufferedWriter.flush();
    }

    public Object put(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullPointerException();
        }
        Item item = (Item)this.itemIndex.get((String)object);
        String string = null;
        if (item != null) {
            string = item.getValue();
            item.setValue((String)object2);
        } else {
            item = new Item((String)object, (String)object2);
            this.addItem(item, this.alphabetize);
        }
        return string;
    }

    public String getProperty(String string) {
        return (String)this.get(string);
    }

    public String setProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        this.put(string, string2);
        return string3;
    }

    public String setProperty(String string, String[] stringArray) {
        String string2 = this.getProperty(string);
        if (string == null || stringArray == null) {
            throw new NullPointerException();
        }
        List<String> list = Arrays.asList(stringArray);
        Item item = (Item)this.itemIndex.get(string);
        if (item != null) {
            item.setValue(list);
        } else {
            this.addItem(new Item(string, list), this.alphabetize);
        }
        return string2;
    }

    public String[] getComment(String string) {
        Item item = (Item)this.itemIndex.get(string);
        if (item == null) {
            return new String[0];
        }
        return item.getComment();
    }

    public void setComment(String string, String[] stringArray, boolean bl) {
        Item item = (Item)this.itemIndex.get(string);
        if (item == null) {
            throw new IllegalArgumentException("Cannot set comment for non-existing property " + string);
        }
        item.setComment(stringArray, bl);
    }

    public Object clone() {
        return this.cloneProperties();
    }

    public EditableProperties cloneProperties() {
        return new EditableProperties(this);
    }

    private void createNonKeyItem(List list) {
        Item item;
        if (!this.items.isEmpty() && (item = (Item)this.items.getLast()).getKey() == null) {
            item.addCommentLines(list);
            list.clear();
            return;
        }
        item = new Item(list);
        this.addItem(item, false);
        list.clear();
    }

    private void createKeyItem(List list, int n) {
        Item item = new Item(list.subList(0, n), list.subList(n, list.size()));
        this.addItem(item, false);
        list.clear();
    }

    private void addItem(Item item, boolean bl) {
        String string = item.getKey();
        if (bl) {
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError();
            }
            ListIterator<Item> listIterator = this.items.listIterator();
            while (listIterator.hasNext()) {
                String string2 = ((Item)listIterator.next()).getKey();
                if (string2 == null || string2.compareToIgnoreCase(string) <= 0) continue;
                listIterator.previous();
                listIterator.add(item);
                this.itemIndex.put(string, item);
                return;
            }
        }
        this.items.add(item);
        if (string != null) {
            this.itemIndex.put(string, item);
        }
    }

    private void removeItem(Item item) {
        this.items.remove(item);
        if (item.getKey() != null) {
            this.itemIndex.remove(item.getKey());
        }
    }

    private boolean isContinue(String string) {
        int n = 0;
        for (int i = string.length() - 1; i >= 0 && string.charAt(i) == '\\'; --i) {
            ++n;
        }
        return n % 2 != 0;
    }

    private static boolean isComment(String string) {
        return (string = EditableProperties.trimLeft(string)).length() != 0 && commentChars.indexOf(string.charAt(0)) != -1;
    }

    private static boolean isEmpty(String string) {
        return EditableProperties.trimLeft(string).length() == 0;
    }

    private static String trimLeft(String string) {
        int n;
        for (n = 0; n < string.length() && whiteSpaceChars.indexOf(string.charAt(n)) != -1; ++n) {
        }
        return string.substring(n);
    }

    static {
        $assertionsDisabled = !EditableProperties.class.desiredAssertionStatus();
    }

    private static class MapEntryImpl
    implements Map.Entry {
        private Item item;

        public MapEntryImpl(Item item) {
            this.item = item;
        }

        public Object getKey() {
            return this.item.getKey();
        }

        public Object getValue() {
            return this.item.getValue();
        }

        public Object setValue(Object object) {
            String string = this.item.getValue();
            this.item.setValue((String)object);
            return string;
        }
    }

    private static class IteratorImpl
    implements Iterator {
        private final EditableProperties props;
        private ListIterator delegate;

        public IteratorImpl(EditableProperties editableProperties) {
            this.props = editableProperties;
            this.delegate = editableProperties.items.listIterator();
        }

        public boolean hasNext() {
            return this.findNext() != null;
        }

        public Object next() {
            Item item = this.findNext();
            if (item == null) {
                throw new NoSuchElementException();
            }
            this.delegate.next();
            return new MapEntryImpl(item);
        }

        public void remove() {
            this.delegate.previous();
            Item item = this.findNext();
            if (item == null) {
                throw new IllegalStateException();
            }
            int n = this.delegate.nextIndex();
            this.props.items.remove(item);
            this.props.itemIndex.remove(item.getKey());
            this.delegate = this.props.items.listIterator(n);
        }

        private Item findNext() {
            while (this.delegate.hasNext()) {
                Item item = (Item)this.delegate.next();
                if (item.getKey() == null || item.getValue() == null) continue;
                this.delegate.previous();
                return item;
            }
            return null;
        }
    }

    private static class SetImpl
    extends AbstractSet {
        private EditableProperties props;

        public SetImpl(EditableProperties editableProperties) {
            this.props = editableProperties;
        }

        public Iterator iterator() {
            return new IteratorImpl(this.props);
        }

        public int size() {
            return this.props.items.size();
        }
    }

    private static class Item
    implements Cloneable {
        private List commentLines;
        private List keyValueLines;
        private String key;
        private String value;
        private boolean separate;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Item() {
        }

        public Item(List list) {
            this.commentLines = new ArrayList(list);
        }

        public Item(List list, List list2) {
            this.commentLines = new ArrayList(list);
            this.keyValueLines = new ArrayList(list2);
            this.parse(list2);
        }

        public Item(String string, String string2) {
            this.key = string;
            this.value = string2;
        }

        public Item(String string, List list) {
            this.key = string;
            this.setValue(list);
        }

        void addCommentLines(List list) {
            if (!$assertionsDisabled && this.key != null) {
                throw new AssertionError();
            }
            this.commentLines.addAll(list);
        }

        public String[] getComment() {
            String[] stringArray = new String[this.commentLines.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Item.decodeUnicode((String)this.commentLines.get(i));
            }
            return stringArray;
        }

        public void setComment(String[] stringArray, boolean bl) {
            this.separate = bl;
            this.commentLines = new ArrayList(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                this.commentLines.add(Item.encodeUnicode(stringArray[i]));
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
            this.keyValueLines = null;
        }

        public void setValue(List list) {
            StringBuffer stringBuffer = new StringBuffer();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!list.isEmpty()) {
                arrayList.add(Item.encode(this.key, true) + "=\\");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    stringBuffer.append(string);
                    string = Item.encode(string, false);
                    arrayList.add(iterator.hasNext() ? EditableProperties.INDENT + string + '\\' : EditableProperties.INDENT + string);
                }
            } else {
                arrayList.add(Item.encode(this.key, true) + '=');
            }
            this.value = stringBuffer.toString();
            this.keyValueLines = arrayList;
        }

        public boolean isSeparate() {
            return this.separate;
        }

        public List getRawData() {
            ArrayList arrayList = new ArrayList();
            if (this.commentLines != null) {
                arrayList.addAll(this.commentLines);
            }
            if (this.keyValueLines != null) {
                arrayList.addAll(this.keyValueLines);
            } else {
                this.keyValueLines = new ArrayList();
                if (this.key != null && this.value != null) {
                    this.keyValueLines.add(Item.encode(this.key, true) + "=" + Item.encode(this.value, false));
                }
                arrayList.addAll(this.keyValueLines);
            }
            return arrayList;
        }

        private void parse(List list) {
            String string = this.mergeLines(list);
            this.splitKeyValue(string);
        }

        private String mergeLines(List list) {
            String string = "";
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = EditableProperties.trimLeft((String)iterator.next());
                if (iterator.hasNext()) {
                    if (!$assertionsDisabled && !string2.endsWith("\\")) {
                        throw new AssertionError(list);
                    }
                    string2 = string2.substring(0, string2.length() - 1);
                }
                string = string + string2;
            }
            return string;
        }

        private void splitKeyValue(String string) {
            int n;
            for (n = 0; n < string.length(); ++n) {
                char c = string.charAt(n);
                if (c == '\\') {
                    ++n;
                    continue;
                }
                if (EditableProperties.keyValueSeparators.indexOf(c) != -1) break;
            }
            this.key = Item.decode(string.substring(0, n));
            if ((string = EditableProperties.trimLeft(string.substring(n))).length() == 0) {
                this.value = "";
                return;
            }
            if (EditableProperties.strictKeyValueSeparators.indexOf(string.charAt(0)) != -1) {
                string = EditableProperties.trimLeft(string.substring(1));
            }
            this.value = Item.decode(string);
        }

        private static String decode(String string) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                int n2 = string.charAt(i);
                if (n2 != 92) {
                    stringBuffer.append((char)n2);
                    continue;
                }
                if (++i == n) continue;
                n2 = string.charAt(i);
                if (n2 == 117) {
                    if (i + 5 > n) {
                        stringBuffer.append(string.substring(i - 1));
                        i += 4;
                        continue;
                    }
                    String string2 = string.substring(i + 1, i + 5);
                    try {
                        stringBuffer.append((char)Integer.parseInt(string2, 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringBuffer.append(string.substring(i - 1, i + 5));
                    }
                    i += 4;
                    continue;
                }
                if (n2 == 116) {
                    n2 = 9;
                } else if (n2 == 114) {
                    n2 = 13;
                } else if (n2 == 110) {
                    n2 = 10;
                } else if (n2 == 102) {
                    n2 = 12;
                }
                stringBuffer.append((char)n2);
            }
            return stringBuffer.toString();
        }

        private static String encode(String string, boolean bl) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n * 2);
            block8: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case ' ': {
                        if (i == 0 || bl) {
                            stringBuffer.append('\\');
                        }
                        stringBuffer.append(' ');
                        continue block8;
                    }
                    case '\\': {
                        stringBuffer.append("\\\\");
                        continue block8;
                    }
                    case '\t': {
                        stringBuffer.append("\\t");
                        continue block8;
                    }
                    case '\n': {
                        stringBuffer.append("\\n");
                        continue block8;
                    }
                    case '\r': {
                        stringBuffer.append("\\r");
                        continue block8;
                    }
                    case '\f': {
                        stringBuffer.append("\\f");
                        continue block8;
                    }
                    default: {
                        if (c < ' ' || c > '~') {
                            stringBuffer.append("\\u");
                            String string2 = Integer.toHexString(c);
                            for (int j = 0; j < 4 - string2.length(); ++j) {
                                stringBuffer.append('0');
                            }
                            stringBuffer.append(string2);
                            continue block8;
                        }
                        stringBuffer.append(c);
                    }
                }
            }
            return stringBuffer.toString();
        }

        private static String decodeUnicode(String string) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c != '\\') {
                    stringBuffer.append(c);
                    continue;
                }
                if (++i == n) continue;
                c = string.charAt(i);
                if (c == 'u') {
                    if (i + 5 > n) {
                        stringBuffer.append(string.substring(i - 1));
                        i += 4;
                        continue;
                    }
                    String string2 = string.substring(i + 1, i + 5);
                    try {
                        stringBuffer.append((char)Integer.parseInt(string2, 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringBuffer.append(string.substring(i - 1, i + 5));
                    }
                    i += 4;
                    continue;
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }

        private static String encodeUnicode(String string) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n * 2);
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c < ' ' || c > '~') {
                    stringBuffer.append("\\u");
                    String string2 = Integer.toHexString(c);
                    for (int j = 0; j < 4 - string2.length(); ++j) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(string2);
                    continue;
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }

        public Object clone() {
            Item item = new Item();
            if (this.keyValueLines != null) {
                item.keyValueLines = new ArrayList(this.keyValueLines);
            }
            if (this.commentLines != null) {
                item.commentLines = new ArrayList(this.commentLines);
            }
            item.key = this.key;
            item.value = this.value;
            item.separate = this.separate;
            return item;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$EditableProperties == null ? (class$org$netbeans$spi$project$support$ant$EditableProperties = EditableProperties.class$("org.netbeans.spi.project.support.ant.EditableProperties")) : class$org$netbeans$spi$project$support$ant$EditableProperties).desiredAssertionStatus();
        }
    }
}

