/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.modules.project.ant.FileChangeSupport;
import org.netbeans.modules.project.ant.FileChangeSupportEvent;
import org.netbeans.modules.project.ant.FileChangeSupportListener;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

final class GlobFileBuiltQuery
implements FileBuiltQueryImplementation {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.spi.project.support.ant.GlobFileBuiltQuery");
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final String[] fromPrefixes;
    private final String[] fromSuffixes;
    private final String[] toPrefixes;
    private final String[] toSuffixes;
    private static final Object NONE = "NONE";
    private final Map statuses = new WeakHashMap();
    static /* synthetic */ Class class$org$netbeans$spi$project$support$ant$GlobFileBuiltQuery;

    public GlobFileBuiltQuery(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, String[] stringArray, String[] stringArray2) throws IllegalArgumentException {
        this.helper = antProjectHelper;
        this.eval = propertyEvaluator;
        int n = stringArray.length;
        if (stringArray2.length != n) {
            throw new IllegalArgumentException("Non-matching lengths");
        }
        this.fromPrefixes = new String[n];
        this.fromSuffixes = new String[n];
        this.toPrefixes = new String[n];
        this.toSuffixes = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2 = stringArray[i].indexOf(42);
            if (n2 == -1 || n2 != stringArray[i].lastIndexOf(42)) {
                throw new IllegalArgumentException("Zero or multiple asterisks in " + stringArray[i]);
            }
            this.fromPrefixes[i] = stringArray[i].substring(0, n2);
            this.fromSuffixes[i] = stringArray[i].substring(n2 + 1);
            n2 = stringArray2[i].indexOf(42);
            if (n2 == -1 || n2 != stringArray2[i].lastIndexOf(42)) {
                throw new IllegalArgumentException("Zero or multiple asterisks in " + stringArray2[i]);
            }
            this.toPrefixes[i] = stringArray2[i].substring(0, n2);
            this.toSuffixes[i] = stringArray2[i].substring(n2 + 1);
        }
    }

    public synchronized FileBuiltQuery.Status getStatus(FileObject fileObject) {
        StatusImpl statusImpl;
        Object v = this.statuses.get(fileObject);
        if (v == NONE) {
            return null;
        }
        Reference reference = (Reference)v;
        StatusImpl statusImpl2 = statusImpl = reference != null ? (StatusImpl)reference.get() : null;
        if (statusImpl == null) {
            statusImpl = this.createStatus(fileObject);
            if (statusImpl != null) {
                this.statuses.put(fileObject, new WeakReference<StatusImpl>(statusImpl));
            } else {
                this.statuses.put(fileObject, NONE);
            }
        }
        return statusImpl;
    }

    private File findTarget(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            if (err.isLoggable(1)) {
                err.log("Not a disk file: " + fileObject);
            }
            return null;
        }
        String string = file.getAbsolutePath();
        for (int i = 0; i < this.fromPrefixes.length; ++i) {
            String string2;
            String string3 = this.eval.evaluate(this.fromPrefixes[i]);
            if (string3 == null) {
                if (!err.isLoggable(1)) continue;
                err.log(this.fromPrefixes[i] + " evaluates to null");
                continue;
            }
            String string4 = this.eval.evaluate(this.fromSuffixes[i]);
            if (string4 == null) {
                if (!err.isLoggable(1)) continue;
                err.log(this.fromSuffixes[i] + " evaluates to null");
                continue;
            }
            boolean bl = string3.endsWith("/");
            String string5 = this.helper.resolveFile(string3).getAbsolutePath();
            if (bl && !string5.endsWith(File.separator)) {
                string5 = string5 + File.separatorChar;
            }
            if (!string.startsWith(string5) || !(string2 = string.substring(string5.length())).endsWith(string4.replace('/', File.separatorChar))) continue;
            String string6 = string2.substring(0, string2.length() - string4.length());
            String string7 = this.eval.evaluate(this.toPrefixes[i]);
            if (string7 == null) {
                if (!err.isLoggable(1)) continue;
                err.log(this.toPrefixes[i] + " evaluates to null");
                continue;
            }
            String string8 = this.eval.evaluate(this.toSuffixes[i]);
            if (string8 == null) {
                if (!err.isLoggable(1)) continue;
                err.log(this.toSuffixes[i] + " evaluates to null");
                continue;
            }
            File file2 = this.helper.resolveFile(string7 + string6 + string8);
            if (err.isLoggable(1)) {
                err.log("Found target for " + string + ": " + file2);
            }
            return file2;
        }
        if (err.isLoggable(1)) {
            err.log("No match for path " + string + " among " + Arrays.asList(this.fromPrefixes) + " " + Arrays.asList(this.fromSuffixes));
        }
        return null;
    }

    private StatusImpl createStatus(FileObject fileObject) {
        File file = this.findTarget(fileObject);
        if (file != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                return new StatusImpl(dataObject, fileObject, file);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
                return null;
            }
        }
        return null;
    }

    private final class StatusImpl
    implements FileBuiltQuery.Status,
    PropertyChangeListener,
    FileChangeListener,
    FileChangeSupportListener,
    Runnable {
        private final List listeners = new ArrayList();
        private Boolean built = null;
        private final DataObject source;
        private File target;
        static final /* synthetic */ boolean $assertionsDisabled;

        StatusImpl(DataObject dataObject, FileObject fileObject, File file) {
            this.source = dataObject;
            this.source.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.source));
            fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileObject));
            this.target = file;
            FileChangeSupport.DEFAULT.addListener(this, file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isBuilt() {
            boolean bl;
            boolean bl2 = false;
            GlobFileBuiltQuery globFileBuiltQuery = GlobFileBuiltQuery.this;
            synchronized (globFileBuiltQuery) {
                bl = this.isReallyBuilt();
                if (this.built != null && this.built != bl) {
                    bl2 = true;
                }
                this.built = bl;
                if (err.isLoggable(1)) {
                    err.log("isBuilt: " + bl + " from " + this);
                }
            }
            if (bl2) {
                this.fireChange();
            }
            return bl;
        }

        private boolean isReallyBuilt() {
            long l;
            if (!this.source.isValid()) {
                if (err.isLoggable(1)) {
                    err.log("invalid: " + this);
                }
                return false;
            }
            if (this.source.isModified()) {
                if (err.isLoggable(1)) {
                    err.log("modified: " + this);
                }
                return false;
            }
            if (this.target == null) {
                if (err.isLoggable(1)) {
                    err.log("no target matching " + this);
                }
                return false;
            }
            long l2 = this.target.lastModified();
            if (l2 >= (l = this.source.getPrimaryFile().lastModified().getTime())) {
                return true;
            }
            if (err.isLoggable(1)) {
                err.log("out of date (target: " + l2 + " vs. source: " + l + "): " + this);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ChangeListener[] changeListenerArray;
            Object object = this.listeners;
            synchronized (object) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            object = new ChangeEvent(this);
            for (int i = 0; i < changeListenerArray.length; ++i) {
                changeListenerArray[i].stateChanged((ChangeEvent)object);
            }
        }

        private void update() {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        public void run() {
            this.isBuilt();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!$assertionsDisabled && !(propertyChangeEvent.getSource() instanceof DataObject)) {
                throw new AssertionError();
            }
            if ("modified".equals(propertyChangeEvent.getPropertyName())) {
                this.update();
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            this.update();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.update();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            File file = GlobFileBuiltQuery.this.findTarget(this.source.getPrimaryFile());
            if (!Utilities.compareObjects((Object)this.target, (Object)file)) {
                if (this.target != null) {
                    FileChangeSupport.DEFAULT.removeListener(this, this.target);
                }
                if (file != null) {
                    FileChangeSupport.DEFAULT.addListener(this, file);
                }
                this.target = file;
            }
            this.update();
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileCreated(FileChangeSupportEvent fileChangeSupportEvent) {
            this.update();
        }

        public void fileDeleted(FileChangeSupportEvent fileChangeSupportEvent) {
            this.update();
        }

        public void fileModified(FileChangeSupportEvent fileChangeSupportEvent) {
            this.update();
        }

        public String toString() {
            return "GFBQ.StatusImpl[" + this.source.getPrimaryFile() + " -> " + this.target + "]";
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$GlobFileBuiltQuery == null ? (class$org$netbeans$spi$project$support$ant$GlobFileBuiltQuery = GlobFileBuiltQuery.class$("org.netbeans.spi.project.support.ant.GlobFileBuiltQuery")) : class$org$netbeans$spi$project$support$ant$GlobFileBuiltQuery).desiredAssertionStatus();
        }
    }
}

