/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ant.FileChangeSupport;
import org.netbeans.modules.project.ant.FileChangeSupportEvent;
import org.netbeans.modules.project.ant.FileChangeSupportListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class PropertyUtils {
    private static Map globalPropertyProviders;
    private static final Pattern RELATIVE_SLASH_SEPARATED_PATH;
    private static final Pattern VALID_PROPERTY_NAME;
    static final /* synthetic */ boolean $assertionsDisabled;

    private PropertyUtils() {
    }

    static File userBuildProperties() {
        String string = System.getProperty("netbeans.user");
        if (string != null) {
            return FileUtil.normalizeFile((File)new File(string, "build.properties"));
        }
        return null;
    }

    public static EditableProperties getGlobalProperties() {
        return (EditableProperties)ProjectManager.mutex().readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                File file = PropertyUtils.userBuildProperties();
                if (file != null && file.isFile() && file.canRead()) {
                    EditableProperties editableProperties;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        EditableProperties editableProperties2 = new EditableProperties(true);
                        editableProperties2.load(fileInputStream);
                        editableProperties = editableProperties2;
                    }
                    catch (Throwable throwable) {
                        try {
                            ((InputStream)fileInputStream).close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                    }
                    ((InputStream)fileInputStream).close();
                    return editableProperties;
                }
                return new EditableProperties(true);
            }
        });
    }

    public static void putGlobalProperties(final EditableProperties editableProperties) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){
                static final /* synthetic */ boolean $assertionsDisabled;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    block15: {
                        File file = PropertyUtils.userBuildProperties();
                        if (file != null) {
                            FileObject fileObject = FileUtil.toFileObject((File)file);
                            if (fileObject == null) {
                                if (!file.exists()) {
                                    file.getParentFile().mkdirs();
                                    new FileOutputStream(file).close();
                                    if (!$assertionsDisabled && !file.isFile()) {
                                        throw new AssertionError((Object)("Did not actually make " + file));
                                    }
                                }
                                if ((fileObject = FileUtil.toFileObject((File)file)) == null) {
                                    ErrorManager.getDefault().log(16, "Warning - cannot properly write to " + file + "; might be because your user directory is on a Windows UNC path (issue #46813)? If so, try using mapped drive letters.");
                                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                                    try {
                                        editableProperties.store(fileOutputStream);
                                    }
                                    finally {
                                        ((OutputStream)fileOutputStream).close();
                                    }
                                    return null;
                                }
                            }
                            FileLock fileLock = fileObject.lock();
                            try {
                                OutputStream outputStream = fileObject.getOutputStream(fileLock);
                                try {
                                    editableProperties.store(outputStream);
                                    break block15;
                                }
                                finally {
                                    outputStream.close();
                                }
                            }
                            finally {
                                fileLock.releaseLock();
                            }
                        }
                        throw new IOException("Do not know where to store build.properties; must set netbeans.user!");
                    }
                    return null;
                }

                static {
                    $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$PropertyUtils == null ? (class$org$netbeans$spi$project$support$ant$PropertyUtils = PropertyUtils.class$("org.netbeans.spi.project.support.ant.PropertyUtils")) : class$org$netbeans$spi$project$support$ant$PropertyUtils).desiredAssertionStatus();
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static synchronized PropertyProvider globalPropertyProvider() {
        File file = PropertyUtils.userBuildProperties();
        if (file != null) {
            PropertyProvider propertyProvider;
            Reference reference = (Reference)globalPropertyProviders.get(file);
            if (reference != null && (propertyProvider = (PropertyProvider)reference.get()) != null) {
                return propertyProvider;
            }
            propertyProvider = PropertyUtils.propertiesFilePropertyProvider(file);
            globalPropertyProviders.put(file, new SoftReference<PropertyProvider>(propertyProvider));
            return propertyProvider;
        }
        return PropertyUtils.fixedPropertyProvider(Collections.EMPTY_MAP);
    }

    public static PropertyProvider propertiesFilePropertyProvider(File file) {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        return new FilePropertyProvider(file);
    }

    private static Map evaluateAll(Map map, List list) {
        HashMap<Object, String> hashMap = new HashMap<Object, String>(map);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            String string;
            Object object2;
            Map.Entry entry;
            Map map2 = (Map)iterator.next();
            HashMap<Object, Set> hashMap2 = new HashMap<Object, Set>();
            Iterator iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                entry = iterator2.next();
                object2 = (String)entry.getKey();
                if (hashMap.containsKey(object2)) continue;
                string = (String)entry.getValue();
                object = PropertyUtils.subst(string, hashMap, map2.keySet());
                if (object instanceof String) {
                    hashMap.put(object2, (String)object);
                    continue;
                }
                hashMap2.put(object2, (Set)object);
            }
            entry = new HashSet(hashMap2.keySet());
            iterator2 = hashMap2.values().iterator();
            while (iterator2.hasNext()) {
                entry.addAll((Set)((Object)iterator2.next()));
            }
            try {
                object2 = Utilities.topologicalSort((Collection)((Object)entry), hashMap2);
            }
            catch (TopologicalSortException topologicalSortException) {
                return null;
            }
            Collections.reverse(object2);
            iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                string = (String)((Object)iterator2.next());
                if (hashMap.containsKey(string)) continue;
                object = (String)map2.get(string);
                hashMap.put(string, (String)PropertyUtils.subst((String)object, hashMap, map2.keySet()));
            }
        }
        return hashMap;
    }

    private static Object subst(String string, Map map, Set set) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError((Object)"null rawval passed in");
        }
        if (string.indexOf(36) == -1) {
            return string;
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        HashSet<String> hashSet = new HashSet<String>();
        while (true) {
            int n2;
            if ((n2 = string.indexOf(36, n)) == -1 || n2 == string.length() - 1) {
                if (hashSet.isEmpty()) {
                    stringBuffer.append(string.substring(n));
                    return stringBuffer.toString();
                }
                return hashSet;
            }
            char c = string.charAt(n2 + 1);
            if (c == '$') {
                if (hashSet.isEmpty()) {
                    stringBuffer.append('$');
                }
                n += 2;
                continue;
            }
            if (c == '{') {
                int n3 = string.indexOf(125, n2 + 2);
                if (n3 != -1) {
                    String string2 = string.substring(n2 + 2, n3);
                    if (map.containsKey(string2)) {
                        if (hashSet.isEmpty()) {
                            stringBuffer.append(string.substring(n, n2));
                            stringBuffer.append((String)map.get(string2));
                        }
                        n = n3 + 1;
                        continue;
                    }
                    if (set.contains(string2)) {
                        hashSet.add(string2);
                        n = n3 + 1;
                        continue;
                    }
                    if (hashSet.isEmpty()) {
                        stringBuffer.append(string.substring(n, n3 + 1));
                    }
                    n = n3 + 1;
                    continue;
                }
                if (hashSet.isEmpty()) {
                    stringBuffer.append(string.substring(n));
                    return stringBuffer.toString();
                }
                return hashSet;
            }
            if (hashSet.isEmpty()) {
                stringBuffer.append(string.substring(n, n + 2));
            }
            n += 2;
        }
    }

    public static File resolveFile(File file, String string) throws IllegalArgumentException {
        File file2;
        if (file == null) {
            throw new NullPointerException("null basedir passed to resolveFile");
        }
        if (string == null) {
            throw new NullPointerException("null filename passed to resolveFile");
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("nonabsolute basedir passed to resolveFile: " + file);
        }
        if (RELATIVE_SLASH_SEPARATED_PATH.matcher(string).matches()) {
            file2 = new File(file, string.replace('/', File.separatorChar));
        } else {
            String string2 = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            file2 = new File(string2);
            if (!file2.isAbsolute()) {
                file2 = new File(file, string2);
            }
            if (!$assertionsDisabled && !file2.isAbsolute()) {
                throw new AssertionError();
            }
        }
        return FileUtil.normalizeFile((File)file2);
    }

    public static String relativizeFile(File file, File file2) {
        if (file.isFile()) {
            throw new IllegalArgumentException("Cannot relative w.r.t. a data file " + file);
        }
        if (file.equals(file2)) {
            return ".";
        }
        StringBuffer stringBuffer = new StringBuffer();
        File file3 = file;
        String string = file2.getAbsolutePath();
        while (!string.startsWith(PropertyUtils.slashify(file3.getAbsolutePath()))) {
            if ((file3 = file3.getParentFile()) == null) {
                return null;
            }
            if (file3.equals(file2)) {
                stringBuffer.append("..");
                return stringBuffer.toString();
            }
            stringBuffer.append("../");
        }
        URI uRI = file3.toURI().relativize(file2.toURI());
        if (!$assertionsDisabled && uRI.isAbsolute()) {
            throw new AssertionError((Object)(uRI + " from " + file + " and " + file2 + " with common root " + file3));
        }
        stringBuffer.append(uRI.getPath());
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '/') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private static String slashify(String string) {
        if (string.endsWith(File.separator)) {
            return string;
        }
        return string + File.separatorChar;
    }

    static FileObject resolveFileObject(FileObject fileObject, String string) {
        if (RELATIVE_SLASH_SEPARATED_PATH.matcher(string).matches()) {
            return fileObject.getFileObject(string);
        }
        return FileUtil.toFileObject((File)PropertyUtils.resolveFile(FileUtil.toFile((FileObject)fileObject), string));
    }

    static String resolvePath(File file, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = PropertyUtils.tokenizePath(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(PropertyUtils.resolveFile(file, stringArray[i]).getAbsolutePath());
        }
        return stringBuffer.toString();
    }

    public static String[] tokenizePath(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":;", true);
        char c = '\u0000';
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            char c2;
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 0) continue;
            if (string2.length() == 1 && ((c2 = string2.charAt(0)) == ':' || c2 == ';')) {
                n = c2;
                ++n2;
                continue;
            }
            if (c != '\u0000') {
                if (n == 58 && n2 == 1 && (string2.charAt(0) == '\\' || string2.charAt(0) == '/')) {
                    string2 = "" + c + ':' + string2;
                } else {
                    arrayList.add(Character.toString(c));
                }
                c = '\u0000';
            }
            n2 = 0;
            if (string2.length() == 1 && ((c2 = string2.charAt(0)) >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                c = c2;
                continue;
            }
            arrayList.add(string2);
        }
        if (c != '\u0000') {
            arrayList.add(Character.toString(c));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isUsablePropertyName(String string) {
        return VALID_PROPERTY_NAME.matcher(string).matches();
    }

    public static String getUsablePropertyName(String string) {
        if (PropertyUtils.isUsablePropertyName(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (PropertyUtils.isUsablePropertyName(stringBuffer.substring(i, i + 1))) continue;
            stringBuffer.replace(i, i + 1, "_");
        }
        return stringBuffer.toString();
    }

    public static PropertyProvider fixedPropertyProvider(Map map) {
        return new FixedPropertyProvider(map);
    }

    public static PropertyEvaluator sequentialPropertyEvaluator(PropertyProvider propertyProvider, PropertyProvider[] propertyProviderArray) {
        return new SequentialPropertyEvaluator(propertyProvider, propertyProviderArray);
    }

    static /* synthetic */ Object access$200(String string, Map map, Set set) {
        return PropertyUtils.subst(string, map, set);
    }

    static {
        $assertionsDisabled = !PropertyUtils.class.desiredAssertionStatus();
        globalPropertyProviders = new HashMap();
        RELATIVE_SLASH_SEPARATED_PATH = Pattern.compile("[^:/\\\\.][^:/\\\\]*(/[^:/\\\\.][^:/\\\\]*)*");
        VALID_PROPERTY_NAME = Pattern.compile("[-._a-zA-Z0-9]");
    }

    static abstract class DelegatingPropertyProvider
    implements PropertyProvider,
    ChangeListener {
        private PropertyProvider delegate;
        private final List listeners = new ArrayList();
        private ChangeListener weakListener = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected DelegatingPropertyProvider(PropertyProvider propertyProvider) {
            if (!$assertionsDisabled && propertyProvider == null) {
                throw new AssertionError();
            }
            this.setDelegate(propertyProvider);
        }

        protected final void setDelegate(PropertyProvider propertyProvider) {
            if (propertyProvider == this.delegate) {
                return;
            }
            if (this.delegate != null) {
                if (!$assertionsDisabled && this.weakListener == null) {
                    throw new AssertionError();
                }
                this.delegate.removeChangeListener(this.weakListener);
            }
            this.delegate = propertyProvider;
            this.weakListener = WeakListeners.change((ChangeListener)this, (Object)propertyProvider);
            propertyProvider.addChangeListener(this.weakListener);
            this.fireChange();
        }

        public final Map getProperties() {
            return this.delegate.getProperties();
        }

        public final synchronized void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public final synchronized void removeChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ChangeListener[] changeListenerArray;
            Object object = this;
            synchronized (object) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            object = new ChangeEvent(this);
            for (int i = 0; i < changeListenerArray.length; ++i) {
                changeListenerArray[i].stateChanged((ChangeEvent)object);
            }
        }

        public final void stateChanged(ChangeEvent changeEvent) {
            this.fireChange();
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$PropertyUtils == null ? (class$org$netbeans$spi$project$support$ant$PropertyUtils = PropertyUtils.class$("org.netbeans.spi.project.support.ant.PropertyUtils")) : class$org$netbeans$spi$project$support$ant$PropertyUtils).desiredAssertionStatus();
        }
    }

    private static final class SequentialPropertyEvaluator
    implements PropertyEvaluator,
    ChangeListener {
        private final PropertyProvider preprovider;
        private final PropertyProvider[] providers;
        private Map defs;
        private final List listeners = new ArrayList();
        static final /* synthetic */ boolean $assertionsDisabled;

        public SequentialPropertyEvaluator(PropertyProvider propertyProvider, PropertyProvider[] propertyProviderArray) {
            this.preprovider = propertyProvider;
            this.providers = propertyProviderArray;
            this.defs = (Map)ProjectManager.mutex().readAccess(new Mutex.Action(this, propertyProvider, propertyProviderArray){
                private final /* synthetic */ PropertyProvider val$preprovider;
                private final /* synthetic */ PropertyProvider[] val$providers;
                private final /* synthetic */ SequentialPropertyEvaluator this$0;
                {
                    this.this$0 = sequentialPropertyEvaluator;
                    this.val$preprovider = propertyProvider;
                    this.val$providers = propertyProviderArray;
                }

                public Object run() {
                    return SequentialPropertyEvaluator.access$000(this.val$preprovider, this.val$providers);
                }
            });
            if (propertyProvider != null) {
                propertyProvider.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)propertyProvider));
            }
            for (int i = 0; i < propertyProviderArray.length; ++i) {
                propertyProviderArray[i].addChangeListener(WeakListeners.change((ChangeListener)this, (Object)propertyProviderArray[i]));
            }
        }

        public String getProperty(String string) {
            return (String)ProjectManager.mutex().readAccess(new Mutex.Action(this, string){
                private final /* synthetic */ String val$prop;
                private final /* synthetic */ SequentialPropertyEvaluator this$0;
                {
                    this.this$0 = sequentialPropertyEvaluator;
                    this.val$prop = string;
                }

                public Object run() {
                    if (SequentialPropertyEvaluator.access$100(this.this$0) == null) {
                        return null;
                    }
                    return (String)SequentialPropertyEvaluator.access$100(this.this$0).get(this.val$prop);
                }
            });
        }

        public String evaluate(String string) {
            return (String)ProjectManager.mutex().readAccess(new Mutex.Action(this, string){
                static final /* synthetic */ boolean $assertionsDisabled;
                private final /* synthetic */ String val$text;
                private final /* synthetic */ SequentialPropertyEvaluator this$0;
                {
                    this.this$0 = sequentialPropertyEvaluator;
                    this.val$text = string;
                }

                public Object run() {
                    if (this.val$text == null) {
                        throw new NullPointerException("Attempted to pass null to PropertyEvaluator.evaluate");
                    }
                    if (SequentialPropertyEvaluator.access$100(this.this$0) == null) {
                        return null;
                    }
                    Object object = PropertyUtils.access$200(this.val$text, SequentialPropertyEvaluator.access$100(this.this$0), Collections.EMPTY_SET);
                    if (!$assertionsDisabled && !(object instanceof String)) {
                        throw new AssertionError((Object)("Unexpected result " + object + " from " + this.val$text + " on " + SequentialPropertyEvaluator.access$100(this.this$0)));
                    }
                    return (String)object;
                }

                static {
                    $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$PropertyUtils == null ? (class$org$netbeans$spi$project$support$ant$PropertyUtils = PropertyUtils.class$("org.netbeans.spi.project.support.ant.PropertyUtils")) : class$org$netbeans$spi$project$support$ant$PropertyUtils).desiredAssertionStatus();
                }
            });
        }

        public Map getProperties() {
            return (Map)ProjectManager.mutex().readAccess(new Mutex.Action(this){
                private final /* synthetic */ SequentialPropertyEvaluator this$0;
                {
                    this.this$0 = sequentialPropertyEvaluator;
                }

                public Object run() {
                    return SequentialPropertyEvaluator.access$100(this.this$0);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.add(propertyChangeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(propertyChangeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent changeEvent) {
            Map map;
            if (!($assertionsDisabled || ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess())) {
                throw new AssertionError();
            }
            Map map2 = SequentialPropertyEvaluator.compose(this.preprovider, this.providers);
            Map map3 = this.defs != null ? this.defs : Collections.EMPTY_MAP;
            Map map4 = map = map2 != null ? map2 : Collections.EMPTY_MAP;
            if (!((Object)map3).equals(map)) {
                Object object;
                Object object2;
                PropertyChangeListener[] propertyChangeListenerArray;
                HashSet hashSet = new HashSet(map3.keySet());
                hashSet.addAll(map.keySet());
                LinkedList<PropertyChangeEvent> linkedList = new LinkedList<PropertyChangeEvent>();
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    propertyChangeListenerArray = (PropertyChangeListener[])iterator.next();
                    if (!$assertionsDisabled && propertyChangeListenerArray == null) {
                        throw new AssertionError();
                    }
                    object2 = (String)map3.get(propertyChangeListenerArray);
                    object = (String)map.get(propertyChangeListenerArray);
                    if (object != null) {
                        if (((String)object).equals(object2)) {
                            continue;
                        }
                    } else if (!$assertionsDisabled && object2 == null) {
                        throw new AssertionError((Object)("should not have had " + (String)propertyChangeListenerArray));
                    }
                    linkedList.add(new PropertyChangeEvent(this, (String)propertyChangeListenerArray, object2, object));
                }
                if (!$assertionsDisabled && linkedList.isEmpty()) {
                    throw new AssertionError();
                }
                this.defs = map2;
                object2 = this.listeners;
                synchronized (object2) {
                    propertyChangeListenerArray = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
                }
                for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
                    object = linkedList.iterator();
                    while (object.hasNext()) {
                        propertyChangeListenerArray[i].propertyChange((PropertyChangeEvent)object.next());
                    }
                }
            }
        }

        private static Map compose(PropertyProvider propertyProvider, PropertyProvider[] propertyProviderArray) {
            Map map;
            if (!($assertionsDisabled || ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess())) {
                throw new AssertionError();
            }
            if (propertyProvider != null) {
                map = propertyProvider.getProperties();
                if (!$assertionsDisabled && !SequentialPropertyEvaluator.isStringStringMap(map)) {
                    throw new AssertionError((Object)("Bad map " + map + " from " + propertyProvider));
                }
            } else {
                map = Collections.EMPTY_MAP;
            }
            Map[] mapArray = new Map[propertyProviderArray.length];
            for (int i = 0; i < propertyProviderArray.length; ++i) {
                mapArray[i] = propertyProviderArray[i].getProperties();
                if (!$assertionsDisabled && !SequentialPropertyEvaluator.isStringStringMap(mapArray[i])) {
                    throw new AssertionError((Object)("Bad map " + mapArray[i] + " from " + propertyProviderArray[i]));
                }
            }
            Map map2 = PropertyUtils.evaluateAll(map, Arrays.asList(mapArray));
            if (!$assertionsDisabled && map2 != null && !SequentialPropertyEvaluator.isStringStringMap(map2)) {
                throw new AssertionError((Object)("Bad map " + map2 + " from evaluateAll(" + map + ", " + mapArray + ")"));
            }
            return map2;
        }

        private static boolean isStringStringMap(Map map) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                if (k == null || !(k instanceof String)) {
                    return false;
                }
                Object v = entry.getValue();
                if (v != null && v instanceof String) continue;
                return false;
            }
            return true;
        }

        static /* synthetic */ Map access$000(PropertyProvider propertyProvider, PropertyProvider[] propertyProviderArray) {
            return SequentialPropertyEvaluator.compose(propertyProvider, propertyProviderArray);
        }

        static /* synthetic */ Map access$100(SequentialPropertyEvaluator sequentialPropertyEvaluator) {
            return sequentialPropertyEvaluator.defs;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$PropertyUtils == null ? (class$org$netbeans$spi$project$support$ant$PropertyUtils = PropertyUtils.class$("org.netbeans.spi.project.support.ant.PropertyUtils")) : class$org$netbeans$spi$project$support$ant$PropertyUtils).desiredAssertionStatus();
        }
    }

    private static final class FixedPropertyProvider
    implements PropertyProvider {
        private final Map defs;

        public FixedPropertyProvider(Map map) {
            this.defs = map;
        }

        public Map getProperties() {
            return this.defs;
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    private static final class FilePropertyProvider
    implements PropertyProvider,
    FileChangeSupportListener {
        private static final RequestProcessor RP = new RequestProcessor("PropertyUtils.FilePropertyProvider.RP");
        private final File properties;
        private final List listeners = new ArrayList();
        private Map cached = null;
        private long cachedTime = 0L;

        public FilePropertyProvider(File file) {
            this.properties = file;
            FileChangeSupport.DEFAULT.addListener(this, file);
        }

        public Map getProperties() {
            long l = this.properties.lastModified();
            if (this.cached == null || this.cachedTime != l) {
                this.cachedTime = l;
                this.cached = this.loadProperties();
            }
            return this.cached;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map loadProperties() {
            if (this.properties.isFile() && this.properties.canRead()) {
                Properties properties;
                FileInputStream fileInputStream = new FileInputStream(this.properties);
                try {
                    Properties properties2 = new Properties();
                    properties2.load(fileInputStream);
                    properties = properties2;
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)fileInputStream).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                }
                ((InputStream)fileInputStream).close();
                return properties;
            }
            return Collections.EMPTY_MAP;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ChangeListener[] changeListenerArray;
            this.cachedTime = -1L;
            Object object = this;
            synchronized (object) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            object = new ChangeEvent(this);
            Mutex.Action action = new Mutex.Action(this, changeListenerArray, (ChangeEvent)object){
                private final /* synthetic */ ChangeListener[] val$ls;
                private final /* synthetic */ ChangeEvent val$ev;
                private final /* synthetic */ FilePropertyProvider this$0;
                {
                    this.this$0 = filePropertyProvider;
                    this.val$ls = changeListenerArray;
                    this.val$ev = changeEvent;
                }

                public Object run() {
                    for (int i = 0; i < this.val$ls.length; ++i) {
                        this.val$ls[i].stateChanged(this.val$ev);
                    }
                    return null;
                }
            };
            if (ProjectManager.mutex().isWriteAccess()) {
                ProjectManager.mutex().readAccess(action);
            } else if (ProjectManager.mutex().isReadAccess()) {
                action.run();
            } else {
                RP.post(new Runnable(this, action){
                    private final /* synthetic */ Mutex.Action val$action;
                    private final /* synthetic */ FilePropertyProvider this$0;
                    {
                        this.this$0 = filePropertyProvider;
                        this.val$action = action;
                    }

                    public void run() {
                        ProjectManager.mutex().readAccess(this.val$action);
                    }
                });
            }
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        public void fileCreated(FileChangeSupportEvent fileChangeSupportEvent) {
            this.fireChange();
        }

        public void fileDeleted(FileChangeSupportEvent fileChangeSupportEvent) {
            this.fireChange();
        }

        public void fileModified(FileChangeSupportEvent fileChangeSupportEvent) {
            this.fireChange();
        }

        public String toString() {
            return "FilePropertyProvider[" + this.properties + ":" + this.getProperties() + "]";
        }
    }
}

