/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.project.ant.AntBasedProjectFactorySingleton;
import org.netbeans.modules.project.ant.Util;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.SubprojectProviderImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ReferenceHelper {
    static final String REFS_NAME = "references";
    static final String REF_NAME = "reference";
    static final String REFS_NS = "http://www.netbeans.org/ns/ant-project-references/1";
    static final String REFS_NS2 = "http://www.netbeans.org/ns/ant-project-references/2";
    private Set extraBaseDirectories = new HashSet();
    private final AntProjectHelper h;
    final PropertyEvaluator eval;
    private final AuxiliaryConfiguration aux;
    private static final Pattern FOREIGN_FILE_REFERENCE;
    private static final Pattern FOREIGN_FILE_REFERENCE_OLD;
    private static final Pattern FOREIGN_PLAIN_FILE_REFERENCE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReferenceHelper(AntProjectHelper antProjectHelper, AuxiliaryConfiguration auxiliaryConfiguration, PropertyEvaluator propertyEvaluator) {
        this.h = antProjectHelper;
        this.aux = auxiliaryConfiguration;
        this.eval = propertyEvaluator;
    }

    private Element loadReferences() {
        if (!($assertionsDisabled || ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess())) {
            throw new AssertionError();
        }
        Element element = this.aux.getConfigurationFragment(REFS_NAME, REFS_NS2, true);
        if (element == null) {
            element = this.aux.getConfigurationFragment(REFS_NAME, REFS_NS, true);
        }
        return element;
    }

    private void storeReferences(Element element) {
        if (!$assertionsDisabled && !ProjectManager.mutex().isWriteAccess()) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || element != null && element.getLocalName().equals(REFS_NAME) && (REFS_NS.equals(element.getNamespaceURI()) || REFS_NS2.equals(element.getNamespaceURI())))) {
            throw new AssertionError();
        }
        this.aux.putConfigurationFragment(element, true);
    }

    private void removeOldReferences() {
        if (!$assertionsDisabled && !ProjectManager.mutex().isWriteAccess()) {
            throw new AssertionError();
        }
        this.aux.removeConfigurationFragment(REFS_NAME, REFS_NS, true);
    }

    public boolean addReference(AntArtifact antArtifact) throws IllegalArgumentException {
        Object[] objectArray = this.addReference0(antArtifact, antArtifact.getArtifactLocations()[0]);
        return (Boolean)objectArray[0];
    }

    private Object[] addReference0(final AntArtifact antArtifact, final URI uRI) throws IllegalArgumentException {
        return ((List)ProjectManager.mutex().writeAccess(new Mutex.Action(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public Object run() {
                String string;
                String string2;
                RawReference rawReference;
                Object object;
                String string3;
                int n = ReferenceHelper.this.findLocationIndex(antArtifact, uRI);
                Project project = antArtifact.getProject();
                if (project == null) {
                    throw new IllegalArgumentException("No project associated with " + antArtifact);
                }
                File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
                if (!$assertionsDisabled && file == null) {
                    throw new AssertionError(project.getProjectDirectory());
                }
                String string4 = ReferenceHelper.getUsableReferenceID(ProjectUtils.getInformation((Project)project).getName());
                String string5 = ReferenceHelper.this.findReferenceID(string4, "project.", file.getAbsolutePath());
                if (string5 == null) {
                    string5 = ReferenceHelper.this.generateUniqueID(string4, "project.", file.getAbsolutePath());
                }
                File file2 = antArtifact.getScriptLocation();
                if (ReferenceHelper.canUseVersion10(antArtifact, file)) {
                    string3 = PropertyUtils.relativizeFile(file, file2);
                    try {
                        object = new URI(null, null, string3, null);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        object = file.toURI().relativize(file2.toURI());
                    }
                    rawReference = new RawReference(string5, antArtifact.getType(), (URI)object, antArtifact.getTargetName(), antArtifact.getCleanTargetName(), antArtifact.getID());
                } else {
                    if (file2.getAbsolutePath().startsWith(file.getAbsolutePath())) {
                        object = PropertyUtils.relativizeFile(file, file2);
                        if (!$assertionsDisabled && object == null) {
                            throw new AssertionError((Object)("Relativization must succeed for files: " + file + " " + file2));
                        }
                        string3 = "${project." + string5 + "}/" + (String)object;
                    } else {
                        string3 = "build.script.reference." + string5;
                        ReferenceHelper.this.setPathProperty(file, file2, string3);
                        string3 = "${" + string3 + "}";
                    }
                    rawReference = new RawReference(string5, antArtifact.getType(), string3, antArtifact.getTargetName(), antArtifact.getCleanTargetName(), antArtifact.getID(), antArtifact.getProperties());
                }
                boolean bl = ReferenceHelper.this.addRawReference0(rawReference);
                object = AntBasedProjectFactorySingleton.getProjectFor(ReferenceHelper.this.h).getProjectDirectory();
                File file3 = FileUtil.toFile((FileObject)object);
                if (ReferenceHelper.this.setPathProperty(file3, file, "project." + string5)) {
                    bl = true;
                }
                String string6 = "project." + string5;
                URI uRI2 = uRI;
                if (uRI2.isAbsolute()) {
                    string2 = new File(uRI2).getAbsolutePath();
                    string = "nbproject/private/private.properties";
                } else {
                    string2 = "${" + string6 + "}/" + uRI2.getPath();
                    string = "nbproject/project.properties";
                }
                EditableProperties editableProperties = ReferenceHelper.this.h.getProperties(string);
                String string7 = "reference." + string5 + '.' + ReferenceHelper.getUsableReferenceID(antArtifact.getID());
                if (n > 0) {
                    string7 = string7 + "." + n;
                }
                if (!string2.equals(editableProperties.getProperty(string7))) {
                    editableProperties.put(string7, string2);
                    ReferenceHelper.this.h.putProperties(string, editableProperties);
                    bl = true;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(bl);
                arrayList.add("${" + string7 + "}");
                return arrayList;
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$ReferenceHelper == null ? (class$org$netbeans$spi$project$support$ant$ReferenceHelper = ReferenceHelper.class$("org.netbeans.spi.project.support.ant.ReferenceHelper")) : class$org$netbeans$spi$project$support$ant$ReferenceHelper).desiredAssertionStatus();
            }
        })).toArray(new Object[2]);
    }

    private int findLocationIndex(AntArtifact antArtifact, URI uRI) throws IllegalArgumentException {
        if (uRI == null) {
            throw new IllegalArgumentException("location cannot be null");
        }
        URI[] uRIArray = antArtifact.getArtifactLocations();
        for (int i = 0; i < uRIArray.length; ++i) {
            if (!uRIArray[i].equals(uRI)) continue;
            return i;
        }
        throw new IllegalArgumentException("location (" + uRI + ") must be in AntArtifact's locations (" + antArtifact + ")");
    }

    private static boolean canUseVersion10(AntArtifact antArtifact, File file) {
        if (antArtifact.getArtifactLocations().length > 1) {
            return false;
        }
        if (antArtifact.getProperties().keySet().size() > 0) {
            return false;
        }
        return antArtifact.getScriptLocation().getAbsolutePath().startsWith(file.getAbsolutePath());
    }

    private boolean setPathProperty(File file, File file2, String string) {
        String string2;
        EditableProperties editableProperties;
        String[] stringArray;
        String[] stringArray2;
        String string3 = this.relativizeFileToExtraBaseFolders(file2);
        if (string3 != null) {
            stringArray2 = new String[]{"nbproject/project.properties"};
            stringArray = new String[]{string3};
        } else if (CollocationQuery.areCollocated((File)file, (File)file2)) {
            string3 = PropertyUtils.relativizeFile(file, file2);
            if (!$assertionsDisabled && string3 == null) {
                throw new AssertionError((Object)("These dirs are not really collocated: " + file + " & " + file2));
            }
            stringArray = new String[]{string3, file2.getAbsolutePath()};
            stringArray2 = new String[]{"nbproject/project.properties", "nbproject/private/private.properties"};
        } else {
            stringArray2 = new String[]{"nbproject/private/private.properties"};
            stringArray = new String[]{file2.getAbsolutePath()};
        }
        boolean bl = false;
        for (int i = 0; i < stringArray2.length; ++i) {
            editableProperties = this.h.getProperties(stringArray2[i]);
            if (stringArray[i].equals(editableProperties.getProperty(string))) continue;
            editableProperties.put(string, stringArray[i]);
            this.h.putProperties(stringArray2[i], editableProperties);
            bl = true;
        }
        if (stringArray2.length == 1 && (editableProperties = this.h.getProperties(string2 = stringArray2[0] == "nbproject/project.properties" ? "nbproject/private/private.properties" : "nbproject/project.properties")).remove(string) != null) {
            this.h.putProperties(string2, editableProperties);
        }
        return bl;
    }

    public String addReference(AntArtifact antArtifact, URI uRI) throws IllegalArgumentException {
        Object[] objectArray = this.addReference0(antArtifact, uRI);
        return (String)objectArray[1];
    }

    public boolean isReferenced(final AntArtifact antArtifact, final URI uRI) throws IllegalArgumentException {
        return (Boolean)ProjectManager.mutex().readAccess(new Mutex.Action(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public Object run() {
                int n = ReferenceHelper.this.findLocationIndex(antArtifact, uRI);
                Project project = antArtifact.getProject();
                if (project == null) {
                    throw new IllegalArgumentException("No project associated with " + antArtifact);
                }
                File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
                if (!$assertionsDisabled && file == null) {
                    throw new AssertionError(project.getProjectDirectory());
                }
                String string = ReferenceHelper.getUsableReferenceID(ProjectUtils.getInformation((Project)project).getName());
                String string2 = ReferenceHelper.this.findReferenceID(string, "project.", file.getAbsolutePath());
                if (string2 == null) {
                    return Boolean.FALSE;
                }
                RawReference rawReference = ReferenceHelper.this.getRawReference(string2, ReferenceHelper.getUsableReferenceID(antArtifact.getID()));
                if (rawReference == null) {
                    return Boolean.FALSE;
                }
                File file2 = ReferenceHelper.this.h.resolveFile(ReferenceHelper.this.eval.evaluate(rawReference.getScriptLocationValue()));
                if (!(antArtifact.getType().equals(rawReference.getArtifactType()) && antArtifact.getID().equals(rawReference.getID()) && antArtifact.getScriptLocation().equals(file2) && antArtifact.getProperties().equals(rawReference.getProperties()) && antArtifact.getTargetName().equals(rawReference.getTargetName()) && antArtifact.getCleanTargetName().equals(rawReference.getCleanTargetName()))) {
                    return Boolean.FALSE;
                }
                String string3 = "reference." + string2 + '.' + ReferenceHelper.getUsableReferenceID(antArtifact.getID());
                if (n > 0) {
                    string3 = string3 + "." + n;
                }
                return ReferenceHelper.this.eval.getProperty(string3) != null;
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$ReferenceHelper == null ? (class$org$netbeans$spi$project$support$ant$ReferenceHelper = ReferenceHelper.class$("org.netbeans.spi.project.support.ant.ReferenceHelper")) : class$org$netbeans$spi$project$support$ant$ReferenceHelper).desiredAssertionStatus();
            }
        });
    }

    public boolean addRawReference(final RawReference rawReference) {
        return (Boolean)ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                try {
                    return ReferenceHelper.this.addRawReference0(rawReference);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
                    return Boolean.FALSE;
                }
            }
        });
    }

    private boolean addRawReference0(RawReference rawReference) throws IllegalArgumentException {
        Element element = this.loadReferences();
        if (element == null) {
            element = XMLUtil.createDocument((String)"ignore", null, null, null).createElementNS(rawReference.getNS(), REFS_NAME);
        }
        boolean bl = false;
        if (element.getNamespaceURI().equals(REFS_NS) && rawReference.getNS().equals(REFS_NS2)) {
            element = this.upgradeTo20(element);
            this.removeOldReferences();
            bl = true;
        }
        if (bl = ReferenceHelper.updateRawReferenceElement(rawReference, element)) {
            this.storeReferences(element);
        }
        return bl;
    }

    private Element upgradeTo20(Element element) {
        Element element2 = XMLUtil.createDocument((String)"ignore", null, null, null).createElementNS(REFS_NS2, REFS_NAME);
        RawReference[] rawReferenceArray = ReferenceHelper.getRawReferences(element);
        for (int i = 0; i < rawReferenceArray.length; ++i) {
            rawReferenceArray[i].upgrade();
            ReferenceHelper.updateRawReferenceElement(rawReferenceArray[i], element2);
        }
        return element2;
    }

    private static boolean updateRawReferenceElement(RawReference rawReference, Element element) throws IllegalArgumentException {
        Element element2;
        Element element3 = null;
        List list = Util.findSubElements(element);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            RawReference rawReference2 = RawReference.create(element2);
            if (rawReference2.getForeignProjectName().compareTo(rawReference.getForeignProjectName()) > 0) {
                element3 = element2;
                break;
            }
            if (!rawReference2.getForeignProjectName().equals(rawReference.getForeignProjectName())) continue;
            if (rawReference2.getID().compareTo(rawReference.getID()) > 0) {
                element3 = element2;
                break;
            }
            if (!rawReference2.getID().equals(rawReference.getID())) continue;
            if (rawReference2.getArtifactType().equals(rawReference.getArtifactType()) && rawReference2.getScriptLocationValue().equals(rawReference.getScriptLocationValue()) && rawReference2.getProperties().equals(rawReference.getProperties()) && rawReference2.getTargetName().equals(rawReference.getTargetName()) && rawReference2.getCleanTargetName().equals(rawReference.getCleanTargetName())) {
                return false;
            }
            element.removeChild(element2);
            element3 = iterator.hasNext() ? (Element)iterator.next() : null;
            break;
        }
        element2 = rawReference.toXml(element.getNamespaceURI(), element.getOwnerDocument());
        element.insertBefore(element2, element3);
        return true;
    }

    public boolean removeReference(String string, String string2) {
        return this.removeReference(string, string2, false, null);
    }

    private boolean isLastReference(String string) {
        Object[] objectArray = this.findArtifactAndLocation(string);
        if (objectArray[0] == null || objectArray[1] == null) {
            return true;
        }
        AntArtifact antArtifact = (AntArtifact)objectArray[0];
        URI uRI = (URI)objectArray[1];
        URI[] uRIArray = antArtifact.getArtifactLocations();
        boolean bl = true;
        for (int i = 0; i < uRIArray.length; ++i) {
            if (uRIArray[i].equals(uRI) || !this.isReferenced(antArtifact, uRIArray[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean removeReference(final String string, final String string2, final boolean bl, final String string3) {
        return (Boolean)ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                int n;
                Object object;
                Object object2;
                boolean bl2 = false;
                try {
                    if (ReferenceHelper.this.isLastReference("${" + string3 + "}")) {
                        bl2 = ReferenceHelper.this.removeRawReference0(string, string2, bl);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
                    return Boolean.FALSE;
                }
                String[] stringArray = new String[]{"nbproject/project.properties", "nbproject/private/private.properties"};
                if (bl2) {
                    object2 = new RawReference[]{};
                    object = ReferenceHelper.this.loadReferences();
                    if (object != null) {
                        object2 = ReferenceHelper.getRawReferences((Element)object);
                    }
                    n = 1;
                    for (int i = 0; i < ((RawReference[])object2).length; ++i) {
                        if (!object2[i].getForeignProjectName().equals(string)) continue;
                        n = 0;
                        break;
                    }
                    if (n != 0) {
                        String string4 = "project." + string;
                        for (int i = 0; i < stringArray.length; ++i) {
                            EditableProperties editableProperties = ReferenceHelper.this.h.getProperties(stringArray[i]);
                            if (!editableProperties.containsKey(string4)) continue;
                            editableProperties.remove(string4);
                            ReferenceHelper.this.h.putProperties(stringArray[i], editableProperties);
                            bl2 = true;
                        }
                    }
                }
                if ((object2 = string3) == null) {
                    object2 = "reference." + string + '.' + ReferenceHelper.getUsableReferenceID(string2);
                }
                object = "build.script.reference." + string;
                for (n = 0; n < stringArray.length; ++n) {
                    EditableProperties editableProperties = ReferenceHelper.this.h.getProperties(stringArray[n]);
                    if (editableProperties.containsKey(object2)) {
                        editableProperties.remove(object2);
                        ReferenceHelper.this.h.putProperties(stringArray[n], editableProperties);
                        bl2 = true;
                    }
                    if (!editableProperties.containsKey(object)) continue;
                    editableProperties.remove(object);
                    ReferenceHelper.this.h.putProperties(stringArray[n], editableProperties);
                    bl2 = true;
                }
                return bl2;
            }
        });
    }

    public boolean removeReference(String string) {
        return this.removeFileReference(string);
    }

    private boolean removeFileReference(final String string) {
        return (Boolean)ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                boolean bl = false;
                String[] stringArray = new String[]{"nbproject/project.properties", "nbproject/private/private.properties"};
                String string2 = string;
                if (string2.startsWith("${") && string2.endsWith("}")) {
                    string2 = string2.substring(2, string2.length() - 1);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    EditableProperties editableProperties = ReferenceHelper.this.h.getProperties(stringArray[i]);
                    if (!editableProperties.containsKey(string2)) continue;
                    editableProperties.remove(string2);
                    ReferenceHelper.this.h.putProperties(stringArray[i], editableProperties);
                    bl = true;
                }
                return bl;
            }
        });
    }

    public boolean removeRawReference(final String string, final String string2) {
        return (Boolean)ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                try {
                    return ReferenceHelper.this.removeRawReference0(string, string2, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
                    return Boolean.FALSE;
                }
            }
        });
    }

    private boolean removeRawReference0(String string, String string2, boolean bl) throws IllegalArgumentException {
        Element element = this.loadReferences();
        if (element == null) {
            return false;
        }
        boolean bl2 = ReferenceHelper.removeRawReferenceElement(string, string2, element, bl);
        if (bl2) {
            this.storeReferences(element);
        }
        return bl2;
    }

    private static boolean removeRawReferenceElement(String string, String string2, Element element, boolean bl) throws IllegalArgumentException {
        List list = Util.findSubElements(element);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            RawReference rawReference = RawReference.create(element2);
            String string3 = rawReference.getID();
            String string4 = rawReference.getForeignProjectName();
            if (bl) {
                string3 = ReferenceHelper.getUsableReferenceID(rawReference.getID());
                string4 = ReferenceHelper.getUsableReferenceID(rawReference.getForeignProjectName());
            }
            if (string4.compareTo(string) > 0) {
                return false;
            }
            if (!string4.equals(string)) continue;
            if (string3.compareTo(string2) > 0) {
                return false;
            }
            if (!string3.equals(string2)) continue;
            element.removeChild(element2);
            return true;
        }
        return false;
    }

    public RawReference[] getRawReferences() {
        return (RawReference[])ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                Element element = ReferenceHelper.this.loadReferences();
                if (element != null) {
                    try {
                        return ReferenceHelper.getRawReferences(element);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
                    }
                }
                return new RawReference[0];
            }
        });
    }

    private static RawReference[] getRawReferences(Element element) throws IllegalArgumentException {
        List list = Util.findSubElements(element);
        ArrayList<RawReference> arrayList = new ArrayList<RawReference>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(RawReference.create((Element)iterator.next()));
        }
        return arrayList.toArray(new RawReference[arrayList.size()]);
    }

    public RawReference getRawReference(String string, String string2) {
        return this.getRawReference(string, string2, false);
    }

    RawReference getRawReference(final String string, final String string2, final boolean bl) {
        return (RawReference)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                Element element = ReferenceHelper.this.loadReferences();
                if (element != null) {
                    try {
                        return ReferenceHelper.getRawReference(string, string2, element, bl);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
                    }
                }
                return null;
            }
        });
    }

    private static RawReference getRawReference(String string, String string2, Element element, boolean bl) throws IllegalArgumentException {
        List list = Util.findSubElements(element);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RawReference rawReference = RawReference.create((Element)iterator.next());
            String string3 = rawReference.getID();
            String string4 = rawReference.getForeignProjectName();
            if (bl) {
                string3 = ReferenceHelper.getUsableReferenceID(rawReference.getID());
                string4 = ReferenceHelper.getUsableReferenceID(rawReference.getForeignProjectName());
            }
            if (!string4.equals(string) || !string3.equals(string2)) continue;
            return rawReference;
        }
        return null;
    }

    public String createForeignFileReference(final File file, final String string) {
        if (!file.equals(FileUtil.normalizeFile((File)file))) {
            throw new IllegalArgumentException("Parameter file was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile((File)file));
        }
        return (String)ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                String string3;
                AntArtifact antArtifact = AntArtifactQuery.findArtifactFromFile(file);
                if (antArtifact != null && antArtifact.getType().equals(string) && antArtifact.getProject() != null) {
                    try {
                        return ReferenceHelper.this.createForeignFileReference(antArtifact);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new AssertionError((Object)illegalArgumentException);
                    }
                }
                File file2 = FileUtil.toFile((FileObject)AntBasedProjectFactorySingleton.getProjectFor(ReferenceHelper.this.h).getProjectDirectory());
                String string2 = file.getName();
                if (file.isDirectory() && file.getParentFile() != null) {
                    string2 = file.getParentFile().getName() + "-" + file.getName();
                }
                if ((string3 = ReferenceHelper.this.findReferenceID(string2 = PropertyUtils.getUsablePropertyName(string2), "file.reference.", file.getAbsolutePath())) == null) {
                    string3 = ReferenceHelper.this.generateUniqueID(string2, "file.reference.", file.getAbsolutePath());
                }
                ReferenceHelper.this.setPathProperty(file2, file, "file.reference." + string3);
                return "${file.reference." + string3 + '}';
            }
        });
    }

    private String relativizeFileToExtraBaseFolders(File file) {
        File file2 = FileUtil.toFile((FileObject)this.h.getProjectDirectory());
        String string = file.getAbsolutePath();
        Iterator iterator = this.extraBaseDirectories.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = this.eval.getProperty(string2);
            File file3 = PropertyUtils.resolveFile(file2, string3);
            if (!(string3 = file3.getAbsolutePath()).endsWith(File.separator)) {
                string3 = string3 + File.separator;
            }
            if (!string.startsWith(string3)) continue;
            return "${" + string2 + "}/" + string.substring(string3.length()).replace('\\', '/');
        }
        return null;
    }

    public void addExtraBaseDirectory(final String string) {
        if (string == null || this.eval.getProperty(string) == null) {
            throw new IllegalArgumentException("propertyName is null or such a property does not exist: " + string);
        }
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                if (!ReferenceHelper.this.extraBaseDirectories.add(string)) {
                    throw new IllegalArgumentException("Already extra base directory property: " + string);
                }
            }
        });
    }

    public void removeExtraBaseDirectory(final String string) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                if (!ReferenceHelper.this.extraBaseDirectories.remove(string)) {
                    throw new IllegalArgumentException("Non-existing extra base directory property: " + string);
                }
                String string4 = "${" + string + "}";
                boolean bl = ReferenceHelper.this.h.getProperties("nbproject/project.properties").containsKey(string);
                String string2 = ReferenceHelper.this.eval.getProperty(string);
                EditableProperties editableProperties = ReferenceHelper.this.h.getProperties("nbproject/project.properties");
                EditableProperties editableProperties2 = ReferenceHelper.this.h.getProperties("nbproject/private/private.properties");
                boolean bl2 = false;
                boolean bl3 = false;
                Iterator iterator = editableProperties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    String string3 = (String)entry.getValue();
                    int n = string3.indexOf(string4);
                    if (n == -1) continue;
                    string3 = string3.substring(0, n) + string2 + string3.substring(n + string4.length());
                    if (bl) {
                        entry.setValue(string3);
                        bl2 = true;
                        continue;
                    }
                    iterator.remove();
                    editableProperties2.put(entry.getKey(), string3);
                    bl3 = true;
                    bl2 = true;
                }
                if (bl2) {
                    ReferenceHelper.this.h.putProperties("nbproject/project.properties", editableProperties);
                }
                if (bl3) {
                    ReferenceHelper.this.h.putProperties("nbproject/private/private.properties", editableProperties2);
                }
            }
        });
    }

    private String findReferenceID(String string, String string2, String string3) {
        Map map = this.h.getStandardPropertyEvaluator().getProperties();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string4;
            String string5 = (String)iterator.next();
            if (!string5.startsWith(string2 + string) || !string3.equals(string4 = this.h.resolvePath((String)map.get(string5)))) continue;
            return string5.substring(string2.length());
        }
        return null;
    }

    private String generateUniqueID(String string, String string2, String string3) {
        PropertyEvaluator propertyEvaluator = this.h.getStandardPropertyEvaluator();
        if (propertyEvaluator.getProperty(string2 + string) == null) {
            return string;
        }
        int n = 1;
        while (propertyEvaluator.getProperty(string2 + string + "-" + n) != null) {
            ++n;
        }
        return string + "-" + n;
    }

    public String createForeignFileReference(AntArtifact antArtifact) throws IllegalArgumentException {
        Object[] objectArray = this.addReference0(antArtifact, antArtifact.getArtifactLocations()[0]);
        return (String)objectArray[1];
    }

    private static String getUsableReferenceID(String string) {
        return PropertyUtils.getUsablePropertyName(string).replace('.', '_');
    }

    public AntArtifact getForeignFileReferenceAsArtifact(String string) {
        Object[] objectArray = this.findArtifactAndLocation(string);
        return (AntArtifact)objectArray[0];
    }

    public Object[] findArtifactAndLocation(final String string) {
        return ((List)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                Object object;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                AntArtifact antArtifact = null;
                Matcher matcher = FOREIGN_FILE_REFERENCE.matcher(string);
                boolean bl = matcher.matches();
                int n = 0;
                if (!bl) {
                    matcher = FOREIGN_FILE_REFERENCE_OLD.matcher(string);
                    bl = matcher.matches();
                } else {
                    try {
                        n = Integer.parseInt(matcher.group(3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        ErrorManager.getDefault().log(1, "Could not parse reference (" + string + ") for the jar index. " + "Expected number: " + matcher.group(3));
                        bl = false;
                    }
                }
                if (bl && (object = ReferenceHelper.this.getRawReference(matcher.group(1), matcher.group(2), true)) != null) {
                    antArtifact = ((RawReference)object).toAntArtifact(ReferenceHelper.this);
                }
                if (antArtifact == null) {
                    arrayList.add(null);
                    arrayList.add(null);
                    return arrayList;
                }
                if (n >= antArtifact.getArtifactLocations().length) {
                    arrayList.add(null);
                    arrayList.add(null);
                    return arrayList;
                }
                object = antArtifact.getArtifactLocations()[n];
                arrayList.add(antArtifact);
                arrayList.add(object);
                return arrayList;
            }
        })).toArray(new Object[2]);
    }

    public void destroyForeignFileReference(String string) {
        this.destroyReference(string);
    }

    public boolean destroyReference(String string) {
        Matcher matcher = FOREIGN_FILE_REFERENCE.matcher(string);
        boolean bl = matcher.matches();
        if (!bl) {
            matcher = FOREIGN_FILE_REFERENCE_OLD.matcher(string);
            bl = matcher.matches();
        }
        if (bl) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            return this.removeReference(string2, string3, true, string.substring(2, string.length() - 1));
        }
        matcher = FOREIGN_PLAIN_FILE_REFERENCE.matcher(string);
        if (matcher.matches()) {
            return this.removeFileReference(string);
        }
        return false;
    }

    public SubprojectProvider createSubprojectProvider() {
        return new SubprojectProviderImpl(this);
    }

    AntProjectHelper getAntProjectHelper() {
        return this.h;
    }

    public void fixReferences(File file) {
        File file2;
        boolean bl;
        String string;
        Map.Entry entry;
        String[] stringArray = new String[]{"file.reference.", "project."};
        EditableProperties editableProperties = this.h.getProperties("nbproject/project.properties");
        EditableProperties editableProperties2 = this.h.getProperties("nbproject/private/private.properties");
        File file3 = FileUtil.toFile((FileObject)this.h.getProjectDirectory());
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        Iterator iterator = editableProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            String string2;
            entry = (Map.Entry)iterator.next();
            string = (String)entry.getKey();
            bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.startsWith(stringArray[i])) continue;
                bl = true;
                break;
            }
            if (!bl || CollocationQuery.areCollocated((File)(file2 = FileUtil.normalizeFile((File)PropertyUtils.resolveFile(file, string2 = (String)entry.getValue()))), (File)file3)) continue;
            arrayList.add(string);
            hashMap2.put(string, file2.getAbsolutePath());
        }
        iterator = editableProperties2.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            string = (String)entry.getKey();
            bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.startsWith(stringArray[i])) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            String string3 = (String)entry.getValue();
            file2 = FileUtil.normalizeFile((File)PropertyUtils.resolveFile(file, string3));
            if (file2.getAbsolutePath().startsWith(file.getAbsolutePath())) {
                String string4 = PropertyUtils.relativizeFile(file, file2);
                file2 = new File(file3, string4);
                arrayList2.add(string);
                hashMap2.put(string, file2.getAbsolutePath());
            }
            if (!CollocationQuery.areCollocated((File)file2, (File)file3)) continue;
            hashMap.put(string, PropertyUtils.relativizeFile(file3, file2));
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            editableProperties.remove(iterator.next());
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            editableProperties2.remove(iterator.next());
        }
        editableProperties.putAll(hashMap);
        editableProperties2.putAll(hashMap2);
        this.h.putProperties("nbproject/project.properties", editableProperties);
        this.h.putProperties("nbproject/private/private.properties", editableProperties2);
    }

    static {
        $assertionsDisabled = !ReferenceHelper.class.desiredAssertionStatus();
        FOREIGN_FILE_REFERENCE = Pattern.compile("\\$\\{reference\\.([^.${}]+)\\.([^.${}]+)\\.([\\d&&[^.${}]]+)\\}");
        FOREIGN_FILE_REFERENCE_OLD = Pattern.compile("\\$\\{reference\\.([^.${}]+)\\.([^.${}]+)\\}");
        FOREIGN_PLAIN_FILE_REFERENCE = Pattern.compile("\\$\\{file\\.reference\\.([^${}]+)\\}");
    }

    public static final class RawReference {
        private final String foreignProjectName;
        private final String artifactType;
        private URI scriptLocation;
        private String newScriptLocation;
        private final String targetName;
        private final String cleanTargetName;
        private final String artifactID;
        private final Properties props;
        private static final List SUB_ELEMENT_NAMES;
        static final /* synthetic */ boolean $assertionsDisabled;

        public RawReference(String string, String string2, URI uRI, String string3, String string4, String string5) throws IllegalArgumentException {
            this(string, string2, uRI, null, string3, string4, string5, new Properties());
        }

        public RawReference(String string, String string2, String string3, String string4, String string5, String string6, Properties properties) throws IllegalArgumentException {
            this(string, string2, null, string3, string4, string5, string6, properties);
        }

        private RawReference(String string, String string2, URI uRI, String string3, String string4, String string5, String string6, Properties properties) throws IllegalArgumentException {
            this.foreignProjectName = string;
            this.artifactType = string2;
            if (uRI != null && uRI.isAbsolute()) {
                throw new IllegalArgumentException("Cannot use an absolute URI " + uRI + " for script location");
            }
            this.scriptLocation = uRI;
            this.newScriptLocation = string3;
            this.targetName = string4;
            this.cleanTargetName = string5;
            this.artifactID = string6;
            this.props = properties;
        }

        static RawReference create(Element element) throws IllegalArgumentException {
            if (ReferenceHelper.REFS_NS.equals(element.getNamespaceURI())) {
                return RawReference.create1(element);
            }
            return RawReference.create2(element);
        }

        private static RawReference create1(Element element) throws IllegalArgumentException {
            if (!ReferenceHelper.REF_NAME.equals(element.getLocalName()) || !ReferenceHelper.REFS_NS.equals(element.getNamespaceURI())) {
                throw new IllegalArgumentException("bad element name: " + element);
            }
            NodeList nodeList = element.getElementsByTagNameNS("*", "*");
            if (nodeList.getLength() != 6) {
                throw new IllegalArgumentException("missing or extra data: " + element);
            }
            String[] stringArray = new String[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                if (!ReferenceHelper.REFS_NS.equals(element2.getNamespaceURI())) {
                    throw new IllegalArgumentException("bad subelement ns: " + element2);
                }
                String string = element2.getLocalName();
                int n = SUB_ELEMENT_NAMES.indexOf(string);
                if (n == -1) {
                    throw new IllegalArgumentException("bad subelement name: " + string);
                }
                String string2 = Util.findText(element2);
                if (string2 == null) {
                    throw new IllegalArgumentException("empty subelement: " + element2);
                }
                if (stringArray[n] != null) {
                    throw new IllegalArgumentException("duplicate " + string + ": " + stringArray[n] + " and " + string2);
                }
                stringArray[n] = string2;
            }
            if (!$assertionsDisabled && Arrays.asList(stringArray).contains(null)) {
                throw new AssertionError();
            }
            URI uRI = URI.create(stringArray[2]);
            return new RawReference(stringArray[0], stringArray[1], uRI, stringArray[3], stringArray[4], stringArray[5]);
        }

        private static RawReference create2(Element element) throws IllegalArgumentException {
            String string;
            Object object;
            Element element2;
            if (!ReferenceHelper.REF_NAME.equals(element.getLocalName()) || !ReferenceHelper.REFS_NS2.equals(element.getNamespaceURI())) {
                throw new IllegalArgumentException("bad element name: " + element);
            }
            List list = Util.findSubElements(element);
            if (list.size() < 6) {
                throw new IllegalArgumentException("missing or extra data: " + element);
            }
            String[] stringArray = new String[6];
            for (int i = 0; i < 6; ++i) {
                element2 = (Element)list.get(i);
                if (!ReferenceHelper.REFS_NS2.equals(element2.getNamespaceURI())) {
                    throw new IllegalArgumentException("bad subelement ns: " + element2);
                }
                object = element2.getLocalName();
                int n = SUB_ELEMENT_NAMES.indexOf(object);
                if (n == -1) {
                    throw new IllegalArgumentException("bad subelement name: " + (String)object);
                }
                string = Util.findText(element2);
                if (string == null) {
                    throw new IllegalArgumentException("empty subelement: " + element2);
                }
                if (stringArray[n] != null) {
                    throw new IllegalArgumentException("duplicate " + (String)object + ": " + stringArray[n] + " and " + string);
                }
                stringArray[n] = string;
            }
            Properties properties = new Properties();
            if (list.size() == 7) {
                element2 = (Element)list.get(6);
                if (!ReferenceHelper.REFS_NS2.equals(element2.getNamespaceURI())) {
                    throw new IllegalArgumentException("bad subelement ns: " + element2);
                }
                if (!"properties".equals(element2.getLocalName())) {
                    throw new IllegalArgumentException("bad subelement. expected 'properties': " + element2);
                }
                object = Util.findSubElements(element2).iterator();
                while (object.hasNext()) {
                    element2 = (Element)object.next();
                    String string2 = element2.getAttribute("name");
                    string = Util.findText(element2);
                    if (string == null) {
                        string = "";
                    }
                    properties.setProperty(string2, string);
                }
            }
            if (!$assertionsDisabled && Arrays.asList(stringArray).contains(null)) {
                throw new AssertionError();
            }
            return new RawReference(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], properties);
        }

        Element toXml(String string, Document document) {
            Object object;
            Element element = document.createElementNS(string, ReferenceHelper.REF_NAME);
            String[] stringArray = new String[]{this.foreignProjectName, this.artifactType, this.newScriptLocation != null ? this.newScriptLocation : this.scriptLocation.toString(), this.targetName, this.cleanTargetName, this.artifactID};
            for (int i = 0; i < 6; ++i) {
                object = document.createElementNS(string, (String)SUB_ELEMENT_NAMES.get(i));
                object.appendChild(document.createTextNode(stringArray[i]));
                element.appendChild((Node)object);
            }
            if (this.props.keySet().size() > 0) {
                if (!$assertionsDisabled && !string.equals(ReferenceHelper.REFS_NS2)) {
                    throw new AssertionError((Object)"can happen only in /2");
                }
                Element element2 = document.createElementNS(string, "properties");
                element.appendChild(element2);
                object = new ArrayList<Object>(this.props.keySet());
                Collections.sort(object);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    Element element3 = document.createElementNS(string, "property");
                    element3.appendChild(document.createTextNode(this.props.getProperty(string2)));
                    element3.setAttribute("name", string2);
                    element2.appendChild(element3);
                }
            }
            return element;
        }

        private String getNS() {
            if (this.newScriptLocation != null) {
                return ReferenceHelper.REFS_NS2;
            }
            return ReferenceHelper.REFS_NS;
        }

        public String getForeignProjectName() {
            return this.foreignProjectName;
        }

        public String getArtifactType() {
            return this.artifactType;
        }

        public URI getScriptLocation() {
            return this.scriptLocation;
        }

        public String getScriptLocationValue() {
            if (this.newScriptLocation != null) {
                return this.newScriptLocation;
            }
            return "${project." + this.foreignProjectName + "}/" + this.scriptLocation.toString();
        }

        public String getTargetName() {
            return this.targetName;
        }

        public String getCleanTargetName() {
            return this.cleanTargetName;
        }

        public String getID() {
            return this.artifactID;
        }

        public Properties getProperties() {
            return this.props;
        }

        public AntArtifact toAntArtifact(ReferenceHelper referenceHelper) {
            return (AntArtifact)ProjectManager.mutex().readAccess(new Mutex.Action(this, referenceHelper){
                private final /* synthetic */ ReferenceHelper val$helper;
                private final /* synthetic */ RawReference this$0;
                {
                    this.this$0 = rawReference;
                    this.val$helper = referenceHelper;
                }

                public Object run() {
                    Project project;
                    AntProjectHelper antProjectHelper = ReferenceHelper.access$700(this.val$helper);
                    String string = this.val$helper.eval.getProperty("project." + RawReference.access$1800(this.this$0));
                    if (string == null) {
                        return null;
                    }
                    FileObject fileObject = antProjectHelper.resolveFileObject(string);
                    if (fileObject == null) {
                        return null;
                    }
                    try {
                        project = ProjectManager.getDefault().findProject(fileObject);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        return null;
                    }
                    if (project == null) {
                        return null;
                    }
                    return AntArtifactQuery.findArtifactByID(project, RawReference.access$1900(this.this$0));
                }
            });
        }

        private void upgrade() {
            if (!($assertionsDisabled || this.newScriptLocation == null && this.scriptLocation != null)) {
                throw new AssertionError((Object)("was already upgraded " + this));
            }
            this.newScriptLocation = "${project." + this.foreignProjectName + "}/" + this.scriptLocation.toString();
            this.scriptLocation = null;
        }

        public String toString() {
            return "ReferenceHelper.RawReference<" + this.foreignProjectName + "," + this.artifactType + "," + this.newScriptLocation != null ? this.newScriptLocation : this.scriptLocation + "," + this.targetName + "," + this.cleanTargetName + "," + this.artifactID + ">";
        }

        static /* synthetic */ String access$1800(RawReference rawReference) {
            return rawReference.foreignProjectName;
        }

        static /* synthetic */ String access$1900(RawReference rawReference) {
            return rawReference.artifactID;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$ReferenceHelper == null ? (class$org$netbeans$spi$project$support$ant$ReferenceHelper = ReferenceHelper.class$("org.netbeans.spi.project.support.ant.ReferenceHelper")) : class$org$netbeans$spi$project$support$ant$ReferenceHelper).desiredAssertionStatus();
            SUB_ELEMENT_NAMES = Arrays.asList("foreign-project", "artifact-type", "script", "target", "clean-target", "id");
        }
    }
}

