/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.util.WeakListeners;

final class SharabilityQueryImpl
implements SharabilityQueryImplementation,
PropertyChangeListener {
    private final AntProjectHelper h;
    private final PropertyEvaluator eval;
    private final String[] includes;
    private final String[] excludes;
    private String[] includePaths;
    private String[] excludePaths;

    SharabilityQueryImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, String[] stringArray, String[] stringArray2) {
        this.h = antProjectHelper;
        this.eval = propertyEvaluator;
        this.includes = stringArray;
        this.excludes = stringArray2;
        this.computeFiles();
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeFiles() {
        String[] stringArray = this.computeFrom(this.includes);
        String[] stringArray2 = this.computeFrom(this.excludes);
        SharabilityQueryImpl sharabilityQueryImpl = this;
        synchronized (sharabilityQueryImpl) {
            this.includePaths = stringArray;
            this.excludePaths = stringArray2;
        }
    }

    private String[] computeFrom(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.eval.evaluate(stringArray[i]);
            if (string == null) continue;
            File file = this.h.resolveFile(string);
            arrayList.add(file.getAbsolutePath());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public synchronized int getSharability(File file) {
        String string = file.getAbsolutePath();
        if (SharabilityQueryImpl.contains(string, this.excludePaths, false)) {
            return 2;
        }
        return SharabilityQueryImpl.contains(string, this.includePaths, false) ? (SharabilityQueryImpl.contains(string, this.excludePaths, true) ? 3 : 1) : 0;
    }

    private static boolean contains(String string, String[] stringArray, boolean bl) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.equals(stringArray[i])) {
                return true;
            }
            if (!(bl ? stringArray[i].startsWith(string + File.separatorChar) : string.startsWith(stringArray[i] + File.separatorChar))) continue;
            return true;
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.computeFiles();
    }
}

