/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;

public class StoreGroup {
    private Map models;
    private Set modifiedDocuments;
    private static final Integer BOOLEAN_KIND_TF;
    private static final Integer BOOLEAN_KIND_YN;
    private static final Integer BOOLEAN_KIND_ED;
    private DocumentListener documentListener = new DocumentListener(){

        public void insertUpdate(DocumentEvent documentEvent) {
            StoreGroup.this.documentModified(documentEvent.getDocument());
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            StoreGroup.this.documentModified(documentEvent.getDocument());
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            StoreGroup.this.documentModified(documentEvent.getDocument());
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;

    public StoreGroup() {
        this.models = new HashMap();
        this.modifiedDocuments = new HashSet();
    }

    public void store(EditableProperties editableProperties) {
        Iterator iterator = this.models.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Object object;
            String string2 = (String)iterator.next();
            Object[] objectArray = (Object[])this.models.get(string2);
            if (objectArray[0] instanceof ButtonModel) {
                object = (ButtonModel)objectArray[0];
                boolean bl = object.isSelected();
                if (objectArray[2] == Boolean.TRUE) {
                    bl = !bl;
                }
                editableProperties.setProperty(string2, StoreGroup.encodeBoolean(bl, (Integer)objectArray[1]));
                continue;
            }
            if (!(objectArray[0] instanceof Document) || !this.modifiedDocuments.contains(objectArray[0])) continue;
            object = (Document)objectArray[0];
            try {
                string = object.getText(0, object.getLength());
            }
            catch (BadLocationException badLocationException) {
                string = "";
            }
            editableProperties.setProperty(string2, string);
        }
    }

    public final JToggleButton.ToggleButtonModel createToggleButtonModel(PropertyEvaluator propertyEvaluator, String string) {
        return this.createBooleanButtonModel(propertyEvaluator, string, false);
    }

    public final JToggleButton.ToggleButtonModel createInverseToggleButtonModel(PropertyEvaluator propertyEvaluator, String string) {
        return this.createBooleanButtonModel(propertyEvaluator, string, true);
    }

    public final Document createStringDocument(PropertyEvaluator propertyEvaluator, String string) {
        this.checkModelDoesNotExist(string);
        String string2 = propertyEvaluator.getProperty(string);
        if (string2 == null) {
            string2 = "";
        }
        try {
            PlainDocument plainDocument = new PlainDocument();
            plainDocument.remove(0, plainDocument.getLength());
            plainDocument.insertString(0, string2, null);
            plainDocument.addDocumentListener(this.documentListener);
            this.models.put(string, new Object[]{plainDocument});
            return plainDocument;
        }
        catch (BadLocationException badLocationException) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Bad location exception from new document.");
            }
            return new PlainDocument();
        }
    }

    private void checkModelDoesNotExist(String string) {
        if (this.models.get(string) != null) {
            throw new IllegalArgumentException("Model for property " + string + "already exists.");
        }
    }

    private final JToggleButton.ToggleButtonModel createBooleanButtonModel(PropertyEvaluator propertyEvaluator, String string, boolean bl) {
        Object object;
        this.checkModelDoesNotExist(string);
        String string2 = propertyEvaluator.getProperty(string);
        boolean bl2 = false;
        Integer n = BOOLEAN_KIND_TF;
        if (string2 != null) {
            object = string2.toLowerCase();
            if (((String)object).equals("yes") || ((String)object).equals("no")) {
                n = BOOLEAN_KIND_YN;
            } else if (((String)object).equals("on") || ((String)object).equals("off")) {
                n = BOOLEAN_KIND_ED;
            }
            if (((String)object).equals("true") || ((String)object).equals("yes") || ((String)object).equals("on")) {
                bl2 = true;
            }
        }
        object = new JToggleButton.ToggleButtonModel();
        ((JToggleButton.ToggleButtonModel)object).setSelected(bl ? !bl2 : bl2);
        this.models.put(string, new Object[]{object, n, bl});
        return object;
    }

    private static String encodeBoolean(boolean bl, Integer n) {
        if (n == BOOLEAN_KIND_ED) {
            return bl ? "on" : "off";
        }
        if (n == BOOLEAN_KIND_YN) {
            return bl ? "yes" : "no";
        }
        return bl ? "true" : "false";
    }

    private void documentModified(Document document) {
        this.modifiedDocuments.add(document);
    }

    static {
        $assertionsDisabled = !StoreGroup.class.desiredAssertionStatus();
        BOOLEAN_KIND_TF = new Integer(0);
        BOOLEAN_KIND_YN = new Integer(1);
        BOOLEAN_KIND_ED = new Integer(2);
    }
}

