/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.modules.favorites.Favorites;
import org.netbeans.modules.favorites.Tab;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.windows.WindowManager;

public final class Actions {
    private static File currentDir = null;
    static /* synthetic */ Class class$org$netbeans$modules$favorites$Actions;
    static /* synthetic */ Class class$org$netbeans$modules$favorites$Actions$View;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$favorites$Actions$Select;
    static /* synthetic */ Class class$org$netbeans$modules$favorites$Actions$Remove;
    static /* synthetic */ Class class$org$netbeans$modules$favorites$Actions$Add;

    private Actions() {
    }

    public static Action view() {
        return View.getDefault();
    }

    public static Action add() {
        return Add.getDefault();
    }

    public static Action addOnFavoritesNode() {
        return AddOnFavoritesNode.getDefault();
    }

    public static Action remove() {
        return Remove.getDefault();
    }

    public static Action select() {
        return Select.getDefault();
    }

    public static class AddOnFavoritesNode
    extends Add {
        static final long serialVersionUID = -6471284573153172312L;
        private static final AddOnFavoritesNode ADD_ON_FAVORITES_NODE = new AddOnFavoritesNode();

        public static Action getDefault() {
            return ADD_ON_FAVORITES_NODE;
        }

        public String getName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions), (String)"ACT_AddOnFavoritesNode");
        }
    }

    public static class Add
    extends NodeAction {
        static final long serialVersionUID = -6471281373153172312L;
        private static final Add ADD;
        static final /* synthetic */ boolean $assertionsDisabled;

        public static Action getDefault() {
            return ADD;
        }

        private Add() {
            this.putValue("noIconInMenu", Boolean.TRUE);
        }

        public boolean enable(Node[] nodeArray) {
            if (nodeArray == null || nodeArray.length == 0) {
                return false;
            }
            if (nodeArray.length == 1 && nodeArray[0] instanceof Favorites) {
                return true;
            }
            for (int i = 0; i < nodeArray.length; ++i) {
                DataObject dataObject = (DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? Actions.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dataObject == null) {
                    return false;
                }
                FileObject fileObject = dataObject.getPrimaryFile();
                if (fileObject != null) {
                    if (this.isInFavorites(fileObject)) {
                        return false;
                    }
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (file != null && file.getParent() == null) {
                        return false;
                    }
                }
                try {
                    if (!dataObject.getPrimaryFile().getFileSystem().isDefault()) continue;
                    return false;
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    return false;
                }
            }
            return true;
        }

        private boolean isInFavorites(FileObject fileObject) {
            DataFolder dataFolder = Favorites.getFolder();
            DataObject[] dataObjectArray = dataFolder.getChildren();
            for (int i = 0; i < dataObjectArray.length; ++i) {
                if (!(dataObjectArray[i] instanceof DataShadow) || !fileObject.equals(((DataShadow)dataObjectArray[i]).getOriginal().getPrimaryFile())) continue;
                return true;
            }
            return false;
        }

        public String getName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions), (String)"ACT_Add");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$favorites$Actions$Add == null ? (class$org$netbeans$modules$favorites$Actions$Add = Actions.class$("org.netbeans.modules.favorites.Actions$Add")) : class$org$netbeans$modules$favorites$Actions$Add);
        }

        protected void performAction(Node[] nodeArray) {
            DataFolder dataFolder = Favorites.getFolder();
            DataObject[] dataObjectArray = dataFolder.getChildren();
            ArrayList arrayList = new ArrayList();
            DataObject dataObject = null;
            Node[] nodeArray2 = nodeArray;
            try {
                if (nodeArray.length == 1 && nodeArray[0] instanceof Favorites) {
                    FileObject fileObject = Add.chooseFileObject();
                    if (fileObject == null) {
                        return;
                    }
                    nodeArray2 = new Node[]{DataObject.find((FileObject)fileObject).getNodeDelegate()};
                }
                dataObject = Add.createShadows(dataFolder, nodeArray2, arrayList);
                Add.reorderAfterAddition(dataFolder, dataObjectArray, arrayList);
                this.selectAfterAddition(dataObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            }
        }

        private static FileObject chooseFileObject() {
            int n;
            FileObject fileObject = null;
            File file = null;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setDialogTitle(NbBundle.getBundle((Class)(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions)).getString("CTL_DialogTitle"));
            jFileChooser.setApproveButtonText(NbBundle.getBundle((Class)(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions)).getString("CTL_ApproveButtonText"));
            if (currentDir != null) {
                jFileChooser.setCurrentDirectory(currentDir);
            }
            if ((n = jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow())) == 0) {
                file = jFileChooser.getSelectedFile();
                File file2 = FileUtil.normalizeFile((File)file);
                if (!file2.exists() && file2.getParentFile() != null && file2.getParentFile().exists() && file2.getName().equals(file2.getParentFile().getName())) {
                    file2 = file2.getParentFile();
                }
                if (!file2.exists()) {
                    String string = NbBundle.getMessage((Class)(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions), (String)"ERR_FileDoesNotExist", (Object)file2.getPath());
                    String string2 = NbBundle.getMessage((Class)(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions), (String)"ERR_FileDoesNotExistDlgTitle");
                    DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)string, string2, -1, 1, new Object[]{NotifyDescriptor.CLOSED_OPTION}, NotifyDescriptor.OK_OPTION));
                } else {
                    fileObject = FileUtil.toFileObject((File)file2);
                    if (!$assertionsDisabled && fileObject == null) {
                        throw new AssertionError();
                    }
                }
            }
            currentDir = jFileChooser.getCurrentDirectory();
            return fileObject;
        }

        private void selectAfterAddition(DataObject dataObject) {
            Tab tab = Tab.findDefault();
            tab.open();
            tab.requestActive();
            if (dataObject != null) {
                Node node = Favorites.getNode();
                Node[] nodeArray = tab.getExplorerManager().getRootContext().getChildren().getNodes(true);
                Node[] nodeArray2 = new Node[1];
                boolean bl = false;
                for (int i = 0; i < nodeArray.length; ++i) {
                    if (!dataObject.getName().equals(nodeArray[i].getName())) continue;
                    nodeArray2[0] = nodeArray[i];
                    bl = true;
                    break;
                }
                if (bl) {
                    SwingUtilities.invokeLater(new Runnable(this, tab, nodeArray2){
                        private final /* synthetic */ Tab val$projectsTab;
                        private final /* synthetic */ Node[] val$toSelect;
                        private final /* synthetic */ Add this$0;
                        {
                            this.this$0 = add;
                            this.val$projectsTab = tab;
                            this.val$toSelect = nodeArray;
                        }

                        public void run() {
                            try {
                                this.val$projectsTab.getExplorerManager().setExploredContextAndSelection(this.val$toSelect[0], this.val$toSelect);
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        }

        private static DataObject createShadows(DataFolder dataFolder, Node[] nodeArray, List list) {
            DataShadow dataShadow = null;
            for (int i = 0; i < nodeArray.length; ++i) {
                DataObject dataObject = (DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? Actions.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dataObject == null) continue;
                try {
                    if (dataShadow == null) {
                        dataShadow = dataObject.createShadow(dataFolder);
                        list.add(dataShadow);
                        continue;
                    }
                    list.add(dataObject.createShadow(dataFolder));
                    continue;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            return dataShadow;
        }

        private static void reorderAfterAddition(DataFolder dataFolder, DataObject[] dataObjectArray, List list) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (list.size() > 0) {
                int n;
                Object object = null;
                for (n = 0; n < dataObjectArray.length; ++n) {
                    FileObject fileObject = dataObjectArray[n].getPrimaryFile();
                    if (!"Favorites/Root.instance".equals(fileObject.getPath())) continue;
                    object = dataObjectArray[n];
                }
                if (object != null) {
                    for (n = 0; n < dataObjectArray.length; ++n) {
                        if (object.equals(dataObjectArray[n])) continue;
                        arrayList.add(dataObjectArray[n]);
                    }
                    arrayList.addAll(list);
                    arrayList.add(object);
                } else {
                    for (n = 0; n < dataObjectArray.length; ++n) {
                        arrayList.add(dataObjectArray[n]);
                    }
                    arrayList.addAll(list);
                }
                DataObject[] dataObjectArray2 = arrayList.toArray(new DataObject[arrayList.size()]);
                try {
                    dataFolder.setOrder(dataObjectArray2);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }

        protected boolean asynchronous() {
            return false;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions).desiredAssertionStatus();
            ADD = new Add();
        }
    }

    private static class Remove
    extends NodeAction {
        static final long serialVersionUID = -6471281373153172312L;
        private static final Remove REMOVE = new Remove();

        private Remove() {
        }

        public static Action getDefault() {
            return REMOVE;
        }

        public boolean enable(Node[] nodeArray) {
            if (nodeArray == null || nodeArray.length == 0) {
                return false;
            }
            for (int i = 0; i < nodeArray.length; ++i) {
                DataObject dataObject = (DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? Actions.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dataObject != null && dataObject.getFolder() == Favorites.getFolder()) continue;
                return false;
            }
            return true;
        }

        public String getName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions), (String)"ACT_Remove");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$favorites$Actions$Remove == null ? (class$org$netbeans$modules$favorites$Actions$Remove = Actions.class$("org.netbeans.modules.favorites.Actions$Remove")) : class$org$netbeans$modules$favorites$Actions$Remove);
        }

        protected void performAction(Node[] nodeArray) {
            for (int i = 0; i < nodeArray.length; ++i) {
                DataObject dataObject = (DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? Actions.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dataObject == null || dataObject.getFolder() != Favorites.getFolder()) continue;
                try {
                    dataObject.delete();
                    continue;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static class Select
    extends NodeAction {
        private static final Select SELECT = new Select();

        public static Action getDefault() {
            return SELECT;
        }

        private Select() {
            this.putValue("noIconInMenu", Boolean.TRUE);
        }

        protected void performAction(Node[] nodeArray) {
            Tab tab = Tab.findDefault();
            tab.open();
            tab.requestActive();
            tab.doSelectNode((DataObject)nodeArray[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = Actions.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject));
        }

        protected boolean enable(Node[] nodeArray) {
            return nodeArray.length == 1;
        }

        public String getName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$favorites$Actions$Select == null ? (class$org$netbeans$modules$favorites$Actions$Select = Actions.class$("org.netbeans.modules.favorites.Actions$Select")) : class$org$netbeans$modules$favorites$Actions$Select), (String)"ACT_Select_Main_Menu");
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem jMenuItem = super.getPopupPresenter();
            jMenuItem.setText(NbBundle.getMessage((Class)(class$org$netbeans$modules$favorites$Actions$Select == null ? (class$org$netbeans$modules$favorites$Actions$Select = Actions.class$("org.netbeans.modules.favorites.Actions$Select")) : class$org$netbeans$modules$favorites$Actions$Select), (String)"ACT_Select"));
            return jMenuItem;
        }

        protected String iconResource() {
            return "org/netbeans/modules/favorites/resources/actionSelect.gif";
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static class View
    extends AbstractAction
    implements HelpCtx.Provider {
        private static final View VIEW = new View();

        public View() {
            this.putValue("Name", NbBundle.getMessage((Class)(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions), (String)"ACT_View"));
            Image image = Utilities.loadImage((String)"org/netbeans/modules/favorites/resources/actionView.gif");
            this.putValue("SmallIcon", image != null ? new ImageIcon(image) : null);
        }

        public static Action getDefault() {
            return VIEW;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Tab tab = Tab.findDefault();
            tab.open();
            tab.requestActive();
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$favorites$Actions$View == null ? (class$org$netbeans$modules$favorites$Actions$View = Actions.class$("org.netbeans.modules.favorites.Actions$View")) : class$org$netbeans$modules$favorites$Actions$View);
        }
    }
}

