/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.favorites.Actions;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

final class Favorites
extends FilterNode {
    private static Node node;
    private static Node root;
    static /* synthetic */ Class class$org$openide$loaders$DataShadow;
    static /* synthetic */ Class class$org$netbeans$modules$favorites$Favorites;

    private Favorites(Node node) {
        super(node, (Children)new Chldrn(node, false));
    }

    public Image getIcon(int n) {
        return Utilities.loadImage((String)"org/netbeans/modules/favorites/resources/actionSelect.gif");
    }

    public Image getOpenedIcon(int n) {
        return Utilities.loadImage((String)"org/netbeans/modules/favorites/resources/actionSelect.gif");
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public static DataFolder getFolder() {
        try {
            FileObject fileObject = FileUtil.createFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot(), (String)"Favorites");
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            return dataFolder;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot());
        }
    }

    public static synchronized Node getNode() {
        if (node == null) {
            node = new Favorites(Favorites.getFolder().getNodeDelegate());
        }
        return node;
    }

    public static URL getHome() throws FileStateInvalidException, MalformedURLException {
        String string = System.getProperty("user.home");
        File file = new File(string);
        file = FileUtil.normalizeFile((File)file);
        return file.toURI().toURL();
    }

    static File fileForNode(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return null;
        }
        return FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
    }

    public Node.Handle getHandle() {
        return new RootHandle();
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{Actions.addOnFavoritesNode()};
    }

    private static class ProjectFilterNode
    extends FilterNode {
        public ProjectFilterNode(Node node, Children children) {
            super(node, children);
        }

        public String getDisplayName() {
            if (Favorites.getNode().equals((Object)this.getParentNode())) {
                DataShadow dataShadow = (DataShadow)this.getCookie(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = Favorites.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow);
                if (dataShadow != null) {
                    String string = dataShadow.getOriginal().getName();
                    String string2 = FileUtil.getFileDisplayName((FileObject)dataShadow.getOriginal().getPrimaryFile());
                    return NbBundle.getMessage((Class)(class$org$netbeans$modules$favorites$Favorites == null ? (class$org$netbeans$modules$favorites$Favorites = Favorites.class$("org.netbeans.modules.favorites.Favorites")) : class$org$netbeans$modules$favorites$Favorites), (String)"CTL_DisplayNameTemplate", (Object)string, (Object)string2);
                }
                return super.getDisplayName();
            }
            return super.getDisplayName();
        }

        public String getHtmlDisplayName() {
            return this.getOriginal().getHtmlDisplayName();
        }

        public boolean canDestroy() {
            boolean bl = super.canDestroy();
            DataShadow dataShadow = (DataShadow)this.getCookie(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = Favorites.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow);
            if (bl && this.isDeleteOriginal(dataShadow)) {
                bl = dataShadow.getOriginal().isDeleteAllowed();
            }
            return bl;
        }

        public void destroy() throws IOException {
            if (this.canDestroy()) {
                DataShadow dataShadow = (DataShadow)this.getCookie(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = Favorites.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow);
                DataObject dataObject = this.isDeleteOriginal(dataShadow) ? dataShadow.getOriginal() : null;
                super.destroy();
                if (dataObject != null) {
                    dataObject.delete();
                }
            }
        }

        private boolean isDeleteOriginal(DataShadow dataShadow) {
            return false;
        }

        public Action[] getActions(boolean bl) {
            File file;
            FileObject fileObject;
            Action[] actionArray = super.getActions(bl);
            boolean bl2 = false;
            DataObject dataObject = (DataObject)this.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = Favorites.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (dataObject != null && (fileObject = dataObject.getPrimaryFile()) != null && (file = FileUtil.toFile((FileObject)fileObject)) != null && file.getParent() == null) {
                bl2 = true;
            }
            if (bl2) {
                return this.createActionsForRoot(actionArray);
            }
            if (Favorites.getNode().equals((Object)this.getParentNode())) {
                fileObject = (DataShadow)this.getCookie(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = Favorites.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow);
                if (fileObject != null) {
                    if (fileObject.getOriginal().getPrimaryFile().isFolder()) {
                        return this.createActionsForFavoriteFolder(actionArray);
                    }
                    return this.createActionsForFavoriteFile(actionArray);
                }
            } else {
                fileObject = (DataObject)this.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = Favorites.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                if (fileObject != null) {
                    if (fileObject.getPrimaryFile().isFolder()) {
                        return this.createActionsForFolder(actionArray);
                    }
                    return this.createActionsForFile(actionArray);
                }
            }
            return actionArray;
        }

        private Action[] createActionsForRoot(Action[] actionArray) {
            return actionArray;
        }

        private Action[] createActionsForFavoriteFolder(Action[] actionArray) {
            boolean bl = false;
            ArrayList<Action> arrayList = new ArrayList<Action>();
            for (int i = 0; i < actionArray.length; ++i) {
                if (!bl && (actionArray[i] instanceof CopyAction || actionArray[i] instanceof CutAction)) {
                    bl = true;
                    arrayList.add(Actions.remove());
                    arrayList.add(null);
                }
                if (actionArray[i] instanceof DeleteAction) continue;
                arrayList.add(actionArray[i]);
            }
            if (!bl) {
                bl = true;
                arrayList.add(null);
                arrayList.add(Actions.remove());
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private Action[] createActionsForFavoriteFile(Action[] actionArray) {
            boolean bl = false;
            ArrayList<Action> arrayList = new ArrayList<Action>();
            for (int i = 0; i < actionArray.length; ++i) {
                if (!bl && (actionArray[i] instanceof CopyAction || actionArray[i] instanceof CutAction)) {
                    bl = true;
                    arrayList.add(Actions.remove());
                    arrayList.add(null);
                }
                if (actionArray[i] instanceof DeleteAction) continue;
                arrayList.add(actionArray[i]);
            }
            if (!bl) {
                bl = true;
                arrayList.add(null);
                arrayList.add(Actions.remove());
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private Action[] createActionsForFolder(Action[] actionArray) {
            boolean bl = false;
            ArrayList<Action> arrayList = new ArrayList<Action>();
            for (int i = 0; i < actionArray.length; ++i) {
                if (!bl && (actionArray[i] instanceof CopyAction || actionArray[i] instanceof CutAction)) {
                    bl = true;
                    arrayList.add(Actions.add());
                    arrayList.add(null);
                }
                arrayList.add(actionArray[i]);
            }
            if (!bl) {
                bl = true;
                arrayList.add(null);
                arrayList.add(Actions.add());
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private Action[] createActionsForFile(Action[] actionArray) {
            boolean bl = false;
            ArrayList<Action> arrayList = new ArrayList<Action>();
            for (int i = 0; i < actionArray.length; ++i) {
                if (!bl && (actionArray[i] instanceof CopyAction || actionArray[i] instanceof CutAction)) {
                    bl = true;
                    arrayList.add(Actions.add());
                    arrayList.add(null);
                }
                arrayList.add(actionArray[i]);
            }
            if (!bl) {
                bl = true;
                arrayList.add(null);
                arrayList.add(Actions.add());
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }
    }

    private static class Chldrn
    extends FilterNode.Children
    implements ChangeListener,
    Runnable {
        private ChangeListener weak;
        private boolean hideHidden;

        public Chldrn(Node node, boolean bl) {
            super(node);
            this.hideHidden = bl;
            this.weak = WeakListeners.change((ChangeListener)this, (Object)VisibilityQuery.getDefault());
            VisibilityQuery.getDefault().addChangeListener(this.weak);
        }

        protected Node[] createNodes(Object object) {
            DataObject dataObject;
            Node node = (Node)object;
            if (this.hideHidden && (dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = Favorites.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)) != null && !VisibilityQuery.getDefault().isVisible(dataObject.getPrimaryFile())) {
                return null;
            }
            return new Node[]{new ProjectFilterNode(node, (Children)(node.isLeaf() ? Children.LEAF : new Chldrn(node, true)))};
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MUTEX.postWriteRequest((Runnable)this);
        }

        public void run() {
            Node[] nodeArray = this.original.getChildren().getNodes();
            for (int i = 0; i < nodeArray.length; ++i) {
                this.refreshKey(nodeArray[i]);
            }
        }
    }

    private static class RootHandle
    implements Node.Handle {
        static final long serialVersionUID = 1907300072945111595L;

        private RootHandle() {
        }

        public Node getNode() {
            return Favorites.getNode();
        }
    }
}

