/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot;

import com.installshield.boot.CoreMetaInf;
import com.installshield.boot.CoreZipUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AssemblyInf
extends CoreMetaInf {
    public static final String RESOURCE_NAME = "assembly.inf";
    public static final String ASSEMBLY_UUID = "UUID";
    public static final String ASSEMBLY_VERSION = "VERSION";
    public static final String ASSEMBLY_NAME = "NAME";
    public static final String INSTALL_PRECEDENCE = "INST_PRECEDENCE";
    public static final String UNINSTALL_PRECEDENCE = "UNINST_PRECEDENCE";
    public static final String DEPENDENCY_COUNT = "DEP_COUNT";
    public static final String DEPENDENCY_TAG = "DEP";
    public static final String DEPENDENCY_INFO_SEPARATOR = ";";
    public static final String LOCALE_INFO = "LOCALE";
    public static final String PLATFORM_INFO = "PLATFORM";
    public static final String ALLOWED_INSTANCES = "ALLOWED_INSTANCES";
    public static final String DEFAULT_ASSEMBLY_UUID = "";
    public static final String DEFAULT_ASSEMBLY_VERSION = "";
    public static final String DEFAULT_ASSEMBLY_NAME = "";
    public static final int DEFAULT_INSTALL_PRECEDENCE = -1;
    public static final int DEFAULT_UNINSTALL_PRECEDENCE = -1;
    public static final String DEFAULT_LOCALE_INFO = "";
    public static final String DEFAULT_PLATFORM_INFO = "";
    public static final int DEFAULT_ALLOWED_INSTANCES = -1;
    private String uuid;
    private String version;
    private String name;
    private int installPrecedence;
    private int uninstallPrecedence;
    private Vector dependencyUUIDs;
    private Vector dependencyVersions;
    private Vector dependencyNames;
    private String locale;
    private String platforms;
    private int allowedInstances;

    public static AssemblyInf createAssemblyInf(String string) throws IOException {
        File file;
        AssemblyInf assemblyInf = null;
        File file2 = new File(string);
        if (file2.isFile()) {
            ZipFile zipFile = new ZipFile(file2);
            ZipEntry zipEntry = zipFile.getEntry(CoreZipUtils.cleanZipEntry(RESOURCE_NAME));
            if (zipEntry != null) {
                assemblyInf = new AssemblyInf(CoreZipUtils.createZipInputStream(zipFile.getInputStream(zipEntry)));
            }
            zipFile.close();
        } else if (file2.isDirectory() && (file = new File(string, RESOURCE_NAME)).isFile()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            assemblyInf = new AssemblyInf(fileInputStream);
            fileInputStream.close();
        }
        if (assemblyInf == null) {
            throw new FileNotFoundException("cannot find assembly.inf in " + string);
        }
        return assemblyInf;
    }

    public AssemblyInf() {
        this.initializeDefaults();
    }

    public AssemblyInf(URL uRL) throws IOException {
        super(uRL);
    }

    public AssemblyInf(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    private void initializeDefaults() {
        this.uuid = "";
        this.version = "";
        this.name = "";
        this.installPrecedence = -1;
        this.uninstallPrecedence = -1;
        this.locale = "";
        this.platforms = "";
        this.dependencyUUIDs = new Vector();
        this.dependencyVersions = new Vector();
        this.dependencyNames = new Vector();
        this.allowedInstances = -1;
    }

    public void read(Dictionary dictionary) {
        this.initializeDefaults();
        if (dictionary.get(ASSEMBLY_UUID) != null) {
            this.uuid = (String)dictionary.get(ASSEMBLY_UUID);
        }
        if (dictionary.get(ASSEMBLY_VERSION) != null) {
            this.version = (String)dictionary.get(ASSEMBLY_VERSION);
        }
        if (dictionary.get(ASSEMBLY_NAME) != null) {
            this.name = (String)dictionary.get(ASSEMBLY_NAME);
        }
        if (dictionary.get(INSTALL_PRECEDENCE) != null) {
            this.installPrecedence = Integer.parseInt((String)dictionary.get(INSTALL_PRECEDENCE));
        }
        if (dictionary.get(UNINSTALL_PRECEDENCE) != null) {
            this.uninstallPrecedence = Integer.parseInt((String)dictionary.get(UNINSTALL_PRECEDENCE));
        }
        if (dictionary.get(DEPENDENCY_COUNT) != null) {
            int n = Integer.parseInt((String)dictionary.get(DEPENDENCY_COUNT));
            int n2 = 0;
            while (n2 < n) {
                String string = (String)dictionary.get("DEP." + n2);
                if (string != null && string.trim().length() != 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, DEPENDENCY_INFO_SEPARATOR);
                    String string2 = stringTokenizer.nextToken();
                    String string3 = "";
                    String string4 = "";
                    if (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken();
                    }
                    this.dependencyUUIDs.addElement(string2);
                    this.dependencyVersions.addElement(string3);
                    this.dependencyNames.addElement(string4);
                }
                ++n2;
            }
        }
        if (dictionary.get(LOCALE_INFO) != null) {
            this.locale = (String)dictionary.get(LOCALE_INFO);
        }
        if (dictionary.get(PLATFORM_INFO) != null) {
            this.platforms = (String)dictionary.get(PLATFORM_INFO);
        }
        if (dictionary.get(ALLOWED_INSTANCES) != null) {
            this.allowedInstances = Integer.parseInt((String)dictionary.get(ALLOWED_INSTANCES));
        }
    }

    public String getFileName() {
        return RESOURCE_NAME;
    }

    public void write(OutputStream outputStream) throws IOException {
        Properties properties = new Properties();
        ((Hashtable)properties).put(ASSEMBLY_NAME, this.name);
        ((Hashtable)properties).put(ASSEMBLY_UUID, this.uuid);
        ((Hashtable)properties).put(ASSEMBLY_VERSION, this.version);
        ((Hashtable)properties).put(INSTALL_PRECEDENCE, "" + this.installPrecedence);
        ((Hashtable)properties).put(UNINSTALL_PRECEDENCE, "" + this.uninstallPrecedence);
        int n = this.getDependencyCount();
        ((Hashtable)properties).put(DEPENDENCY_COUNT, "" + n);
        int n2 = 0;
        while (n2 < n) {
            ((Hashtable)properties).put("DEP." + n2, this.getDependencyUUID(n2) + DEPENDENCY_INFO_SEPARATOR + this.getDependencyVersion(n2) + DEPENDENCY_INFO_SEPARATOR + this.getDependencyName(n2));
            ++n2;
        }
        ((Hashtable)properties).put(LOCALE_INFO, this.locale);
        ((Hashtable)properties).put(PLATFORM_INFO, this.platforms);
        ((Hashtable)properties).put(ALLOWED_INSTANCES, "" + this.allowedInstances);
        properties.store(outputStream, "Assembly Properties");
    }

    public void setAssemblyUUID(String string) {
        this.uuid = string;
    }

    public String getAssemblyUUID() {
        return this.uuid;
    }

    public void setAssemblyName(String string) {
        this.name = string;
    }

    public String getAssemblyName() {
        return this.name;
    }

    public void setAssemblyVersion(String string) {
        this.version = string;
    }

    public String getAssemblyVersion() {
        return this.version;
    }

    public void setInstallPrecedence(int n) {
        this.installPrecedence = n;
    }

    public int getInstallPrecedence() {
        return this.installPrecedence;
    }

    public void setUninstallPrecedence(int n) {
        this.uninstallPrecedence = n;
    }

    public int getUninstallPrecedence() {
        return this.uninstallPrecedence;
    }

    public void addDependency(String string, String string2, String string3) {
        if (string != null) {
            this.dependencyUUIDs.addElement(string);
            if (string2 != null) {
                this.dependencyVersions.addElement(string2);
            } else {
                this.dependencyVersions.addElement("");
            }
            if (string3 != null) {
                this.dependencyNames.addElement(string3);
            } else {
                this.dependencyNames.addElement("");
            }
        }
    }

    public int getDependencyCount() {
        return this.dependencyUUIDs.size();
    }

    public String getDependencyUUID(int n) {
        return (String)this.dependencyUUIDs.elementAt(n);
    }

    public String getDependencyVersion(int n) {
        return (String)this.dependencyVersions.elementAt(n);
    }

    public String getDependencyName(int n) {
        return (String)this.dependencyNames.elementAt(n);
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String string) {
        if (string != null) {
            this.locale = string;
        }
    }

    public String getPlatforms() {
        return this.platforms;
    }

    public void setPlatforms(String string) {
        if (string != null) {
            this.platforms = string;
        }
    }

    public int getAllowedInstances() {
        return this.allowedInstances;
    }

    public void setAllowedInstances(int n) {
        this.allowedInstances = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UUID: " + this.uuid + "\n");
        stringBuffer.append("VERSION: " + this.version + "\n");
        stringBuffer.append("NAME: " + this.name + "\n");
        stringBuffer.append("INST_PRECEDENCE: " + this.installPrecedence + "\n");
        stringBuffer.append("UNINST_PRECEDENCE: " + this.uninstallPrecedence + "\n");
        int n = this.getDependencyCount();
        stringBuffer.append("DEP_COUNT: " + n + "\n");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("DEP." + n2 + ": " + this.getDependencyUUID(n2) + DEPENDENCY_INFO_SEPARATOR + this.getDependencyVersion(n2) + DEPENDENCY_INFO_SEPARATOR + this.getDependencyName(n2) + "\n");
            ++n2;
        }
        stringBuffer.append("LOCALE: " + this.locale + "\n");
        stringBuffer.append("PLATFORM: " + this.platforms + "\n");
        stringBuffer.append("ALLOWED_INSTANCES: " + this.allowedInstances + "\n");
        return stringBuffer.toString();
    }
}

