/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot;

import com.installshield.boot.AssemblyInf;
import com.installshield.boot.AssemblyMediaInfo;
import com.installshield.boot.BootException;
import com.installshield.boot.BootInf;
import com.installshield.boot.BootResourceCache;
import com.installshield.boot.Bootstrap;
import com.installshield.boot.BootstrapInfo;
import com.installshield.boot.CoreFileUtils;
import com.installshield.boot.CoreURLUtils;
import com.installshield.boot.EngineUtils;
import com.installshield.boot.ISMPClassLoader;
import com.installshield.boot.SetupCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class BootMain {
    private static final String DEBUG_TAG = "is.debug";
    private static final String FORCE_CL_CMD_TAG = "-enginehome";
    private static final String FORCE_DATA_CMD_TAG = "-datahome";
    private static final String INSTALL_ONLY_TAG = "-installengine";
    private static final String FORCE_ENGINE_INSTALL_TAG = "-force";
    private static final String ADD_SEARCH_PATH_TAG = "-searchpath";
    private static final String SILENT_MODE_TAG = "-silent";
    private static final String CONSOLE_MODE_TAG = "-console";
    private static final String SWING_MODE_TAG = "-swing";
    protected static final int SILENT_MODE = 0;
    protected static final int CONSOLE_MODE = 1;
    protected static final int SWING_MODE = 2;
    private String[] cmdLineArgs = new String[0];
    private String home = null;
    private String mediaHome = null;
    private String archive = null;
    private URL runInfURL = null;
    private BootInf bootInf = null;
    private String externalHome = null;
    private boolean canInstallEngine = false;
    private boolean installEngineOnly = false;
    private boolean forceEngineInstall = false;
    private List externalClassJars = new ArrayList();
    private int uiMode = 2;
    private ISMPClassLoader classLoader = null;
    private BootResourceCache bootResCache = null;
    static /* synthetic */ Class class$com$installshield$boot$BootMain;

    private static void exitWithError(int n, String string) {
        System.err.println(string);
        System.exit(n);
    }

    private static void exitWithError(int n, String string, Exception exception) {
        System.err.println(string);
        if (System.getProperty(DEBUG_TAG) != null) {
            exception.printStackTrace();
        }
        System.exit(n);
    }

    private static void processSearchPath(String string, SetupCache setupCache, List list) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = CoreFileUtils.normalizeFileName(stringTokenizer.nextToken());
            File file = new File(string2);
            if (file.exists() && file.isDirectory()) {
                String[] stringArray = SetupCache.availableInstallDataFiles(string2);
                int n = 0;
                while (stringArray != null && n < stringArray.length) {
                    list.add(stringArray[n]);
                    try {
                        AssemblyInf assemblyInf = AssemblyInf.createAssemblyInf(stringArray[n]);
                        String string3 = CoreFileUtils.getParent(stringArray[n]);
                        String string4 = CoreFileUtils.createFileName(string3, "media.map");
                        AssemblyMediaInfo assemblyMediaInfo = null;
                        assemblyMediaInfo = new File(string4).exists() && new File(string4).isFile() ? new AssemblyMediaInfo(string3, null, stringArray[n]) : new AssemblyMediaInfo(stringArray[n], null, stringArray[n]);
                        SetupCache.getSetupCache().addAssemblyMediaInfo(assemblyInf.getAssemblyUUID(), assemblyInf.getAssemblyVersion(), assemblyMediaInfo);
                    }
                    catch (Exception exception) {
                        System.out.println("invalid search path: " + string2);
                    }
                    ++n;
                }
                setupCache.addInstallDataSearchPath(string2);
                continue;
            }
            System.out.println("invalid search path: " + string2);
        }
    }

    private static boolean unpackInstallData(String string, String string2, String string3, List list) {
        boolean bl;
        block8: {
            bl = true;
            try {
                String string4 = CoreFileUtils.appendSeparator(string3) + "assembly.dat";
                String string5 = CoreFileUtils.appendSeparator(string3) + "resource.map";
                File file = new File(string4);
                File file2 = new File(string5);
                if (file.exists() && !file.delete()) {
                    throw new IOException("could not delete install data file: " + string4);
                }
                if (file2.exists() && !file2.delete()) {
                    throw new IOException("could not delete resource map file: " + string5);
                }
                String string6 = CoreFileUtils.appendSeparator(string2) + "assembly.dat";
                String string7 = CoreFileUtils.appendSeparator(string2) + "resource.map";
                try {
                    BootResourceCache.extractResourceFromArchive(string, string6, string4);
                    list.add(string4);
                }
                catch (IOException iOException) {
                    throw new IOException("could not locate install data file: " + string6);
                }
                try {
                    BootResourceCache.extractResourceFromArchive(string, string7, string5);
                }
                catch (IOException iOException) {}
            }
            catch (Exception exception) {
                bl = false;
                if (System.getProperty(DEBUG_TAG) == null) break block8;
                System.err.println("could not unpack assembly (" + string2 + ") to target (" + string3 + ")");
                exception.printStackTrace();
            }
        }
        return bl;
    }

    private void configureMediaLocation(String string, String string2, String string3, String string4, String string5) {
        String string6 = CoreFileUtils.appendSeparator(string5) + "assembly.dat";
        try {
            String string7 = CoreFileUtils.appendSeparator(string4) + "media.map";
            AssemblyMediaInfo assemblyMediaInfo = null;
            if (BootResourceCache.resourceExistsInArchive(string, string7)) {
                assemblyMediaInfo = new AssemblyMediaInfo(string, string4, string6);
            } else if (!this.bootInf.isSpanned()) {
                assemblyMediaInfo = new AssemblyMediaInfo(string6, null, string6);
            }
            SetupCache.getSetupCache().addAssemblyMediaInfo(string2, string3, assemblyMediaInfo);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static String[] stripArguments(String[] stringArray, int n, int n2) {
        String[] stringArray2 = stringArray;
        if (stringArray != null && stringArray.length > 0 && n2 > 0 && n >= 0) {
            if (n == 0 && n2 == stringArray.length) {
                stringArray2 = new String[]{};
            } else if (n + n2 <= stringArray.length) {
                stringArray2 = new String[stringArray.length - n2];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                if (n + n2 < stringArray.length) {
                    System.arraycopy(stringArray, n + n2, stringArray2, n, stringArray.length - (n + n2));
                }
            }
        }
        return stringArray2;
    }

    protected String[] getCommandLineArguments() {
        return this.cmdLineArgs;
    }

    protected String getHome() {
        return this.home;
    }

    protected String getMediaHome() {
        return this.mediaHome;
    }

    protected String getArchive() {
        return this.archive;
    }

    protected URL getRunInfURL() {
        return this.runInfURL;
    }

    protected BootInf getBootInf() {
        return this.bootInf;
    }

    protected String getExternalHome() {
        return this.externalHome;
    }

    protected boolean getCanInstallEngine() {
        return this.canInstallEngine;
    }

    protected boolean isInstallEngineOnly() {
        return this.installEngineOnly;
    }

    protected boolean isForceEngineInstall() {
        return this.forceEngineInstall;
    }

    protected List getExternalClassJars() {
        return this.externalClassJars;
    }

    protected int getUIMode() {
        return this.uiMode;
    }

    protected ISMPClassLoader getISMPClassLoader() throws BootException {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        throw new BootException("ismp class loader unavailable: class loader not yet initialized");
    }

    protected BootResourceCache getBootResourceCache() {
        return this.bootResCache;
    }

    public void boot(String[] stringArray) {
        URL uRL;
        Object object;
        Object object2;
        String string;
        Object object3;
        Object object4;
        block110: {
            String string2;
            String string3;
            Object object5;
            String string4;
            String string5;
            String string6;
            String string7;
            this.cmdLineArgs = stringArray;
            this.home = null;
            this.mediaHome = null;
            this.archive = null;
            this.runInfURL = null;
            this.bootInf = null;
            String string8 = System.getProperty("java.class.path");
            StringTokenizer stringTokenizer = new StringTokenizer(string8, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens() && this.runInfURL == null) {
                String string9 = stringTokenizer.nextToken();
                try {
                    this.runInfURL = new URL("archive", "", -1, CoreURLUtils.encodeArchiveURLPath(string9 + "+/" + "run.inf"));
                    object4 = this.runInfURL.openStream();
                    ((InputStream)object4).close();
                    this.home = new File(string9).getAbsolutePath();
                    string7 = CoreFileUtils.getParent(this.home);
                    string6 = CoreFileUtils.getParent(this.home);
                    string5 = CoreFileUtils.createFileName(string6, "run.inf");
                    object3 = new File(string5);
                    if (((File)object3).exists() && ((File)object3).isFile()) {
                        this.runInfURL = new URL("archive", "", -1, CoreURLUtils.encodeArchiveURLPath(string6 + "+/" + "run.inf"));
                    }
                    this.bootInf = this.loadBootInf(this.runInfURL);
                    this.mediaHome = string7;
                    this.archive = this.home;
                }
                catch (Exception exception) {
                    if (System.getProperty(DEBUG_TAG) != null) {
                        exception.printStackTrace();
                    }
                    this.runInfURL = null;
                    this.bootInf = null;
                    this.home = null;
                    this.mediaHome = null;
                    this.archive = null;
                }
            }
            if (this.bootInf == null) {
                BootMain.exitWithError(-1, "cannot find \"run.inf\"");
            }
            this.externalHome = System.getProperty("is.external.home");
            if (this.externalHome == null) {
                this.externalHome = this.mediaHome;
                System.setProperty("is.external.home", this.externalHome);
            }
            if (System.getProperty(DEBUG_TAG) != null) {
                System.out.println("*** START BOOTINF (" + this.runInfURL.toExternalForm() + ") ***");
                System.out.println(this.bootInf.toString());
                System.out.println("*** END BOOTINF ***");
            }
            this.uiMode = 2;
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(CONSOLE_MODE_TAG)) {
                    this.uiMode = 1;
                    break;
                }
                if (stringArray[n].equals(SILENT_MODE_TAG)) {
                    this.uiMode = 0;
                    break;
                }
                if (stringArray[n].equals(SWING_MODE_TAG)) break;
                ++n;
            }
            object4 = this.bootInf.getStartClass();
            if (object4 == null || ((String)object4).length() == 0) {
                BootMain.exitWithError(-1, "start class not specified in \"run.inf\"");
            }
            if ((string7 = this.bootInf.getEngineVersion()) == null || string7.length() == 0) {
                BootMain.exitWithError(-1, "engine version not specified in \"run.inf\"");
            }
            this.canInstallEngine = false;
            string6 = null;
            string5 = this.bootInf.getInstallResourcePath();
            if (string5 != null && string5.trim().length() != 0) {
                this.bootResCache = this.createBootResourceCache(string5);
                this.canInstallEngine = true;
                string6 = this.bootResCache.getRelEngineJarPath();
            }
            if ((object3 = this.bootInf.getRootUUID()) == null || ((String)object3).trim().length() == 0) {
                BootMain.exitWithError(-1, "no UUID given for root product");
            }
            if ((string = this.bootInf.getRootVersion()) == null || string.trim().length() == 0) {
                BootMain.exitWithError(-1, "no version given for root product: " + (String)object3);
            }
            int n2 = this.bootInf.getInstallDataCount();
            boolean bl = false;
            String string10 = null;
            String string11 = this.bootInf.getRootDataLocation();
            if (string11 != null && string11.trim().length() > 0) {
                string10 = CoreFileUtils.canonizePath(CoreFileUtils.createFileName(this.mediaHome, string11));
            }
            int n3 = 0;
            while (n3 < n2 && !bl) {
                String string12;
                String string13 = this.bootInf.getInstallDataUUID(n3);
                if (string13 == null || string13.trim().length() == 0) {
                    BootMain.exitWithError(-1, "no UUID given for install data[" + n3 + "]");
                }
                if ((string12 = this.bootInf.getInstallDataVersion(n3)) == null || string12.trim().length() == 0) {
                    BootMain.exitWithError(-1, "no version given for install data[" + n3 + "]: " + string13);
                }
                if (string13.equals(object3) && string12.equals(string)) {
                    bl = true;
                }
                ++n3;
            }
            if (!(bl || string10 != null && string10.trim().length() != 0)) {
                BootMain.exitWithError(-1, "root product data not found in archive: " + (String)object3 + "[" + string + "]");
            }
            this.installEngineOnly = false;
            int n4 = 0;
            while (!this.installEngineOnly && n4 < stringArray.length) {
                if (stringArray[n4].equals(INSTALL_ONLY_TAG)) {
                    this.installEngineOnly = true;
                    stringArray = BootMain.stripArguments(stringArray, n4, 1);
                }
                ++n4;
            }
            this.forceEngineInstall = false;
            int n5 = 0;
            while (!this.forceEngineInstall && n5 < stringArray.length) {
                if (stringArray[n5].equals(FORCE_ENGINE_INSTALL_TAG)) {
                    this.forceEngineInstall = true;
                    stringArray = BootMain.stripArguments(stringArray, n5, 1);
                }
                ++n5;
            }
            if (this.forceEngineInstall && !this.canInstallEngine) {
                BootMain.exitWithError(-1, "forced engine install can only be run from source media");
            }
            String string14 = null;
            int n6 = 0;
            while (n6 < stringArray.length) {
                if (stringArray[n6].equals(FORCE_CL_CMD_TAG)) {
                    if (stringArray.length > n6 + 1) {
                        string14 = CoreFileUtils.normalizeFileName(stringArray[n6 + 1]);
                        stringArray = BootMain.stripArguments(stringArray, n6, 2);
                    } else {
                        BootMain.exitWithError(-1, "path for engine home not specified");
                    }
                }
                ++n6;
            }
            if ((string14 == null || string14.trim().length() == 0) && (string4 = this.bootInf.getEngineLocation()) != null && string4.trim().length() > 0) {
                string14 = CoreFileUtils.canonizePath(CoreFileUtils.createFileName(this.mediaHome, string4));
            }
            if (string14 == null || string14.trim().length() == 0) {
                try {
                    string14 = CoreFileUtils.normalizeFileName(CoreFileUtils.createTempDir());
                }
                catch (Exception exception) {
                    if (System.getProperty(DEBUG_TAG) != null) {
                        exception.printStackTrace();
                    }
                    string14 = null;
                }
            }
            if (string14 == null || string14.trim().length() == 0) {
                BootMain.exitWithError(-1, "could not determine central location: use \"-enginehome\" to set manually");
            }
            string4 = null;
            int n7 = 0;
            while ((string4 == null || string4.trim().length() == 0) && n7 < stringArray.length) {
                if (stringArray[n7].equals(FORCE_DATA_CMD_TAG)) {
                    if (stringArray.length > n7 + 1) {
                        string4 = CoreFileUtils.normalizeFileName(stringArray[n7 + 1]);
                        stringArray = BootMain.stripArguments(stringArray, n7, 2);
                    } else {
                        BootMain.exitWithError(-1, "path for install data home not specified");
                    }
                }
                ++n7;
            }
            if (string4 == null || string4.trim().length() == 0) {
                try {
                    string4 = CoreFileUtils.normalizeFileName(CoreFileUtils.createTempDir());
                }
                catch (Exception exception) {
                    if (System.getProperty(DEBUG_TAG) != null) {
                        exception.printStackTrace();
                    }
                    string4 = null;
                }
            }
            if (string4 == null || string4.trim().length() == 0) {
                BootMain.exitWithError(-1, "could not determine install data location: use \"-datahome\" to set manually");
            }
            this.initializeSetupCache(this.mediaHome, this.archive, this.externalHome, string7, string14, string4);
            try {
                this.preCoreInitialize();
            }
            catch (BootException bootException) {
                BootMain.exitWithError(-1, bootException.getMessage(), bootException);
            }
            SetupCache setupCache = SetupCache.getSetupCache();
            String string15 = setupCache.getEngineJar();
            if (!new File(string14).exists()) {
                if (this.canInstallEngine) {
                    try {
                        CoreFileUtils.createDirs(new File(string14));
                    }
                    catch (Exception exception) {
                        BootMain.exitWithError(-1, "could not create engine location: " + string14, exception);
                    }
                } else {
                    BootMain.exitWithError(-1, "engine is missing (" + string14 + "): run installation from source media");
                }
            }
            this.externalClassJars = new ArrayList();
            if (this.canInstallEngine) {
                try {
                    EngineUtils.installEngine(this.home, string7, string6, this.forceEngineInstall, string15);
                }
                catch (Exception exception) {
                    BootMain.exitWithError(-1, "could not install engine jar", exception);
                }
            } else if (!new File(string15).exists()) {
                BootMain.exitWithError(-1, "run installation from source media: engine is missing: " + string15);
            }
            this.externalClassJars.add(string15);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n8 = 0;
            while (n8 < this.bootInf.getLibraryJarCount()) {
                block108: {
                    String string16 = this.bootInf.getRelativeLibraryJar(n8);
                    object5 = setupCache.getLibraryJar(string16);
                    if (this.canInstallEngine) {
                        string3 = this.bootResCache.getRelLibraryJarPath(string16);
                        try {
                            EngineUtils.installEngineLibrary(this.home, string3, (String)object5);
                            arrayList.add(object5);
                            this.externalClassJars.add(object5);
                        }
                        catch (IOException iOException) {
                            if (System.getProperty(DEBUG_TAG) != null) {
                                System.err.println("could not install engine extension (" + string3 + ")");
                                iOException.printStackTrace();
                                break block108;
                            }
                            System.err.println("could not install engine extension (" + string3 + "): run with \"" + DEBUG_TAG + "\" for more information");
                        }
                    } else if (new File((String)object5).exists()) {
                        arrayList.add(object5);
                        this.externalClassJars.add(object5);
                    } else if (System.getProperty(DEBUG_TAG) != null) {
                        System.err.println("invalid installed engine extension: " + (String)object5);
                    }
                }
                ++n8;
            }
            int n9 = 0;
            while (n9 < this.bootInf.getExtensionJarCount()) {
                block109: {
                    object5 = this.bootInf.getRelativeExtensionJar(n9);
                    string3 = setupCache.getEngineExtensionJar((String)object5);
                    if (this.canInstallEngine) {
                        string2 = this.bootResCache.getRelEngineExtensionJarPath((String)object5);
                        try {
                            EngineUtils.installEngineExtension(string7, this.home, string2, string3);
                            arrayList.add(string3);
                            this.externalClassJars.add(string3);
                        }
                        catch (IOException iOException) {
                            if (System.getProperty(DEBUG_TAG) != null) {
                                System.err.println("could not install engine extension (" + string2 + ")");
                                iOException.printStackTrace();
                                break block109;
                            }
                            System.err.println("could not install engine extension (" + string2 + "): run with \"" + DEBUG_TAG + "\" for more information");
                        }
                    } else if (new File(string3).exists()) {
                        arrayList.add(string3);
                        this.externalClassJars.add(string3);
                    } else if (System.getProperty(DEBUG_TAG) != null) {
                        System.err.println("invalid installed engine extension: " + string3);
                    }
                }
                ++n9;
            }
            object5 = new String[arrayList.size()];
            arrayList.toArray((T[])object5);
            if (!this.installEngineOnly) {
                int n10 = 0;
                while (n10 < stringArray.length) {
                    if (stringArray[n10].equals(ADD_SEARCH_PATH_TAG)) {
                        if (stringArray.length > n10 + 1) {
                            string2 = stringArray[n10 + 1];
                            stringArray = BootMain.stripArguments(stringArray, n10, 2);
                            BootMain.processSearchPath(string2, setupCache, this.externalClassJars);
                        } else {
                            BootMain.exitWithError(-1, "search path not specified");
                        }
                    }
                    ++n10;
                }
                string2 = setupCache.getDefaultInstallDataSearchPath();
                File file = new File(string2);
                if (file.exists() && file.isDirectory()) {
                    BootMain.processSearchPath(string2, setupCache, this.externalClassJars);
                }
                if (this.canInstallEngine) {
                    int n11 = 0;
                    while (n11 < n2) {
                        String string17;
                        object2 = this.bootInf.getInstallDataUUID(n11);
                        if (!setupCache.isInstallDataAvailable((String)object2, string17 = this.bootInf.getInstallDataVersion(n11))) {
                            object = CoreFileUtils.normalizeFileName(setupCache.getInstallDataHome((String)object2, string17));
                            String string18 = this.bootResCache.getRelInstallDataPath((String)object2, string17);
                            boolean bl2 = BootMain.unpackInstallData(this.home, string18, (String)object, this.externalClassJars);
                            if (!bl2) {
                                BootMain.exitWithError(-1, "could not unpack install data (" + object2 + "[" + string17 + "]): run with \"" + DEBUG_TAG + "\" for more information");
                            }
                            this.configureMediaLocation(this.home, (String)object2, string17, string18, (String)object);
                        }
                        ++n11;
                    }
                } else {
                    File file2;
                    if (string10 == null) {
                        BootMain.exitWithError(-1, "root location data not set");
                    }
                    if (!(file2 = new File(string10)).exists()) {
                        BootMain.exitWithError(-1, "could not locate root data location (" + string10 + ")");
                    }
                    setupCache.addInstallDataHome((String)object3, string, string10);
                    this.externalClassJars.add(setupCache.getInstallDataFileName((String)object3, string));
                }
            }
            if (!this.bootInf.isSpanned()) {
                System.setProperty("is.media.home", setupCache.getInstallDataFileName((String)object3, string));
            }
            uRL = null;
            try {
                uRL = ISMPClassLoader.createLibraryURL(setupCache.getClassHomePath());
            }
            catch (IOException iOException) {
                if (System.getProperty(DEBUG_TAG) == null) break block110;
                iOException.printStackTrace();
            }
        }
        this.classLoader = uRL != null ? new ISMPClassLoader(new URL[]{uRL}, (class$com$installshield$boot$BootMain == null ? (class$com$installshield$boot$BootMain = BootMain.class$("com.installshield.boot.BootMain")) : class$com$installshield$boot$BootMain).getClassLoader()) : new ISMPClassLoader(new URL[]{}, (class$com$installshield$boot$BootMain == null ? (class$com$installshield$boot$BootMain = BootMain.class$("com.installshield.boot.BootMain")) : class$com$installshield$boot$BootMain).getClassLoader());
        int n = this.bootInf.getAdditionalClassPathCount();
        int n12 = 0;
        while (n12 < n) {
            String string19 = this.bootInf.getAdditionalClassPath(n12);
            if (string19 != null && string19.trim().length() > 0) {
                object2 = new File(string19);
                if (((File)object2).exists()) {
                    try {
                        this.classLoader.appendLibs(new String[]{string19});
                    }
                    catch (IOException iOException) {
                        System.out.println("Additional class path caused exception: " + string19);
                    }
                } else {
                    System.out.println("Additional class path file not found: " + string19);
                }
            }
            ++n12;
        }
        try {
            this.postCoreInitialize();
        }
        catch (BootException bootException) {
            BootMain.exitWithError(-1, bootException.getMessage(), bootException);
        }
        if (!this.installEngineOnly) {
            try {
                String[] stringArray2 = new String[this.externalClassJars.size()];
                this.externalClassJars.toArray(stringArray2);
                if (System.getProperty(DEBUG_TAG) != null) {
                    object2 = new StringBuffer();
                    ((StringBuffer)object2).append("EXTERNAL CLASS JAR LIST: ");
                    int n13 = 0;
                    while (n13 < stringArray2.length) {
                        ((StringBuffer)object2).append(stringArray2[n13]);
                        if (n13 != stringArray2.length - 1) {
                            ((StringBuffer)object2).append(", ");
                        }
                        ++n13;
                    }
                    System.out.println(((StringBuffer)object2).toString());
                }
                this.classLoader.appendLibs(stringArray2);
                object2 = this.classLoader.loadClass((String)object4);
                Object obj = ((Class)object2).newInstance();
                if (obj instanceof Bootstrap) {
                    object = this.createBootstrapInfo(this.bootInf, stringArray, (String)object3, string);
                    ((Bootstrap)obj).startup((BootstrapInfo)object);
                } else {
                    BootMain.exitWithError(-1, "start class (" + (String)object4 + ") not instance of Bootstrap");
                }
            }
            catch (Exception exception) {
                BootMain.exitWithError(-1, "could not utilize start class: " + (String)object4, exception);
            }
        }
    }

    protected BootInf loadBootInf(URL uRL) throws IOException {
        return new BootInf(uRL);
    }

    protected BootResourceCache createBootResourceCache(String string) {
        return new BootResourceCache(string);
    }

    protected void initializeSetupCache(String string, String string2, String string3, String string4, String string5, String string6) {
        SetupCache.createSetupCache(string5, string6, string4, string, string2, string3);
    }

    protected void preCoreInitialize() throws BootException {
    }

    protected void postCoreInitialize() throws BootException {
    }

    protected BootstrapInfo createBootstrapInfo(BootInf bootInf, String[] stringArray, String string, String string2) {
        return new BootstrapInfo(bootInf, string, string2, stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

