/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;

public class CoreFileUtils {
    private static final boolean isFileSystemCaseSensitive;
    public static final String systemLF;
    private static Vector tempFiles;
    private static final String isjeDirName = "ismp";
    private static int count;
    private static String curTempDirectory;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("use: CoreFileUtils [options]");
            System.err.println("\noptions:\n");
            System.err.println("   -temp : prints the temporary directory for the current JVM");
        } else {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-temp")) {
                    System.out.println(CoreFileUtils.getTempDir());
                } else {
                    System.err.println("Unknown option: " + stringArray[n]);
                    System.exit(-1);
                }
                ++n;
            }
        }
    }

    public static String createTempDir() throws IOException {
        File file;
        String string = CoreFileUtils.getIsjeTempDir();
        while ((file = new File(string, CoreFileUtils.createTempDirName())).exists()) {
        }
        String[] stringArray = CoreFileUtils.createDirs(file);
        int n = 0;
        while (n < stringArray.length) {
            if (!CoreFileUtils.getTempFiles().contains(stringArray[n])) {
                CoreFileUtils.getTempFiles().addElement(stringArray[n]);
            }
            ++n;
        }
        String string2 = file.getAbsolutePath();
        return string2;
    }

    public static String createTempDirName() {
        return new Integer((int)(Math.random() * 1.0E7)).toString();
    }

    public static String createTempFile() throws IOException {
        File file;
        String string = CoreFileUtils.getIsjeTempDir();
        while ((file = new File(string, CoreFileUtils.createTempFileName())).exists()) {
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.close();
        String string2 = file.getAbsolutePath();
        tempFiles.addElement(string2);
        return string2;
    }

    public static String createTempFile(URL uRL) throws IOException {
        String string = CoreFileUtils.createTempFile();
        InputStream inputStream = uRL.openStream();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        try {
            CoreFileUtils.copy(inputStream, fileOutputStream);
            inputStream.close();
            inputStream = null;
            fileOutputStream.close();
            return string;
        }
        catch (IOException iOException) {
            CoreFileUtils.close(inputStream);
            CoreFileUtils.close(fileOutputStream);
            CoreFileUtils.deleteTempFile(string);
            throw iOException;
        }
    }

    public static String createTempFile(URL uRL, String string) throws IOException {
        String string2 = CoreFileUtils.createFileName(CoreFileUtils.getIsjeTempDir(), string);
        File file = new File(string2);
        if (file.exists()) {
            while ((file = new File(CoreFileUtils.getIsjeTempDir(), CoreFileUtils.createTempFileName())).exists()) {
            }
            if (!file.mkdirs()) {
                throw new IOException("could not create temp directory " + file.getAbsolutePath());
            }
            CoreFileUtils.getTempFiles().addElement(file.getAbsolutePath());
            file = new File(file, string);
        }
        CoreFileUtils.getTempFiles().addElement(file.getAbsolutePath());
        InputStream inputStream = uRL.openStream();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            CoreFileUtils.copy(inputStream, fileOutputStream);
            inputStream.close();
            inputStream = null;
            fileOutputStream.close();
            return file.getAbsolutePath();
        }
        catch (IOException iOException) {
            CoreFileUtils.close(inputStream);
            CoreFileUtils.close(fileOutputStream);
            CoreFileUtils.deleteTempFile(file.getAbsolutePath());
            throw iOException;
        }
    }

    public static boolean deleteTempFile(String string) {
        boolean bl = new File(string).delete();
        if (bl) {
            CoreFileUtils.getTempFiles().removeElement(string);
        }
        return bl;
    }

    public static void clearTempFiles() {
        CoreFileUtils.getTempFiles().removeAllElements();
    }

    public static void addTempFile(String string) {
        if (!CoreFileUtils.getTempFiles().contains(string)) {
            CoreFileUtils.getTempFiles().addElement(string);
        }
    }

    public static void clearTempFile(String string) {
        CoreFileUtils.getTempFiles().removeElement(string);
    }

    protected static Vector getTempFiles() {
        return tempFiles;
    }

    public static String getTempDir() {
        String string = System.getProperty("temp.dir");
        if (string == null) {
            string = System.getProperty("java.io.tmpdir");
        }
        if (string == null) {
            string = System.getProperty("user.home");
        }
        return string;
    }

    protected static String getIsjeTempDir() {
        if (curTempDirectory == null) {
            CoreFileUtils.createIsjeTempDir();
        }
        return curTempDirectory;
    }

    private static void createIsjeTempDir() {
        boolean bl = false;
        while (!bl) {
            String string = CoreFileUtils.getIsjeTempDirName();
            File file = new File(string);
            if (!file.exists()) {
                file.mkdir();
                curTempDirectory = file.getAbsolutePath();
                if (!tempFiles.contains(curTempDirectory)) {
                    tempFiles.addElement(curTempDirectory);
                }
                bl = true;
                continue;
            }
            ++count;
        }
    }

    protected static void resetCurrentTempDir() {
        curTempDirectory = null;
    }

    private static String getIsjeTempDirName() {
        String string = "";
        string = count < 10 ? "00" + count : (count >= 10 && count < 100 ? "0" + count : "" + count);
        return CoreFileUtils.appendSeparator(CoreFileUtils.getTempDir()) + isjeDirName + string;
    }

    public static String createTempFileName() {
        return (int)(Math.random() * 1.0E7) + ".tmp";
    }

    public static String[] createDirs(File file) throws IOException {
        Object object;
        Stack<File> stack = new Stack<File>();
        File file2 = file;
        while (file2 != null && !file2.exists()) {
            stack.push(file2);
            object = file2.getParent();
            File file3 = file2 = object != null ? new File((String)object) : null;
        }
        object = new Vector();
        while (!stack.isEmpty()) {
            file2 = (File)stack.pop();
            if (file2.exists()) continue;
            if (!file2.mkdir()) {
                throw new IOException("Could not create directory " + file2.getAbsolutePath());
            }
            ((Vector)object).addElement(file2.getAbsolutePath());
        }
        Object[] objectArray = new String[((Vector)object).size()];
        ((Vector)object).copyInto(objectArray);
        return objectArray;
    }

    public static String createFileName(String string, String string2) {
        if (string == null) {
            string = "";
        }
        string = string.trim();
        if (string2 == null) {
            return CoreFileUtils.normalizeFileName(string);
        }
        string2 = string2.trim();
        if (CoreFileUtils.isAbsolute(string2 = CoreFileUtils.normalizeFileName(string2))) {
            return string2;
        }
        if ((string = CoreFileUtils.normalizeFileName(string)).endsWith(File.separator)) {
            return string + string2;
        }
        return string + File.separator + string2;
    }

    public static String getParent(String string) {
        String string2 = CoreFileUtils.normalizeFileName(string);
        int n = string2.length();
        if (string2.endsWith(File.separator) && n > 1) {
            string2 = string2.substring(0, n - 1);
        }
        return new File(string2).getParent();
    }

    public static boolean isAbsolute(String string) {
        string = CoreFileUtils.normalizeFileName(string);
        File file = new File(string);
        return string.startsWith(File.separator) || file.isAbsolute();
    }

    public static String normalizeFileName(String string, char c) {
        if (string == null) {
            throw new NullPointerException("fileName cannot be null");
        }
        return string.replace('/', c).replace('\\', c);
    }

    public static String normalizeFileName(String string) {
        return CoreFileUtils.normalizeFileName(string, File.separatorChar);
    }

    public static String appendSeparator(String string) {
        return CoreFileUtils.appendSeparator(string, File.separator);
    }

    public static String appendSeparator(String string, String string2) {
        if (string.length() > 0 && !string.endsWith("/") && !string.endsWith(File.separator)) {
            return string + string2;
        }
        return string;
    }

    public static String canonizePath(String string) {
        String string2 = CoreFileUtils.normalizeFileName(string);
        String string3 = File.separator + File.separator;
        int n = string2.lastIndexOf(string3);
        while (n != -1 && n != 0) {
            string2 = string2.substring(0, n + 1) + string2.substring(n + 2);
            n = string2.lastIndexOf(string3);
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < string2.length()) {
                if (string2.charAt(n2) != File.separatorChar) {
                    stringBuffer.append(string2.charAt(n2));
                } else if (string2.length() != n2 + 1 && string2.charAt(n2 + 1) == '.') {
                    if (string2.length() == n2 + 2 || string2.charAt(n2 + 2) == File.separatorChar) {
                        ++n2;
                    } else if (string2.charAt(n2 + 2) == '.' && (string2.length() == n2 + 3 || string2.charAt(n2 + 3) == File.separatorChar)) {
                        String string4 = stringBuffer.toString();
                        String string5 = CoreFileUtils.getParent(string4);
                        if (string5 == null) {
                            string5 = string4;
                        }
                        if (string5.endsWith(File.separator)) {
                            string5 = string5.substring(0, string5.length() - 1);
                        }
                        stringBuffer = new StringBuffer(string5);
                        n2 += 2;
                        bl = true;
                    } else {
                        stringBuffer.append(string2.charAt(n2));
                    }
                } else {
                    stringBuffer.append(string2.charAt(n2));
                }
                ++n2;
            }
            string2 = stringBuffer.toString();
        }
        if (string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static boolean comparePaths(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        String string3 = CoreFileUtils.canonizePath(string);
        String string4 = CoreFileUtils.canonizePath(string2);
        if (!isFileSystemCaseSensitive) {
            return string3.equalsIgnoreCase(string4);
        }
        return string3.equals(string4);
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return CoreFileUtils.copy(16384, inputStream, outputStream);
    }

    public static int copy(int n, InputStream inputStream, OutputStream outputStream, int n2) throws IOException {
        return (int)CoreFileUtils.copy(n, inputStream, outputStream, (long)n2);
    }

    public static long copy(int n, InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        long l2 = 0L;
        int n2 = 0;
        if (l > 0L) {
            if ((long)n > l) {
                n = (int)l;
            }
            byte[] byArray = new byte[n];
            boolean bl = false;
            while (!bl && (n2 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
                long l3 = l - (l2 += (long)n2);
                if (l3 <= 0L) {
                    bl = true;
                    continue;
                }
                if (l3 >= (long)n) continue;
                n = (int)l3;
                byArray = new byte[n];
            }
        }
        return l2;
    }

    public static int copy(int n, InputStream inputStream, OutputStream outputStream) throws IOException {
        long l = 0L;
        int n2 = 0;
        byte[] byArray = new byte[n];
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            l += (long)n2;
        }
        return (int)l;
    }

    public static void close(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isFileSystemCaseSensitive() {
        return isFileSystemCaseSensitive;
    }

    static {
        tempFiles = new Vector();
        count = 1;
        curTempDirectory = null;
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows") || string.equals("OS/2")) {
            systemLF = "\r\n";
            isFileSystemCaseSensitive = false;
        } else if (string.equals("OS/400")) {
            systemLF = "\n";
            isFileSystemCaseSensitive = false;
        } else {
            systemLF = "\n";
            isFileSystemCaseSensitive = true;
        }
    }
}

