/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot;

import com.installshield.boot.CoreLocalizedStringResolver;
import com.installshield.boot.CoreTTYPrompt;
import com.installshield.boot.CoreTTYTable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class CoreTTYDisplay {
    public static final int DEFAULT_WIDTH = 79;
    private static final int DEFAULT_LINES = 20;
    public static final int DEFAULT_INDENT = 3;
    public static final int DEFAULT_TABLE_PADDING = 2;
    private PrintWriter out;
    private BufferedReader in;
    private int width;
    private int pageLineCount = 20;
    private boolean accessibilityEnabled = false;
    private int baseIndent = 0;

    public CoreTTYDisplay() {
        this(System.in, System.out, 79);
    }

    public CoreTTYDisplay(int n) {
        this(System.in, System.out, n);
    }

    public CoreTTYDisplay(InputStream inputStream, OutputStream outputStream, int n) {
        this.setStreams(inputStream, outputStream);
        this.setWidth(n);
    }

    public void setStreams(InputStream inputStream, OutputStream outputStream) {
        this.out = new PrintWriter(outputStream, true);
        this.in = new BufferedReader(new InputStreamReader(inputStream));
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public BufferedReader getReader() {
        return this.in;
    }

    public void setWidth(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("width must be greater or equal to 1");
        }
        this.width = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setBaseIndent(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("indent cannot be negative");
        }
        this.baseIndent = n;
    }

    public int getBaseIndent() {
        return this.baseIndent;
    }

    public void setPageLineCount(int n) {
        this.pageLineCount = n;
    }

    public int getPageLineCount() {
        return this.pageLineCount;
    }

    public void setAccessibilityEnabled(boolean bl) {
        this.accessibilityEnabled = bl;
    }

    public boolean isAccessibilityEnabled() {
        return this.accessibilityEnabled;
    }

    public void printLine() {
        this.out.println();
    }

    public void print(String string) {
        this.printImpl(string, 0);
    }

    public void printLine(String string) {
        this.printImpl(string, 0);
        this.printLine();
    }

    public void printIndented(String string) {
        this.printImpl(string, 3);
    }

    public void printIndentedLine(String string) {
        this.printIndented(string);
        this.printLine();
    }

    public void printIndented(String string, int n) {
        this.printImpl(string, n);
    }

    public void printIndentedLine(String string, int n) {
        this.printIndented(string, n);
        this.printLine();
    }

    private void printImpl(String string, int n) {
        n = Math.max(0, n + this.baseIndent);
        String[] stringArray = this.parseLines(string, Math.max(1, this.width - n));
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3 = 0;
            while (n3 < n) {
                this.out.print(' ');
                ++n3;
            }
            this.out.print(stringArray[n2]);
            if (n2 < stringArray.length - 1) {
                this.out.println();
            }
            ++n2;
        }
        this.out.flush();
    }

    public void printLines(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.printLine();
            ++n2;
        }
    }

    public void printPage() {
        this.printLines(this.pageLineCount);
    }

    public void printPage(String string) {
        int n = this.getPageLineCount();
        String[] stringArray = this.parseLines(string, this.width);
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (n2 > 0 && n2 % n == 0 && !this.pauseToRead()) break;
            this.out.println(stringArray[n2]);
            ++n2;
        }
    }

    public boolean pauseToRead() {
        this.printLine();
        String string = CoreLocalizedStringResolver.resolve("com.installshield.boot.i18n.BootResources", "ttyDisplayCharQ");
        String string2 = CoreLocalizedStringResolver.resolve("com.installshield.boot.i18n.BootResources", "ttyDisplayReadText");
        String string3 = CoreLocalizedStringResolver.resolve("com.installshield.boot.i18n.BootResources", "ttyDisplayQuit", new String[]{string});
        String string4 = CoreLocalizedStringResolver.resolve("com.installshield.boot.i18n.BootResources", "ttyDisplayContinue", new String[]{string2});
        String string5 = this.prompt(string4, string3);
        this.printLine();
        return !string5.equalsIgnoreCase(CoreLocalizedStringResolver.resolve("com.installshield.boot.i18n.BootResources", "ttyDisplayCharQ"));
    }

    public int promptInt(CoreTTYPrompt coreTTYPrompt) {
        String string = this.prompt(coreTTYPrompt);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public String prompt(CoreTTYPrompt coreTTYPrompt) {
        String string = CoreLocalizedStringResolver.resolve("com.installshield.boot.i18n.BootResources", "ttyDisplayQuestionMark");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(coreTTYPrompt.getText());
        if (stringBuffer.length() > 0) {
            stringBuffer.append(" ");
        }
        if (coreTTYPrompt.hasDefaultValue()) {
            stringBuffer.append("[" + coreTTYPrompt.getDefaultValue() + "] ");
        }
        if (coreTTYPrompt.hasDescription()) {
            this.printIndentedLine(coreTTYPrompt.getDescription(), coreTTYPrompt.getIndent());
            this.printLine();
        }
        if (coreTTYPrompt.hasLegalOptions() && coreTTYPrompt.getPromptForOptionIndex()) {
            this.printOptions(coreTTYPrompt);
            this.printLine();
        }
        String string2 = null;
        boolean bl = false;
        while (!bl) {
            this.printIndented(stringBuffer.toString(), coreTTYPrompt.getIndent());
            try {
                boolean bl2;
                String string3 = this.in.readLine();
                if (string3 == null) {
                    System.exit(-1);
                }
                if (bl2 = string3.equals(string)) {
                    this.printLine();
                    if (coreTTYPrompt.hasHelpText()) {
                        this.printIndentedLine(coreTTYPrompt.getHelpText(), coreTTYPrompt.getIndent());
                    } else {
                        this.printIndentedLine(CoreLocalizedStringResolver.resolve("com.installshield.boot.i18n.BootResources", "ttyDisplayNoHelp"), coreTTYPrompt.getIndent());
                    }
                    this.printLine();
                } else {
                    string2 = string3.equals("") && coreTTYPrompt.hasDefaultValue() ? coreTTYPrompt.getDefaultValue() : string3;
                }
                if (bl2) continue;
                if (coreTTYPrompt.hasLegalOptions()) {
                    bl = this.validateOptions(coreTTYPrompt, string2);
                    continue;
                }
                if (coreTTYPrompt.hasMinMaxValues()) {
                    bl = this.validateMinMaxValues(coreTTYPrompt, string2);
                    continue;
                }
                bl = true;
            }
            catch (IOException iOException) {
                System.err.println("Read exception: " + iOException);
                string2 = "";
                bl = true;
            }
        }
        return string2;
    }

    public String promptPassword(String string) {
        if (System.getProperty("os.name").equals("OS/400")) {
            return this.prompt(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        PasswordThread passwordThread = new PasswordThread(string);
        passwordThread.start();
        block2: while (true) {
            try {
                while (true) {
                    char c;
                    if ((c = (char)System.in.read()) == '\n' || c == '\r') {
                        passwordThread.setStop();
                        while (System.in.available() > 0) {
                            System.in.read();
                        }
                        break block2;
                    }
                    stringBuffer.append(c);
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        return stringBuffer.toString();
    }

    private void printOptions(CoreTTYPrompt coreTTYPrompt) {
        String[] stringArray = coreTTYPrompt.getOptions();
        int n = 0;
        while (n < stringArray.length) {
            this.printIndentedLine(n + 1 + ". " + stringArray[n], coreTTYPrompt.getIndent() + 3);
            String string = coreTTYPrompt.getOptionDescription(n);
            if (string.length() > 0) {
                this.printLine();
                this.printIndentedLine(string, coreTTYPrompt.getIndent() + 6);
                this.printLine();
            }
            ++n;
        }
    }

    private boolean validateOptions(CoreTTYPrompt coreTTYPrompt, String string) {
        String[] stringArray = coreTTYPrompt.getOptions();
        if (coreTTYPrompt.getPromptForOptionIndex()) {
            int n = coreTTYPrompt.hasMinLegalValue() ? Math.min(1, coreTTYPrompt.getMinLegalValue()) : 1;
            int n2 = coreTTYPrompt.hasMaxLegalValue() ? Math.max(stringArray.length, coreTTYPrompt.getMaxLegalValue()) : stringArray.length;
            try {
                int n3 = Integer.parseInt(string);
                if (n3 >= n && n3 <= n2) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.printLine();
            this.printIndentedLine(CoreLocalizedStringResolver.resolve("com.installshield.boot.i18n.BootResources", "ttyDisplayEnterValueRange", new String[]{"" + n, "" + n2}), coreTTYPrompt.getIndent());
            this.printLine();
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (coreTTYPrompt.getIgnoreCase() && string.equalsIgnoreCase(stringArray[n]) || !coreTTYPrompt.getIgnoreCase() && string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < stringArray.length - 1) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("'" + stringArray[n4] + "'");
            ++n4;
        }
        String string2 = "'" + stringArray[stringArray.length - 1] + "'";
        this.printLine();
        this.printIndentedLine(CoreLocalizedStringResolver.resolve("com.installshield.boot.i18n.BootResources", "ttyDisplaySelectChoice", new String[]{stringBuffer.toString(), string2}), coreTTYPrompt.getIndent());
        this.printLine();
        return false;
    }

    private boolean validateMinMaxValues(CoreTTYPrompt coreTTYPrompt, String string) {
        try {
            int n = Integer.parseInt(string);
            if (n >= coreTTYPrompt.getMinLegalValue() && n <= coreTTYPrompt.getMaxLegalValue()) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.printLine();
        this.printIndentedLine(CoreLocalizedStringResolver.resolve("com.installshield.boot.i18n.BootResources", "ttyDisplayEnterValueRange", new String[]{"" + coreTTYPrompt.getMinLegalValue(), "" + coreTTYPrompt.getMaxLegalValue()}), coreTTYPrompt.getIndent());
        this.printLine();
        return false;
    }

    public String prompt(String string) {
        return this.prompt(new CoreTTYPrompt(string));
    }

    public String prompt(String string, String string2) {
        return this.prompt(new CoreTTYPrompt(string, string2));
    }

    public String prompt(String string, String string2, String string3) {
        return this.prompt(new CoreTTYPrompt(string, string2, string3));
    }

    public int promptInt(String string, int n, int n2, int n3) {
        return this.promptInt(string, n, n2, n3, "");
    }

    public int promptInt(String string) {
        return this.promptInt(string, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, "");
    }

    public int promptInt(String string, int n, int n2, int n3, String string2) {
        CoreTTYPrompt coreTTYPrompt = new CoreTTYPrompt(string);
        coreTTYPrompt.setDefaultValue(n);
        coreTTYPrompt.setMinLegalValue(n2);
        coreTTYPrompt.setMaxLegalValue(n3);
        coreTTYPrompt.setHelpText(string2);
        return this.promptInt(coreTTYPrompt);
    }

    private String[] parseLines(String string, int n) {
        Object object;
        if (n <= 0) {
            return new String[0];
        }
        Vector<Object> vector = new Vector<Object>();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() > n) {
                    object = "";
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        if (object.length() + string3.length() + 1 > n) {
                            vector.addElement(object);
                            object = string3;
                            continue;
                        }
                        object = !object.equals("") ? (String)object + " " + string3 : string3;
                    }
                    vector.addElement(object);
                    continue;
                }
                vector.addElement(string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public void printMessage(String string) {
        this.printMessage(string, CoreLocalizedStringResolver.resolve("com.installshield.boot.i18n.BootResources", "ttyDefaultMessagePrompt"));
    }

    public void printMessage(String string, String string2) {
        this.printLine(string);
        this.printLine();
        this.prompt("", string2);
    }

    public void printHRule() {
        if (!this.accessibilityEnabled) {
            int n = 0;
            while (n < this.width) {
                this.out.print('-');
                ++n;
            }
            this.out.println();
        }
    }

    public void printTable(CoreTTYTable coreTTYTable) {
        int[] nArray = this.calcColWidths(coreTTYTable);
        int n = 0;
        while (n < coreTTYTable.getRowCount()) {
            Vector<String[]> vector = new Vector<String[]>();
            int n2 = 1;
            int n3 = 0;
            while (n3 < coreTTYTable.getColCount()) {
                String[] stringArray = this.parseLines(coreTTYTable.getValue(n, n3), nArray[n3]);
                vector.addElement(stringArray);
                n2 = Math.max(n2, stringArray.length);
                ++n3;
            }
            int n4 = 0;
            while (n4 < n2) {
                this.fill(coreTTYTable.getIndent() + this.baseIndent);
                int n5 = 0;
                while (n5 < vector.size()) {
                    String[] stringArray = (String[])vector.elementAt(n5);
                    if (n5 > 0) {
                        this.fill(coreTTYTable.getColSpacing());
                    }
                    if (n4 < stringArray.length) {
                        this.out.print(stringArray[n4]);
                        if (n5 < vector.size() - 1) {
                            this.fill(nArray[n5] - stringArray[n4].length());
                        }
                    } else {
                        this.fill(nArray[n5]);
                    }
                    ++n5;
                }
                this.out.println();
                ++n4;
            }
            ++n;
        }
    }

    private void fill(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.out.print(' ');
            ++n2;
        }
    }

    private int[] calcColWidths(CoreTTYTable coreTTYTable) {
        int[] nArray = new int[coreTTYTable.getColCount()];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (coreTTYTable.getColWeight(n3) == 0) {
                nArray[n3] = coreTTYTable.getColWidth(n3);
                n += nArray[n3];
            } else {
                n2 += coreTTYTable.getColWeight(n3);
            }
            ++n3;
        }
        double d = this.width - coreTTYTable.getIndent() - n - (coreTTYTable.getColSpacing() & coreTTYTable.getColCount() - 1);
        int n4 = 0;
        while (n4 < nArray.length) {
            if (coreTTYTable.getColWeight(n4) > 0) {
                nArray[n4] = Math.max(0, (int)(d * ((double)coreTTYTable.getColWeight(n4) / (double)n2)));
            }
            ++n4;
        }
        return nArray;
    }

    private class PasswordThread
    extends Thread {
        private boolean stop = false;
        private String caption = "";

        public PasswordThread(String string) {
            this.caption = string;
        }

        public void run() {
            String string = this.caption.trim().endsWith(":") ? this.caption.substring(0, this.caption.lastIndexOf(58)) : this.caption;
            String string2 = "\r" + string + ": \r" + string + ":";
            while (!this.getStop()) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.getStop()) {
                    System.out.print(string2);
                }
                System.out.flush();
            }
        }

        public synchronized void setStop() {
            this.stop = true;
        }

        public synchronized boolean getStop() {
            return this.stop;
        }
    }
}

