/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot;

import com.installshield.boot.CoreFileUtils;
import com.installshield.boot.ZipInputStreamWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class CoreZipUtils {
    public static InputStream createZipInputStream(InputStream inputStream) {
        return new ZipInputStreamWrapper(inputStream);
    }

    public static void closeZipStream(ZipOutputStream zipOutputStream) throws IOException {
        block2: {
            try {
                zipOutputStream.finish();
                zipOutputStream.close();
            }
            catch (ZipException zipException) {
                if (zipException.getMessage().startsWith("ZIP file must have at least one entry")) break block2;
                throw zipException;
            }
        }
    }

    public static String removeProtocols(String string) {
        String string2 = string;
        boolean bl = false;
        while (!bl) {
            if (string2.startsWith("file:")) {
                string2 = string2.substring(5);
                continue;
            }
            bl = true;
        }
        return string2;
    }

    public static String cleanZipEntry(String string) {
        string = string.replace(File.separatorChar, '/');
        char[] cArray = new char[string.length()];
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = string.charAt(n2);
            if (n2 > 0 || c != '/') {
                cArray[n++] = c;
            }
            while (n2 < cArray.length - 1 && c == '/' && string.charAt(n2 + 1) == '/') {
                ++n2;
            }
            ++n2;
        }
        return new String(cArray, 0, n);
    }

    public static boolean isZipEmpty(String string) {
        boolean bl = true;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
            if (zipInputStream.getNextEntry() != null) {
                bl = false;
            }
            zipInputStream.close();
        }
        catch (IOException iOException) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    public static long getUncompressedSize(String string) {
        long l;
        block12: {
            l = 0L;
            ZipFile zipFile = null;
            zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                l += enumeration.nextElement().getSize();
            }
            Object var6_5 = null;
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
                break block12;
            }
            catch (Exception exception) {}
            break block12;
            {
                catch (IOException iOException) {
                    l = 0L;
                    Object var6_6 = null;
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return l;
    }

    /*
     * Loose catch block
     */
    public static void uncompress(String string, URL uRL) throws IOException {
        block27: {
            boolean bl = true;
            InputStream inputStream = uRL.openStream();
            ZipInputStream zipInputStream = null;
            ZipEntry zipEntry = null;
            try {
                zipInputStream = new ZipInputStream(inputStream);
                zipEntry = zipInputStream.getNextEntry();
                if (zipEntry != null) {
                    bl = false;
                } else {
                    try {
                        zipInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException iOException) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                bl = true;
            }
            if (bl) break block27;
            try {
                while (zipEntry != null) {
                    block26: {
                        Exception exception2222;
                        Object var13_15;
                        FileOutputStream fileOutputStream;
                        String string2 = zipEntry.getName();
                        string2 = string2.replace('/', File.separatorChar);
                        string2 = string2.replace('\\', File.separatorChar);
                        String string3 = CoreFileUtils.createFileName(string, string2);
                        File file = new File(string3);
                        if (zipEntry.isDirectory()) {
                            CoreFileUtils.createDirs(file);
                        } else {
                            String string4 = CoreFileUtils.getParent(string3);
                            if (string4 != null) {
                                CoreFileUtils.createDirs(new File(string4));
                            }
                            fileOutputStream = null;
                            fileOutputStream = new FileOutputStream(string3);
                            InputStream inputStream2 = CoreZipUtils.createZipInputStream(zipInputStream);
                            CoreFileUtils.copy(inputStream2, fileOutputStream);
                            var13_15 = null;
                            try {
                                if (fileOutputStream != null) {
                                    fileOutputStream.close();
                                }
                                break block26;
                            }
                            catch (Exception exception2222) {}
                        }
                        break block26;
                        catch (Throwable throwable) {
                            var13_15 = null;
                            try {
                                if (fileOutputStream != null) {
                                    fileOutputStream.close();
                                }
                            }
                            catch (Exception exception2222) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                    zipInputStream.closeEntry();
                    zipEntry = zipInputStream.getNextEntry();
                }
                Object var16_18 = null;
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                try {
                    if (zipInputStream != null) {
                        zipInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void compressDirectory(String string, String string2) throws IOException {
        Exception exception3;
        FileOutputStream fileOutputStream;
        block15: {
            File file = new File(string);
            File file2 = new File(string2);
            if (file.exists()) {
                throw new IOException("destination file (" + string + ") exists");
            }
            if (!file2.exists()) {
                throw new IOException("compress directory (" + string2 + ") does not exist");
            }
            if (!file2.isDirectory()) {
                throw new IOException("compress directory (" + string2 + ") is not a directory");
            }
            String string3 = CoreFileUtils.getParent(string);
            if (string3 != null) {
                CoreFileUtils.createDirs(new File(string3));
            }
            fileOutputStream = null;
            ZipOutputStream zipOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(string);
                zipOutputStream = new ZipOutputStream(fileOutputStream);
                CoreZipUtils.compressDirectoryContents(zipOutputStream, "", string2);
                ((FilterOutputStream)zipOutputStream).flush();
                zipOutputStream.finish();
                zipOutputStream.close();
                Object var8_7 = null;
                if (zipOutputStream == null) break block15;
            }
            catch (Throwable throwable) {
                Exception exception22;
                Object var8_8 = null;
                if (zipOutputStream != null) {
                    try {
                        zipOutputStream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                zipOutputStream.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception3) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void compressDirectoryContents(ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        File file = new File(CoreFileUtils.createFileName(string2, string));
        String[] stringArray = file.list();
        int n = 0;
        while (stringArray != null) {
            block9: {
                if (n >= stringArray.length) {
                    return;
                }
                String string3 = string.equals("") ? stringArray[n] : string + "/" + stringArray[n];
                String string4 = CoreFileUtils.createFileName(string2, string3);
                File file2 = new File(string4);
                if (file2.isFile()) {
                    IOException iOException2;
                    Object var13_12;
                    String string5 = CoreZipUtils.cleanZipEntry(string3);
                    ZipEntry zipEntry = new ZipEntry(string5);
                    zipOutputStream.putNextEntry(zipEntry);
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(string4);
                        CoreFileUtils.copy(fileInputStream, zipOutputStream);
                        zipOutputStream.closeEntry();
                        var13_12 = null;
                        if (fileInputStream == null) break block9;
                    }
                    catch (Throwable throwable) {
                        var13_12 = null;
                        if (fileInputStream == null) throw throwable;
                        try {
                            fileInputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException2) {}
                    fileInputStream.close();
                } else {
                    CoreZipUtils.compressDirectoryContents(zipOutputStream, string3, string2);
                }
            }
            ++n;
        }
    }
}

