/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot;

import com.installshield.boot.BootResourceCache;
import com.installshield.boot.CoreFileUtils;
import com.installshield.boot.CoreURLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;

public class EngineUtils {
    private static final String DEBUG_TAG = "is.debug";
    private static final String ENGINE_VERSION_KEY = "ENG_VER";
    private static final String ENGINE_UPDATE_VERSION_KEY = "ENG_UPDATE_VER";
    private static final String ENGINE_PROP_FILE = "engine.properties";
    private static final String EXT_ENGINE_VERSION_KEY = "ENG_VER";
    private static final String EXT_VERSION_KEY = "EXT_VER";
    private static final String EXT_PROP_FILE = "ext.properties";
    private static final String LIB_PROP_FILE = "lib.properties";
    private static final String LIB_VERSION_KEY = "LIB_VER";

    public static Properties loadEngineProperties(String string) throws IOException {
        return EngineUtils.loadProperties(string, ENGINE_PROP_FILE);
    }

    public static String getEngineVersion(String string) {
        return EngineUtils.getStringVersion(string, ENGINE_PROP_FILE, "ENG_VER");
    }

    public static int getEngineUpdateVersion(String string) {
        return EngineUtils.getIntVersion(string, ENGINE_PROP_FILE, ENGINE_UPDATE_VERSION_KEY);
    }

    public static String getEngineVersion(Properties properties) {
        return EngineUtils.getStringVersion(properties, "ENG_VER");
    }

    public static boolean isEngineExtension(String string) {
        boolean bl;
        block2: {
            bl = false;
            try {
                EngineUtils.loadProperties(string, EXT_PROP_FILE);
                bl = true;
            }
            catch (Exception exception) {
                if (System.getProperty(DEBUG_TAG) == null) break block2;
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public static Properties loadExtensionProperties(String string) throws IOException {
        return EngineUtils.loadProperties(string, EXT_PROP_FILE);
    }

    public static int getExtensionVersion(String string) {
        return EngineUtils.getIntVersion(string, EXT_PROP_FILE, EXT_VERSION_KEY);
    }

    public static int getExtensionVersion(Properties properties) {
        return EngineUtils.getIntVersion(properties, EXT_VERSION_KEY);
    }

    public static String getSupportedEngineVersion(String string) {
        return EngineUtils.getStringVersion(string, EXT_PROP_FILE, "ENG_VER");
    }

    public static String getSupportedEngineVersion(Properties properties) {
        return EngineUtils.getStringVersion(properties, "ENG_VER");
    }

    private static String getStringVersion(String string, String string2, String string3) {
        try {
            return EngineUtils.getStringVersion(EngineUtils.loadProperties(string, string2), string3);
        }
        catch (Exception exception) {
            if (System.getProperty(DEBUG_TAG) != null) {
                exception.printStackTrace();
            }
            return "";
        }
    }

    private static String getStringVersion(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        return string2 == null ? "" : string2;
    }

    private static int getIntVersion(String string, String string2, String string3) {
        try {
            return EngineUtils.getIntVersion(EngineUtils.loadProperties(string, string2), string3);
        }
        catch (Exception exception) {
            if (System.getProperty(DEBUG_TAG) != null) {
                exception.printStackTrace();
            }
            return -1;
        }
    }

    private static int getIntVersion(Properties properties, String string) {
        block3: {
            try {
                String string2 = properties.getProperty(string);
                if (string2 != null && string2.trim().length() != 0) {
                    return Integer.parseInt(string2);
                }
            }
            catch (Exception exception) {
                if (System.getProperty(DEBUG_TAG) == null) break block3;
                exception.printStackTrace();
            }
        }
        return -1;
    }

    private static Properties loadProperties(String string, String string2) throws IOException {
        Serializable serializable;
        InputStream inputStream = null;
        try {
            Properties properties = new Properties();
            if (string != null && string.trim().length() != 0) {
                serializable = new URL("archive", "", -1, CoreURLUtils.encodeArchiveURLPath(string + "+/" + string2));
                inputStream = ((URL)serializable).openStream();
                properties.load(inputStream);
            }
            serializable = properties;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            CoreFileUtils.close(inputStream);
            throw throwable;
        }
        CoreFileUtils.close(inputStream);
        return serializable;
    }

    public static boolean verifyInstalledEngine(String string, String string2) {
        boolean bl = false;
        try {
            String string3 = EngineUtils.getEngineVersion(string);
            if (string3 != null) {
                bl = string3.equals(string2);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static void installEngine(String string, String string2, String string3, boolean bl, String string4) throws IOException {
        File file = new File(string4);
        if (file.exists()) {
            if (!bl) {
                if (!EngineUtils.verifyInstalledEngine(string4, string2) && !BootResourceCache.deleteAccessedArchive(string4)) {
                    throw new IOException("repair engine jar failure: could not delete invalid existing engine: " + string4);
                }
            } else if (!BootResourceCache.deleteAccessedArchive(string4)) {
                throw new IOException("force engine jar install failure: could not delete existing engine: " + string4);
            }
        }
        if (!file.exists()) {
            String[] stringArray = EngineUtils.createParentDirs(string4);
            BootResourceCache.extractResourceFromArchive(string, string3, string4);
            if (!EngineUtils.verifyInstalledEngine(string4, string2)) {
                if (BootResourceCache.deleteAccessedArchive(string4)) {
                    try {
                        int n = stringArray.length - 1;
                        while (n >= 0) {
                            new File(stringArray[n]).delete();
                            --n;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new IOException("could not install engine jar: invalid engine version");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void installEngineExtension(String string, String string2, String string3, String string4) throws IOException {
        String string5 = null;
        boolean bl = false;
        try {
            String string6 = CoreFileUtils.createFileName(string2, string3);
            File file = new File(string6);
            if (file.exists() && file.isFile()) {
                string5 = string6;
            } else {
                string5 = CoreFileUtils.createTempFile();
                bl = true;
                BootResourceCache.extractResourceFromArchive(string2, string3, string5);
            }
            Properties properties = null;
            properties = EngineUtils.loadExtensionProperties(string5);
            String string7 = EngineUtils.getSupportedEngineVersion(properties);
            if (!string.equals(string7)) throw new IOException("incompatible engine extension (" + string3 + "): supports engine version " + string7);
            int n = EngineUtils.getExtensionVersion(properties);
            if (n == -1) throw new IOException("invalid engine extension (" + string3 + "): invalid extension version");
            boolean bl2 = true;
            File file2 = new File(string4);
            if (file2.exists()) {
                int n2 = EngineUtils.getExtensionVersion(string4);
                if (n2 != -1) {
                    if (n2 >= n) {
                        bl2 = false;
                    }
                } else if (System.getProperty(DEBUG_TAG) != null) {
                    System.err.println("could not obtain installed engine extension properties: " + string4);
                }
            }
            if (bl2) {
                if (file2.exists() && !BootResourceCache.deleteAccessedArchive(string4)) {
                    throw new IOException("could not delete installed engine extension: " + string4);
                }
                EngineUtils.copyFile(string5, string4);
            }
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            if (!bl || string5 == null || !new File(string5).exists() || !BootResourceCache.deleteAccessedArchive(string5)) throw throwable;
            CoreFileUtils.clearTempFile(string5);
            throw throwable;
        }
        if (!bl || string5 == null || !new File(string5).exists() || !BootResourceCache.deleteAccessedArchive(string5)) return;
        CoreFileUtils.clearTempFile(string5);
    }

    public static void installEngineLibrary(String string, String string2, String string3) throws IOException {
        String string4 = null;
        boolean bl = false;
        try {
            String string5 = CoreFileUtils.createFileName(string, string2);
            File file = new File(string5);
            if (file.exists() && file.isFile()) {
                string4 = string5;
            } else {
                string4 = CoreFileUtils.createTempFile();
                bl = true;
                BootResourceCache.extractResourceFromArchive(string, string2, string4);
            }
            File file2 = new File(string3);
            boolean bl2 = true;
            if (file2.exists() && (bl2 = EngineUtils.canReplaceLib(string3, string4)) && !BootResourceCache.deleteAccessedArchive(string3)) {
                throw new IOException("could not delete installed engine library: " + string3);
            }
            if (bl2 && new File(string4).exists()) {
                EngineUtils.copyFile(string4, string3);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (bl && string4 != null && new File(string4).exists() && BootResourceCache.deleteAccessedArchive(string4)) {
                CoreFileUtils.clearTempFile(string4);
            }
            throw throwable;
        }
        if (bl && string4 != null && new File(string4).exists() && BootResourceCache.deleteAccessedArchive(string4)) {
            CoreFileUtils.clearTempFile(string4);
        }
    }

    private static String[] createParentDirs(String string) throws IOException {
        File file = new File(CoreFileUtils.normalizeFileName(string));
        File file2 = new File(file.getParent());
        if (!file2.exists()) {
            return CoreFileUtils.createDirs(file2);
        }
        return new String[0];
    }

    private static boolean copyFile(String string, String string2) throws IOException {
        boolean bl = false;
        File file = new File(CoreFileUtils.getParent(string2));
        if (!file.exists()) {
            CoreFileUtils.createDirs(file);
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            fileOutputStream = new FileOutputStream(string2);
            CoreFileUtils.copy(fileInputStream, fileOutputStream);
            bl = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            CoreFileUtils.close(fileInputStream);
            CoreFileUtils.close(fileOutputStream);
            throw throwable;
        }
        CoreFileUtils.close(fileInputStream);
        CoreFileUtils.close(fileOutputStream);
        return bl;
    }

    public static void installCentralizedEngine(String string, String string2, int n, String string3, boolean bl, String string4) throws IOException {
        File file = new File(string4);
        if (file.exists() && EngineUtils.canReplaceEngine(string4, n) && !BootResourceCache.deleteAccessedArchive(string4)) {
            throw new IOException("repair engine jar failure: could not delete invalid existing engine: " + string4);
        }
        if (!file.exists()) {
            String[] stringArray = EngineUtils.createParentDirs(string4);
            BootResourceCache.extractResourceFromArchive(string, string3, string4);
            if (!EngineUtils.verifyInstalledEngine(string4, string2)) {
                if (BootResourceCache.deleteAccessedArchive(string4)) {
                    try {
                        int n2 = stringArray.length - 1;
                        while (n2 >= 0) {
                            new File(stringArray[n2]).delete();
                            --n2;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new IOException("could not install engine jar: invalid engine version");
            }
        }
    }

    public static boolean canReplaceEngine(String string, int n) {
        boolean bl = true;
        try {
            int n2 = EngineUtils.getEngineUpdateVersion(string);
            bl = n2 < n;
        }
        catch (Exception exception) {
            bl = true;
        }
        return bl;
    }

    public static boolean canReplaceLib(String string, String string2) {
        boolean bl = true;
        try {
            double d = EngineUtils.getEngineLibVersion(string);
            double d2 = EngineUtils.getEngineLibVersion(string2);
            bl = d < d2;
        }
        catch (Exception exception) {
            bl = true;
        }
        return bl;
    }

    public static Properties loadEngineLibProperties(String string) throws IOException {
        return EngineUtils.loadProperties(string, LIB_PROP_FILE);
    }

    private static double getEngineLibVersion(String string) {
        try {
            Properties properties = EngineUtils.loadEngineLibProperties(string);
            String string2 = properties.getProperty(LIB_VERSION_KEY);
            if (string2 != null && string2.trim().length() != 0) {
                return Double.parseDouble(string2);
            }
        }
        catch (Exception exception) {
            return 0.0;
        }
        return -1.0;
    }
}

