/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot.streamhandler;

import com.installshield.boot.streamhandler.ISInflaterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

class CompressedURLConnection
extends URLConnection {
    private URL internalURL = null;
    private InputStream in = null;
    private static String ARCHIVE_PROTOCOL = "archive:";
    private static String ISMP_FILE_PROTOCOL = "ismpfile:";

    CompressedURLConnection(URL uRL) throws MalformedURLException {
        super(uRL);
        String string = uRL.getFile();
        try {
            URL uRL2;
            int n;
            String string2;
            if (string.startsWith(ARCHIVE_PROTOCOL)) {
                string2 = "archive";
                n = "archive".length() + 1;
            } else if (string.startsWith(ISMP_FILE_PROTOCOL)) {
                string2 = "ismpfile";
                n = "ismpfile".length() + 1;
            } else {
                string2 = "file";
                n = 0;
            }
            this.internalURL = uRL2 = new URL(string2, "", -1, string.substring(n));
        }
        catch (MalformedURLException malformedURLException) {
            throw new MalformedURLException("Invalid internal URL designation: " + string);
        }
    }

    public void connect() {
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new ISInflaterInputStream(this.internalURL.openStream());
        }
        return this.in;
    }

    public void finalize() throws Throwable {
        this.internalURL = null;
        this.in = null;
        super.finalize();
    }
}

