/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot.streamhandler;

import com.installshield.boot.CoreZipUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ZipURLConnection
extends URLConnection {
    private static Hashtable openFiles = new Hashtable();
    private String fileName;
    private String entryName;
    private ZipFile zipFile = null;

    private static ZipFile getZipFile(String string) throws IOException {
        ZipFile zipFile = (ZipFile)openFiles.get(string);
        if (zipFile == null) {
            zipFile = new ZipFile(string);
            openFiles.put(string, zipFile);
        }
        return zipFile;
    }

    public static void closeAllOpenFiles(String string) throws IOException {
        Enumeration enumeration = openFiles.elements();
        while (enumeration.hasMoreElements()) {
            ((ZipFile)enumeration.nextElement()).close();
        }
        openFiles.clear();
    }

    public static void closeOpenFile(String string) throws IOException {
        ZipFile zipFile = (ZipFile)openFiles.get(string);
        if (zipFile != null) {
            zipFile.close();
            openFiles.remove(string);
        }
    }

    ZipURLConnection(URL uRL, String string, String string2) {
        super(uRL);
        this.fileName = string;
        this.entryName = CoreZipUtils.cleanZipEntry(string2);
    }

    public void connect() {
    }

    public InputStream getInputStream() throws IOException {
        ZipEntry zipEntry;
        if (this.zipFile == null) {
            this.zipFile = ZipURLConnection.getZipFile(this.fileName);
        }
        if ((zipEntry = this.zipFile.getEntry(this.entryName)) == null) {
            throw new IOException("entry " + this.entryName + " does not exist in " + this.fileName);
        }
        return CoreZipUtils.createZipInputStream(this.zipFile.getInputStream(zipEntry));
    }

    public String getContentType() {
        String string = this.entryName.toUpperCase();
        if (string.endsWith(".GIF")) {
            return "image/gif";
        }
        if (string.endsWith(".JPG") || string.endsWith(".JPEG")) {
            return "image/jpg";
        }
        return null;
    }

    protected void closeFile() throws IOException {
        if (this.zipFile != null && this.fileName != null) {
            ZipURLConnection.closeOpenFile(this.fileName);
            this.zipFile = null;
        }
    }
}

