/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Codebase;
import org.netbeans.jmi.javamodel.CodebaseClass;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKind;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.GuardedQuery;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MethodImpl;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.Utilities;

public final class CheckUtils {
    private static boolean is15Enabled;
    private static final boolean[][] assignVals;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Set getAllVariableNames(Feature feature) {
        HashSet<String> hashSet = new HashSet<String>();
        LinkedList<Feature> linkedList = new LinkedList<Feature>();
        linkedList.add(feature);
        while (!linkedList.isEmpty()) {
            VariableAccess variableAccess;
            Element element = (Element)linkedList.removeFirst();
            if (element instanceof VariableAccess && (variableAccess = (VariableAccess)element).getParentClass() == null && !variableAccess.isHasSuper()) {
                hashSet.add(variableAccess.getName());
            }
            linkedList.addAll(element.getChildren());
        }
        return hashSet;
    }

    public static boolean isFromLibrary(Resource resource) {
        CodebaseClass codebaseClass = ((JavaModelPackage)resource.refImmediatePackage()).getCodebase();
        Codebase codebase = (Codebase)codebaseClass.refAllOfClass().iterator().next();
        return codebase.isLibrary();
    }

    public static boolean membersEqual(NamedElement namedElement, NamedElement namedElement2) {
        if (!namedElement.getClass().equals(namedElement2.getClass())) {
            return false;
        }
        if (namedElement instanceof Method) {
            return ((MethodImpl)namedElement).signatureEquals((Method)namedElement2);
        }
        return namedElement.getName().equals(namedElement2.getName());
    }

    public static Collection isOverridden(Method method, String string, List list) {
        HashSet<Method> hashSet = new HashSet<Method>();
        if (!CheckUtils.isVirtual((Feature)method)) {
            return hashSet;
        }
        ClassDefinition classDefinition = method.getDeclaringClass();
        LinkedList linkedList = new LinkedList();
        CheckUtils.addSubtypes(classDefinition, linkedList);
        while (linkedList.size() > 0) {
            classDefinition = (ClassDefinition)linkedList.removeFirst();
            Method method2 = classDefinition.getMethod(string, list, false);
            if (method2 != null && CheckUtils.isVirtual((Feature)method2)) {
                hashSet.add(method2);
            }
            CheckUtils.addSubtypes(classDefinition, linkedList);
        }
        return hashSet;
    }

    public static Collection overrides(Method method, String string, List list, boolean bl) {
        HashSet<Method> hashSet = new HashSet<Method>();
        if (!CheckUtils.isVirtual((Feature)method)) {
            return hashSet;
        }
        ClassDefinition classDefinition = method.getDeclaringClass();
        LinkedList<ClassDefinition> linkedList = new LinkedList<ClassDefinition>();
        linkedList.addAll(classDefinition.getInterfaces());
        classDefinition = classDefinition.getSuperClass();
        if (classDefinition != null) {
            linkedList.add(classDefinition);
        }
        while (linkedList.size() > 0) {
            classDefinition = (ClassDefinition)linkedList.removeFirst();
            Method method2 = classDefinition.getMethod(string, list, false);
            if (method2 != null && CheckUtils.isVirtual((Feature)method2)) {
                if ((method2.getModifiers() & 0x10) > 0) {
                    hashSet.add(method2);
                    continue;
                }
                if (hashSet == null) {
                    hashSet.add(method2);
                    if (!bl) continue;
                }
            }
            linkedList.addAll(classDefinition.getInterfaces());
            if ((classDefinition = classDefinition.getSuperClass()) == null) continue;
            linkedList.add(classDefinition);
        }
        return hashSet;
    }

    public static boolean hasVarArgs(CallableFeature callableFeature) {
        Iterator iterator = callableFeature.getParameters().iterator();
        while (iterator.hasNext()) {
            if (!((Parameter)iterator.next()).isVarArg()) continue;
            return true;
        }
        return false;
    }

    public static boolean isVirtual(Feature feature) {
        int n = feature.getModifiers();
        return !Modifier.isPrivate(n);
    }

    public static JavaClass getClass(JavaPackage javaPackage, String string) {
        Iterator iterator = javaPackage.getResources().iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            Iterator iterator2 = resource.getClassifiers().iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                if (!(e instanceof JavaClass) || !string.equals(((JavaClass)e).getName())) continue;
                return (JavaClass)e;
            }
        }
        return null;
    }

    public static boolean isFolderEmpty(FileObject fileObject) {
        if (fileObject == null || fileObject.isVirtual() || !fileObject.isValid()) {
            return true;
        }
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        DataObject[] dataObjectArray = dataFolder.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            if (dataObjectArray[i] instanceof DataFolder) continue;
            return false;
        }
        return true;
    }

    public static boolean isElementReadOnly(Element element) {
        FileObject fileObject;
        if (element == null) {
            throw new IllegalArgumentException("Cannot pass null as an argument");
        }
        Resource resource = element.getResource();
        if (resource != null && (fileObject = JavaModel.getFileObject((Resource)resource)) != null) {
            return !fileObject.canWrite();
        }
        return false;
    }

    public static boolean isValidPackageName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            if (Utilities.isJavaIdentifier((String)stringTokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    public static boolean isRefactoringElementReadOnly(RefactoringElementImplementation refactoringElementImplementation) {
        Element element = refactoringElementImplementation.getJavaElement();
        if (element == null) {
            return !refactoringElementImplementation.getParentFile().canWrite();
        }
        return CheckUtils.isElementReadOnly(element);
    }

    public static boolean isRefactoringElementGuarded(RefactoringElementImplementation refactoringElementImplementation) {
        PositionBounds positionBounds;
        Resource resource;
        Element element = refactoringElementImplementation.getJavaElement();
        if (element != null && (resource = element.getResource()) != null && (positionBounds = refactoringElementImplementation.getPosition()) != null) {
            return GuardedQuery.isSectionGuarded((Resource)resource, (PositionBounds)positionBounds);
        }
        return false;
    }

    public static boolean isElementInOpenProject(Element element) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        Resource resource = element.getResource();
        if (!$assertionsDisabled && resource == null) {
            throw new AssertionError((Object)("el.getResource() returned null, el = " + element.toString()));
        }
        FileObject fileObject = JavaModel.getFileObject((Resource)resource);
        if (!$assertionsDisabled && fileObject == null) {
            throw new AssertionError((Object)("JavaModel.getFileObject(r) returned null, r = " + resource.getName()));
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (project != projectArray[i]) continue;
            return true;
        }
        return false;
    }

    public static String htmlize(String string) {
        String string2 = Utilities.replaceString((String)string, (String)"<", (String)"&lt;");
        string2 = Utilities.replaceString((String)string2, (String)">", (String)"&gt;");
        return string2;
    }

    public static String trimToEnd(String string) {
        int n;
        char[] cArray = string.toCharArray();
        for (n = cArray.length; n > 0 && Character.isWhitespace(cArray[n - 1]); --n) {
        }
        return string.substring(0, n);
    }

    public static boolean hasChildren(DataFolder dataFolder) {
        Enumeration enumeration = dataFolder.children(true);
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement() instanceof DataFolder) continue;
            return true;
        }
        return false;
    }

    public static boolean isAccessible(ClassDefinition classDefinition, JavaClass javaClass) {
        if (classDefinition == null) {
            return false;
        }
        if (javaClass == null) {
            return true;
        }
        while (classDefinition instanceof Array) {
            Type type = ((Array)classDefinition).getType();
            if (type instanceof ClassDefinition) {
                classDefinition = (ClassDefinition)type;
                continue;
            }
            return true;
        }
        return ((JavaClass)classDefinition).isInner() ? CheckUtils.isAccessible((Feature)((JavaClass)classDefinition), ((JavaClass)classDefinition).getDeclaringClass(), javaClass) : CheckUtils.isTopLevelClassAccessible((JavaClass)classDefinition, javaClass);
    }

    public static boolean isSubTypeOf(JavaClass javaClass, JavaClass javaClass2) {
        if (javaClass2 instanceof TypeParameter) {
            if (!CheckUtils.isSubTypeOf(javaClass, javaClass2.getSuperClass())) {
                return false;
            }
            Iterator iterator = javaClass2.getInterfaces().iterator();
            while (iterator.hasNext()) {
                if (CheckUtils.isSubTypeOf(javaClass, (JavaClass)iterator.next())) continue;
                return false;
            }
            return true;
        }
        if (javaClass.isSubTypeOf((ClassDefinition)javaClass2)) {
            List list;
            List list2 = javaClass instanceof ParameterizedType ? ((ParameterizedType)javaClass).getParameters() : new ArrayList();
            List list3 = list = javaClass2 instanceof ParameterizedType ? ((ParameterizedType)javaClass2).getParameters() : new ArrayList();
            if (list2.size() != list.size()) {
                return false;
            }
            Iterator iterator = list2.iterator();
            Iterator iterator2 = list.iterator();
            while (iterator.hasNext()) {
                if (CheckUtils.isAssignable((Type)iterator.next(), (Type)iterator2.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isAssignable(Type type, Type type2) {
        if (type == null || type2 == null) {
            return false;
        }
        if (type.equals(type2)) {
            return true;
        }
        if (type instanceof Array && type2 instanceof Array) {
            return CheckUtils.isAssignable(((Array)type).getType(), ((Array)type2).getType());
        }
        if (type2 instanceof PrimitiveType && (is15Enabled || type instanceof PrimitiveType)) {
            return assignVals[CheckUtils.getPrimitiveTypeIdx(type)][CheckUtils.getPrimitiveTypeIdx(type2)];
        }
        if (type2.getName().equals("java.lang.Object") && (is15Enabled || !(type instanceof PrimitiveType))) {
            return true;
        }
        if (type2 instanceof JavaClass && is15Enabled && type instanceof PrimitiveType) {
            return CheckUtils.isAssignable(CheckUtils.getObjectType((PrimitiveType)type), type2);
        }
        if (type instanceof JavaClass && type2 instanceof JavaClass) {
            return CheckUtils.isSubTypeOf((JavaClass)type, (JavaClass)type2);
        }
        return false;
    }

    private static void addSubtypes(ClassDefinition classDefinition, List list) {
        if (!(classDefinition instanceof JavaClass)) {
            return;
        }
        JavaClass javaClass = (JavaClass)classDefinition;
        Collection collection = null;
        collection = javaClass.isInterface() ? javaClass.getImplementors() : javaClass.getSubClasses();
        list.addAll(collection);
    }

    private static boolean isAccessible(Feature feature, ClassDefinition classDefinition, JavaClass javaClass) {
        ClassDefinition classDefinition2 = feature.getDeclaringClass();
        AccessibilityDescriptor accessibilityDescriptor = new AccessibilityDescriptor(classDefinition2, classDefinition, javaClass);
        return accessibilityDescriptor.isAccessible(feature.getModifiers());
    }

    private static String getPackageName(ClassDefinition classDefinition) {
        String string;
        Resource resource;
        if (classDefinition instanceof UnresolvedClass) {
            String string2 = classDefinition.getName();
            int n = string2.lastIndexOf(46);
            return n < 0 ? "" : string2.substring(0, n);
        }
        if (classDefinition instanceof JavaClass && (resource = classDefinition.getResource()) != null && (string = resource.getPackageName()) != null) {
            return string;
        }
        return "";
    }

    private static JavaClass getOutermostClass(JavaClass javaClass) {
        while (javaClass.isInner()) {
            JavaClass javaClass2 = (JavaClass)javaClass.getDeclaringClass();
            if (javaClass2 == null) {
                return javaClass;
            }
            javaClass = javaClass2;
        }
        return javaClass;
    }

    private static boolean isTopLevelClassAccessible(JavaClass javaClass, JavaClass javaClass2) {
        if (javaClass == null) {
            return false;
        }
        if (javaClass2 == null) {
            return true;
        }
        if ((javaClass.getModifiers() & 1) != 0) {
            return true;
        }
        String string = CheckUtils.getPackageName((ClassDefinition)javaClass);
        String string2 = CheckUtils.getPackageName((ClassDefinition)javaClass2);
        return string.equals(string2);
    }

    private static Type getObjectType(PrimitiveType primitiveType) {
        PrimitiveTypeKind primitiveTypeKind = primitiveType.getKind();
        if (PrimitiveTypeKindEnum.BOOLEAN.equals((Object)primitiveTypeKind)) {
            return CheckUtils.resolveType("java.lang.Boolean");
        }
        if (PrimitiveTypeKindEnum.BYTE.equals((Object)primitiveTypeKind)) {
            return CheckUtils.resolveType("java.lang.Byte");
        }
        if (PrimitiveTypeKindEnum.CHAR.equals((Object)primitiveTypeKind)) {
            return CheckUtils.resolveType("java.lang.Char");
        }
        if (PrimitiveTypeKindEnum.DOUBLE.equals((Object)primitiveTypeKind)) {
            return CheckUtils.resolveType("java.lang.Double");
        }
        if (PrimitiveTypeKindEnum.FLOAT.equals((Object)primitiveTypeKind)) {
            return CheckUtils.resolveType("java.lang.Float");
        }
        if (PrimitiveTypeKindEnum.INT.equals((Object)primitiveTypeKind)) {
            return CheckUtils.resolveType("java.lang.Integer");
        }
        if (PrimitiveTypeKindEnum.LONG.equals((Object)primitiveTypeKind)) {
            return CheckUtils.resolveType("java.lang.Long");
        }
        if (PrimitiveTypeKindEnum.SHORT.equals((Object)primitiveTypeKind)) {
            return CheckUtils.resolveType("java.lang.Short");
        }
        return null;
    }

    private static Type resolveType(String string) {
        if (!"null".equals(string)) {
            return JavaModel.getDefaultExtent().getType().resolve(string);
        }
        return null;
    }

    private static byte getPrimitiveTypeIdx(Type type) {
        PrimitiveTypeKind primitiveTypeKind;
        PrimitiveTypeKind primitiveTypeKind2 = primitiveTypeKind = type instanceof PrimitiveType ? ((PrimitiveType)type).getKind() : null;
        if ("java.lang.Boolean".equals(type.getName()) || PrimitiveTypeKindEnum.BOOLEAN.equals((Object)primitiveTypeKind)) {
            return 0;
        }
        if ("java.lang.Byte".equals(type.getName()) || PrimitiveTypeKindEnum.BYTE.equals((Object)primitiveTypeKind)) {
            return 1;
        }
        if ("java.lang.Char".equals(type.getName()) || PrimitiveTypeKindEnum.CHAR.equals((Object)primitiveTypeKind)) {
            return 2;
        }
        if ("java.lang.Double".equals(type.getName()) || PrimitiveTypeKindEnum.DOUBLE.equals((Object)primitiveTypeKind)) {
            return 3;
        }
        if ("java.lang.Float".equals(type.getName()) || PrimitiveTypeKindEnum.FLOAT.equals((Object)primitiveTypeKind)) {
            return 4;
        }
        if ("java.lang.Integer".equals(type.getName()) || PrimitiveTypeKindEnum.INT.equals((Object)primitiveTypeKind)) {
            return 5;
        }
        if ("java.lang.Long".equals(type.getName()) || PrimitiveTypeKindEnum.LONG.equals((Object)primitiveTypeKind)) {
            return 6;
        }
        if ("java.lang.Short".equals(type.getName()) || PrimitiveTypeKindEnum.SHORT.equals((Object)primitiveTypeKind)) {
            return 7;
        }
        return 8;
    }

    static {
        $assertionsDisabled = !CheckUtils.class.desiredAssertionStatus();
        is15Enabled = true;
        assignVals = new boolean[][]{{true, false, false, false, false, false, false, false, false}, {false, true, false, true, true, true, true, true, false}, {false, false, true, true, true, true, true, false, false}, {false, false, false, true, false, false, false, false, false}, {false, false, false, true, true, false, false, false, false}, {false, false, false, true, true, true, true, false, false}, {false, false, false, true, true, false, true, false, false}, {false, false, false, true, true, true, true, true, false}, {false, false, false, false, false, false, false, false, true}};
    }

    private static class AccessibilityDescriptor {
        int mprotected = -1;
        int mpackprivate = -1;
        int mprivate = -1;
        ClassDefinition decCls;
        ClassDefinition cls;
        JavaClass from;

        AccessibilityDescriptor(ClassDefinition classDefinition, ClassDefinition classDefinition2, JavaClass javaClass) {
            if (javaClass == null) {
                this.mprivate = 1;
                this.mpackprivate = 1;
                this.mprotected = 1;
                return;
            }
            if (classDefinition2 instanceof TypeParameter) {
                classDefinition2 = classDefinition;
            }
            if (classDefinition2 != null && !javaClass.equals(classDefinition2) && !CheckUtils.isAccessible(classDefinition2, javaClass)) {
                this.mprivate = 0;
                this.mpackprivate = 0;
                this.mprotected = 0;
                return;
            }
            this.decCls = classDefinition;
            this.cls = classDefinition2;
            this.from = javaClass;
        }

        private void computeProtectedAccess() {
        }

        private void computePackagePrivateAccess() {
            String string;
            String string2 = CheckUtils.getPackageName((ClassDefinition)this.from);
            boolean bl = string2.equals(string = CheckUtils.getPackageName(this.decCls));
            if (bl) {
                this.mpackprivate = 1;
                this.mprotected = 1;
            } else {
                this.mpackprivate = 0;
            }
        }

        private void computePrivateAccess() {
            boolean bl = CheckUtils.getOutermostClass(this.from).equals(this.decCls instanceof JavaClass ? CheckUtils.getOutermostClass((JavaClass)this.decCls) : null);
            if (bl) {
                this.mprivate = 1;
                this.mpackprivate = 1;
                this.mprotected = 1;
            } else {
                this.mprivate = 0;
            }
        }

        private boolean isAccessible(int n) {
            if (Modifier.isPublic(n)) {
                return true;
            }
            if (this.mprivate == -1) {
                this.computePrivateAccess();
            }
            if (this.mprivate == 1) {
                return true;
            }
            if (Modifier.isPrivate(n)) {
                return false;
            }
            if (this.mpackprivate == -1) {
                this.computePackagePrivateAccess();
            }
            if (this.mpackprivate == 1) {
                return true;
            }
            if (!Modifier.isProtected(n)) {
                return false;
            }
            return this.mprotected == 1;
        }
    }
}

