/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring;

import java.io.IOException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

public class CommentElement
extends SimpleRefactoringElementImpl {
    Resource resource;
    Element javaElement;
    int textoffset;
    String text;
    private String plainText;
    private PositionBounds bounds = null;
    private String htmlText;

    public CommentElement(int n, String string, Resource resource) {
        this.textoffset = n;
        this.text = string;
        this.resource = resource;
        this.computeText();
    }

    public String getDisplayText() {
        return "// " + this.htmlText;
    }

    public Element getJavaElement() {
        if (this.javaElement == null) {
            this.javaElement = this.resource.getElementByOffset(this.textoffset);
            while (!(this.javaElement instanceof Feature) && !(this.javaElement instanceof Resource)) {
                this.javaElement = (Element)this.javaElement.refImmediateComposite();
            }
        }
        return this.javaElement;
    }

    public FileObject getParentFile() {
        return JavaModel.getFileObject((Resource)this.resource);
    }

    public PositionBounds getPosition() {
        if (this.bounds == null) {
            String string = this.resource.getSourceText();
            int n = -1;
            int n2 = 0;
            DataObject dataObject = JavaMetamodel.getManager().getDataObject(this.resource);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            StyledDocument styledDocument = null;
            try {
                styledDocument = editorCookie.openDocument();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return this.bounds;
            }
            DataEditorSupport dataEditorSupport = (DataEditorSupport)dataObject.getCookie(EditorCookie.class);
            for (int i = 0; i < this.textoffset; ++i) {
                n2 = this.textoffset - i;
                if ((i = string.indexOf(10, i)) == -1) break;
                ++n;
            }
            int n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n) + n2;
            PositionRef positionRef = dataEditorSupport.createPositionRef(n3, Position.Bias.Forward);
            PositionRef positionRef2 = dataEditorSupport.createPositionRef(n3 + this.text.length(), Position.Bias.Forward);
            this.bounds = new PositionBounds(positionRef, positionRef2);
        }
        return this.bounds;
    }

    public String getText() {
        return this.plainText;
    }

    public void performChange() {
    }

    private void computeText() {
        String string = this.resource.getSourceText();
        int n = string.lastIndexOf(10, this.textoffset);
        int n2 = string.indexOf(10, this.textoffset);
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == -1) {
            n2 = string.length();
        }
        stringBuffer.append("<i>");
        stringBuffer.append(CheckUtils.htmlize(string.substring(n + 1, this.textoffset)));
        stringBuffer.append("<b>");
        stringBuffer.append(string.substring(this.textoffset, this.textoffset + this.text.length()));
        stringBuffer.append("</b>");
        stringBuffer.append(CheckUtils.trimToEnd(CheckUtils.htmlize(string.substring(this.textoffset + this.text.length(), n2))));
        stringBuffer.append("</i>");
        this.htmlText = stringBuffer.toString();
        this.plainText = string.substring(n + 1, n2);
    }
}

