/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.refactoring.CommentElement;
import org.netbeans.modules.refactoring.JavadocElement;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;

public class CommentFinder {
    Element source;
    String text;
    Set allResources = null;
    int minindex = 0;
    int maxindex = Integer.MAX_VALUE;

    public CommentFinder(Element element) {
        this.source = element;
        this.text = this.computeName();
        this.allResources = new HashSet();
        if (((MetadataElement)element).isTransient() || element instanceof Parameter) {
            Feature feature = JavaModelUtil.getDeclaringFeature((Element)this.source);
            this.minindex = feature.getStartOffset();
            this.maxindex = feature.getEndOffset() - 1;
        }
    }

    private String computeName() {
        String string;
        String string2 = null;
        if (this.source instanceof JavaClass) {
            string = ((JavaClass)this.source).getSimpleName();
        } else if (this.source instanceof JavaPackage) {
            string2 = string = ((JavaPackage)this.source).getName();
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string = string.substring(n + 1);
            }
        } else {
            string = this.source instanceof Constructor ? ((JavaClass)((Constructor)this.source).getDeclaringClass()).getSimpleName() : ((NamedElement)this.source).getName();
        }
        return string;
    }

    public Collection searchCommentsInResource(Resource resource) {
        if (resource != null && this.allResources.add(resource)) {
            Collection collection = this.searchJavaDocsInResource(resource);
            if (resource instanceof ResourceImpl) {
                collection.addAll(this.searchInPlainComments((ResourceImpl)resource));
            }
            return collection;
        }
        return Collections.EMPTY_LIST;
    }

    private Collection searchInPlainComments(ResourceImpl resourceImpl) {
        String string = resourceImpl.getSourceText();
        if (string != null) {
            int n;
            int n2 = 0;
            ArrayList<RefactoringElementImplementation> arrayList = new ArrayList<RefactoringElementImplementation>(1);
            n2 = 0;
            while (n2 < string.length() && (n = string.indexOf(this.text, n2)) != -1) {
                int n3;
                n2 = n + 1;
                if (n < this.minindex || n > this.maxindex || n != 0 && Character.isJavaIdentifierPart(string.charAt(n - 1)) || (n3 = n + this.text.length()) < string.length() && Character.isJavaIdentifierPart(string.charAt(n3)) || !resourceImpl.isComment(n)) continue;
                arrayList.add(this.createNewElement((Resource)resourceImpl, n));
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    private Collection searchJavaDocsInResource(Resource resource) {
        ArrayList arrayList = new ArrayList(1);
        Iterator iterator = resource.getClassifiers().iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            arrayList.addAll(this.searchText((ClassMember)javaClass));
            arrayList.addAll(this.searchJavaDocsInJavaClass(javaClass));
        }
        return arrayList;
    }

    private Collection searchJavaDocsInJavaClass(JavaClass javaClass) {
        Iterator iterator = javaClass.getContents().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            ClassMember classMember = (ClassMember)iterator.next();
            arrayList.addAll(this.searchText(classMember));
            if (!(classMember instanceof JavaClass)) continue;
            arrayList.addAll(this.searchJavaDocsInJavaClass((JavaClass)classMember));
        }
        return arrayList;
    }

    private Collection searchText(ClassMember classMember) {
        String string;
        int n = classMember.getStartOffset();
        if (n >= this.minindex && n <= this.maxindex && (string = classMember.getJavadocText()) != null) {
            int n2;
            int n3 = 0;
            ArrayList<RefactoringElementImplementation> arrayList = new ArrayList<RefactoringElementImplementation>(1);
            n3 = 0;
            while (n3 < string.length() && (n2 = string.indexOf(this.text, n3)) != -1) {
                int n4;
                n3 = n2 + 1;
                if (n2 != 0 && Character.isJavaIdentifierPart(string.charAt(n2 - 1)) || (n4 = n2 + this.text.length()) < string.length() && Character.isJavaIdentifierPart(string.charAt(n4))) continue;
                arrayList.add(this.createNewElement(classMember, n2));
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    protected RefactoringElementImplementation createNewElement(ClassMember classMember, int n) {
        return new JavadocElement(n, this.text, classMember);
    }

    protected RefactoringElementImplementation createNewElement(Resource resource, int n) {
        return new CommentElement(n, this.text, resource);
    }
}

